export default {
  "name": "ChartBar",
  "comment": "柱状图",
  "jsFiles": "/node_modules/echarts/dist/echarts.common.min.js",
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "categoryField",
          "comment": "数据分组字段名",
          "type": "String"
        },
        {
          "name": "series",
          "comment": "数据值字段设置",
          "type": "Dataset",
          "columns": [
            {
              "id": "name",
              "name": "图例名称",
              "type": "String",
              "width": "200px"
            },
            {
              "id": "dataField",
              "name": "数据值字段名",
              "type": "String",
              "width": "200px"
            }
          ]
        }
      ]
    },
    {
      "name": "showSetting",
      "comment": "显示设置",
      "type": "group",
      "items": [
        {
          "name": "showLegend",
          "comment": "显示图例",
          "type": "Switch"
        },
        {
          "name": "stack",
          "comment": "堆叠显示",
          "type": "Switch"
        },
        {
          "name": "showLabel",
          "comment": "显示标签",
          "type": "Switch",
          "default": true,
          "width": "60px"
        },
        {
          "name": "showLabelLine",
          "comment": "显示引导线",
          "type": "Switch",
          "width": "80px"
        },
        {
          "name": "showLoading",
          "comment": "显示加载动画",
          "type": "Switch"
        },
        {
          "name": "animation",
          "comment": "开启动画",
          "type": "Switch",
          "default": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "margin", "border", "other"],
  "defaultStyles": {
    "width": "480px",
    "height": "320px",
    "border": "1px solid #cccccc"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onBeforeBindData",
      "comment": "绑定数据前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "option",
        "type": "Object",
        "comment": "图表选项"
      }, {
        "name": "data",
        "type": "Object",
        "comment": "图表数据"
      }]
    }, {
      "name": "onAfterBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "option",
        "type": "Object",
        "comment": "图表选项"
      }, {
        "name": "data",
        "type": "Object",
        "comment": "图表数据"
      }]
    }]
}