import { ContainerComponent } from "../controller.js";

/**
 * 单元明细组件
 * @param {[type]} dataModel [description]
 */
export default class Cellitem extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Cellitem", dataModel, parent);
  }

  // get items() {
  //   if (this.dataModel.components) {
  //     for (var i = 0; i < this.dataModel.components.length; i++) {
  //     }
  //   }
  // }

  // set items(value) {
  // }

  //不是容器组件，但可以添加子组件
  get containerEl() { return this.el }

  get colWidth() { return this.dataModel.colWidth }

  set colWidth(value) {
    this.dataModel.colWidth = value;
    if (this._jqObj) {
      this._jqObj.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-cellitem-') >= 0) return ss[s];
        }
        return "";
      });
      this._jqObj.addClass("tfp-cellitem-" + value);
    }
  }
}