import TFPComponentRender from '../render.js'

export default class CellboxRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    if (getComponentsHtml) {
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent, retainStyleAttr);
    }
    return bodyHtml + indent;
  }

  getAttrClass() {
    let c = "";
    if (this.dataModel.direction) c += "tfp-cellbox-" + this.dataModel.direction;
    return c;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}