import { ContainerComponent } from "../controller.js";

/**
 * 单元组件
 * @param {[type]} dataModel [description]
 */
export default class Cellbox extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Cellbox", dataModel, parent);
  }

  //不是容器组件，但可以添加子组件
  get containerEl() { return this.el }

  get direction() { return this.dataModel.direction }

  set direction(value) {
    this.dataModel.direction = value;

    if (this._jqObj) {
      this._jqObj.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-cellbox-') >= 0) return ss[s];
        }
        return "";
      });
      if (value) this._jqObj.addClass("tfp-cellbox-" + value);
    }
  }
}