export default {
  "name": "CascaderRegion",
  "comment": "地区级联选择",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "regionType",
          "comment": "地区类型",
          "type": "Select",
          "default": 1,
          "options": [
            {
              "value": "1",
              "text": "省市"
            },
            {
              "value": "2",
              "text": "省市县"
            },
            {
              "value": "3",
              "text": "市县"
            },
            {
              "value": "4",
              "text": "市县乡"
            },
            {
              "value": "5",
              "text": "县乡"
            }
          ]
        },
        {
          "name": "rootParentId",
          "comment": "顶层地区代码",
          "type": "String",
          "default": "0"
        },
        {
          "name": "popupWidth",
          "comment": "弹出层列宽",
          "type": "String",
          "default": "180"
        },
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "placeHolder",
          "comment": "输入提示",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "encrypted",
          "comment": "加密发送",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "180px",
    "height": "30px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onFocus",
      "comment": "获得焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onBlur",
      "comment": "失去焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}