import Cascader from "../cascader/controller.phone.js";

/**
 * 地区级联选择
 * @param {[type]} dataModel [description]
 */
export default class CascaderRegion extends Cascader {

  constructor(__tfp, dataModel, parent) {
    var dm = dataModel;
    if (!dm) dm = {};
    dm.valueField = "code";
    dm.textField = "name";
    dm.idField = "code";
    dm.parentIdField = "parent_code";
    if (!dm.regionType) dm.regionType = 1;
    if (!dm.rootParentId) dm.rootParentId = 0;
    super(__tfp, dm, parent, "CascaderRegion");
  }

  get regionType() { return this.dataModel.regionType }
  set regionType(value) { this.dataModel.regionType = value }

  initRuntime() {
    super.initRuntime();
    var lsItemName = "_tfp_region_data_" + this.dataModel.regionType + "_" + this.dataModel.rootParentId;
    let data = localStorage.getItem(lsItemName);
    if (data) {
      this.bindData(JSON.parse(data));
      return;
    }
    //需要设置顶级地区代码
    if (this.dataModel.regionType > 2 && this.dataModel.rootParentId == 0) {
      console.log("请设置顶级地区代码！");
      return;
    }
    let that = this;
    this._tfp.use("Service", function () {
      let service = that._tfp.new("Service");
      service.path = "sys/service/data_dic/getRegionList.tbs";
      let args = {
        rootParentCode: 0,
        level: 3
      };
      if (that.dataModel.rootParentId) args.rootParentCode = that.dataModel.rootParentId;
      if (that.dataModel.regionType == 1) {
        args.level = 2;
      } else if (that.dataModel.regionType >= 4) {
        args.level = 4;
      }
      service.request(args, function (req, res) {
        localStorage.setItem(lsItemName, JSON.stringify(res.data));
        that.bindData(res.data);
      });
    });
  }
}