import TFPComponentRender from '../render.js'

export default class CascaderRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let pla = "";
    if (this.dataModel.placeHolder) pla = this.dataModel.placeHolder;

    html += indent + "\t<input type=\"text\" readonly placeholder=\"" + pla + "\"/>\r\n";
    html += indent + "\t<img src=\"" + this._tfp.rootPath
      + "/src/components/select/images/arrow-down-"
      + this._tfp.curPage.contentColorMode + ".png\" />\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}