export default {
  "name": "Cascader",
  "comment": "级联选择器",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "placeHolder",
          "comment": "输入提示",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "popupWidth",
          "comment": "弹出层列宽",
          "type": "String",
          "default": "200"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "typeCode",
          "comment": "数据字典",
          "type": "Switch"
        },
        {
          "name": "encrypted",
          "comment": "加密发送",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "valueField",
          "comment": "选项值字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "textField",
          "comment": "选项文本字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "idField",
          "comment": "节点主键字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "parentIdField",
          "comment": "父节点主键字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "rootParentId",
          "comment": "根节点主键值",
          "type": "String",
          "default": "0"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "160px",
    "height": "30px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onFocus",
      "comment": "获得焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onBlur",
      "comment": "失去焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}