import { FormInput } from "../controller.js";

/**
 * 地区选择组件
 * @param {[type]} dataModel [description]
 */
export default class Cascader extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Cascader", dataModel, parent);
    }
    this.nodes = {};
    this.rootNodes = [];
  }

  get value() { return this.dataModel.value ? this.dataModel.value : ""; }
  set value(value) {
    if (!isNull(value)) {
      if (isObj(value)) {
        this.dataModel.value = value.value;
      } else {
        this.dataModel.value = value;
      }
    } else {
      this.dataModel.value = "";
      this._jqObj.children("input").val('');

    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", this.dataModel.value);
    }
    if (!isNull(value) && this._jqObj) {
      if (isObj(value)) {
        this._jqObj.children("input").attr('data-value', value.value);

        if (value.level) this._jqObj.children("input").attr('data-level', value.level);
        if (value.id) this._jqObj.children("input").attr('nodeid', value.id);
        if (value.text) this._jqObj.children("input").val(value.text);
      } else {
        let val = value + "";
        let txt = "";
        if (this.nodes) {
          if (val.indexOf("/") > 0) {
            let arr = val.split("/");
            for (let i = 0; i < arr.length; i++) {
              let node = this.nodes[arr[i]];
              if (node) {
                if (txt != "") txt += "/";
                txt += node.name;
              }
            }
          } else {
            let node = this.nodes[val];
            if (node) {
              txt = node.name;
              while (node.parentId != 0) {
                let node = this.nodes[node.parentId];
                if (!node) break;
                txt = node.name + "/" + txt;
              }
            }
          }
        }
        this._jqObj.children("input").val(txt);
      }
    }
  }

  get text() {
    var ret = "";
    if (this._jqObj) ret = this._jqObj.children("input").val();
    return ret;
  }
  set text(value) {
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.children("input").attr("placeholder", value);
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  get idField() { return this.dataModel.idField }
  set idField(value) { this.dataModel.idField = value }

  get parentIdField() { return this.dataModel.parentIdField }
  set parentIdField(value) { this.dataModel.parentIdField = value }

  get rootParentId() { return this.dataModel.rootParentId }
  set rootParentId(value) { this.dataModel.rootParentId = value }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.valueField) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return false;
    }
    if (!this.dataModel.idField) {
      alert("请为[" + this.id + "]设置节点主键字段格式！");
      return false;
    }
    return true;
  }

  loadData() {
    super.loadData();
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.nodes = {};
    this.rootNodes = [];
    let nodeIdArr = [];
    for (var i = 0; i < data.length; i++) {
      var nodeData = data[i];
      var node = {};
      node.id = nodeData[this.dataModel.idField];
      node.value = nodeData[this.dataModel.valueField];
      node.name = nodeData[this.dataModel.textField];
      if (!this.dataModel.textField) node.name = nodeData[this.dataModel.valueField];
      node.parentId = nodeData[this.dataModel.parentIdField];
      node.data = nodeData;
      node.childNodes = [];
      this.nodes[node.id] = node;
      nodeIdArr.push(node.id);
    }

    //生成节点之间的关系
    for (var i = 0; i < nodeIdArr.length; i++) {
      var nodeId = nodeIdArr[i];
      var node = this.nodes[nodeId];
      if (node.parentId == this.dataModel.rootParentId) {
        this.rootNodes.push(nodeId);
      } else {
        var parentNode = this.nodes[node.parentId];
        if (parentNode) {
          parentNode.childNodes.push(nodeId);
        }
      }
    }

    this.value = this.dataModel.value + '';
  }

  setOptionsList(optionsList, value) {
    let that = this;
    let optionObj = {
      options: [],
      value: value
    };

    for (var i = 0; i < this.rootNodes.length; i++) {
      var node = this.nodes[this.rootNodes[i]];
      optionObj.options.push({
        value: node.value,
        text: node.name
      });
    }

    optionObj.onChange = function () {
      that.optionsOnChange(0);
    }

    optionsList.push(optionObj);
    this.setOptionsChildren(optionsList, value);
  }

  setOptionsChildren(optionsList, value) {
    let that = this;
    let node = this.nodes[value];
    if (node.childNodes.length == 0) return;
    let optionObj = {
      options: [],
      value: this.nodes[node.childNodes[0]].value
    };

    for (var i = 0; i < node.childNodes.length; i++) {
      var nodeChild = this.nodes[node.childNodes[i]];
      optionObj.options.push({
        value: nodeChild.value,
        text: nodeChild.name
      });
    }

    optionObj.onChange = function () {
      that.optionsOnChange(1);
    }

    optionsList.push(optionObj);
    this.setOptionsChildren(optionsList, this.nodes[node.childNodes[0]].value);
  }

  optionsOnChange(index) {
    let dataVal = window.popupList.getColumnVal(index);
    let node = this.nodes[dataVal];
    let dayCol = $(".tfp-popuplist-content-column").get(index + 1);
    $(dayCol).find(".tfp-popuplist-content-item").remove();
    $(dayCol).find(".tfp-popuplist-content-items").append("<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>")
    if (node.childNodes.length == 0) {
      $(dayCol).find(".tfp-popuplist-content-items").append("</div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>");
      return;
    };

    for (var i = 0; i < node.childNodes.length; i++) {
      var nodeChild = this.nodes[node.childNodes[i]];
      $(dayCol).find(".tfp-popuplist-content-items").append("<div class=\"tfp-popuplist-content-item\" data-value=\"" + nodeChild.value + "\">" + nodeChild.name + "</div>")
    }

    $(dayCol).find(".tfp-popuplist-content-items").append("<div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div><div class=\"tfp-popuplist-content-item\" data-value=\"\"></div>")
    this.optionsOnChange(index + 1);
  }

  initRuntime() {
    let that = this;
    this._jqObj.css("padding", "0px");
    this._jqObj.find("input").css("width", "100%");

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    }

    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      let optionsList = [];
      that.setOptionsList(optionsList, that.rootNodes[0]);
      window.popupList.show(optionsList, function (arr) {
        if (arr.length > 0) {
          let val = "";
          arr.forEach(item => {
            if (val != '' && item != '') val += '/';
            if (item != '') val += item;
          })
          that.value = val;
        } else {
          that.value = '';
        }
      });
    });
  }
}