import { FormInput } from "../controller.js";

/**
 * 级联选择器组件
 * @param {[type]} dataModel [description]
 */
export default class Cascader extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Cascader", dataModel, parent);
    }
    this.nodes = {};
    this.rootNodes = [];
    this.isLoad = false;
  }

  get value() { return this.dataModel.value ? this.dataModel.value : ""; }
  set value(value) {
    if (!isNull(value)) {
      if (isObj(value)) {
        this.dataModel.value = value.value;
      } else {
        this.dataModel.value = value;
      }
    } else {
      this.dataModel.value = "";
    }
    if (!isNull(value) && this._jqObj) {
      if (isObj(value)) {
        this._jqObj.children("input").attr('data-value', value.value);

        if (value.level) this._jqObj.children("input").attr('data-level', value.level);
        if (value.id) this._jqObj.children("input").attr('nodeid', value.id);
        if (value.text) this._jqObj.children("input").val(value.text);
      } else {
        let val = value + "";
        let txt = "";
        if (this.nodes) {
          if (val.indexOf("/") > 0) {
            let arr = val.split("/");
            for (let i = 0; i < arr.length; i++) {
              let node = this.nodes[arr[i]];
              if (node) {
                if (txt != "") txt += "/";
                txt += node.name;
              }
            }
          } else {
            let node = this.nodes[val];
            if (node) {
              txt = node.name;
              while (node.parentId != 0) {
                let node = this.nodes[node.parentId];
                if (!node) break;
                txt = node.name + "/" + txt;
              }
            }
          }
        }
        this._jqObj.children("input").val(txt);
      }
    }
  }

  get text() {
    var ret = "";
    if (this._jqObj) ret = this._jqObj.children("input").val();
    return ret;
  }
  set text(value) {
    if (this._jqObj) this._jqObj.children("input").val(value);
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.children("input").attr("placeholder", value);
  }

  get popupWidth() { return this.dataModel.popupWidth }
  set popupWidth(value) { this.dataModel.popupWidth = value }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  get idField() { return this.dataModel.idField }
  set idField(value) { this.dataModel.idField = value }

  get parentIdField() { return this.dataModel.parentIdField }
  set parentIdField(value) { this.dataModel.parentIdField = value }

  get rootParentId() { return this.dataModel.rootParentId }
  set rootParentId(value) { this.dataModel.rootParentId = value }

  get typeCode() { return this.dataModel.typeCode }
  set typeCode(value) { this.dataModel.typeCode = value }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.nodes = {};
    this.rootNodes = [];
    let nodeIdArr = [];
    for (var i = 0; i < data.length; i++) {
      var nodeData = data[i];
      var node = {};
      node.id = nodeData[this.dataModel.idField];
      node.value = nodeData[this.dataModel.valueField];
      node.name = nodeData[this.dataModel.textField];
      if (!this.dataModel.textField) node.name = nodeData[this.dataModel.valueField];
      node.parentId = nodeData[this.dataModel.parentIdField];
      node.data = nodeData;
      node.childNodes = [];
      this.nodes[node.id] = node;
      nodeIdArr.push(node.id);
    }

    //生成节点之间的关系
    for (var i = 0; i < nodeIdArr.length; i++) {
      var nodeId = nodeIdArr[i];
      var node = this.nodes[nodeId];
      if (node.parentId == this.dataModel.rootParentId) {
        this.rootNodes.push(nodeId);
      } else {
        var parentNode = this.nodes[node.parentId];
        if (parentNode) {
          parentNode.childNodes.push(nodeId);
        }
      }
    }
    if (this.dataModel.value) this.value = this.dataModel.value;
    this._jqObj.children("img").attr('src', '' + this._tfp.rootPath + '/src/components/select/images/arrow-down-' + this._tfp.curPage.contentColorMode + '.png');
    this._jqObj.children("img").css('margin-top', '10px');
    this.isLoad = true;
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.valueField) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return false;
    }
    if (!this.dataModel.idField) {
      alert("请为[" + this.id + "]设置节点主键字段格式！");
      return false;
    }
    return true;
  }

  loadData() {
    this._jqObj.children("img").attr('src', '' + this._tfp.rootPath + '/src/components/cascader/images/loading.gif');
    this._jqObj.children("img").css('margin-top', '-25px');

    super.loadData();
  }

  showMenuItems(nodeId, level) {
    let that = this;
    let node = this.nodes[nodeId];
    if (node.childNodes.length == 0) return;
    let menusEl = $(".tfp-cascader-menus");
    let html = "<div id=\"cascader-items-" + nodeId + "\" class=\"tfp-cascader-items\" style=\"flex-basis: " + that.dataModel.popupWidth + "px;\">";
    for (let i = 0; i < node.childNodes.length; i++) {
      let nodeChild = this.nodes[node.childNodes[i]];
      if (nodeChild.childNodes.length > 0) {
        html += "<div nodeid=\"" + nodeChild.id + "\" data-value=\"" + nodeChild.value + "\" data-level=\"" + (level + 1) + "\">" + nodeChild.name + "<span class='tfp-ci-arrow'></span></div>"
      } else {
        html += "<div nodeid=\"" + nodeChild.id + "\" data-value=\"" + nodeChild.value + "\" data-level=\"" + (level + 1) + "\">" + nodeChild.name + "</div>"
      }
    }
    html += "</div>";
    menusEl.css("width", (level + 1) * that.dataModel.popupWidth + "px");
    menusEl.append(html);
    $("#cascader-items-" + nodeId).find("div").click(function (e) {
      //实现菜单单击相关功能
      $(this).addClass('active').siblings().removeClass('active');

      let nodeChildItem = that.nodes[node.childNodes[$(this).index()]]
      if (nodeChildItem.childNodes.length == 0) {
        var childText = '';
        var childValue = '';
        var childLevel = '';
        for (var i = 0; i < $('.tfp-cascader-items').length; i++) {
          if (childText == '') {
            childText += $('.tfp-cascader-items .active').eq(i).text();
            childValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
            childLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
          } else {
            childText += '/';
            childText += $('.tfp-cascader-items .active').eq(i).text();
            childValue += '/';
            childValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
            childLevel += '|';
            childLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
          }
          if ($('.tfp-cascader-items .active').eq(i).children().length == 0) break;
        }
        that._jqObj.children("input").attr('data-value', childValue);
        that._jqObj.children("input").attr('data-level', childLevel);
        that._jqObj.children("input").attr('nodeid', nodeChildItem.id);
        that._jqObj.children("input").val(childText);

        that.setValue(childValue)
        that.closePicker()
      }

      $(this).parent().nextAll().remove();
      let nodeId = $(this).attr("nodeid");
      let level = parseInt($(this).attr("data-level"));
      that.showMenuItems(nodeId, level);
      e.stopPropagation();
    });
  }

  showPicker() {
    let offset = this._jqObj.offset();
    let width = this.dataModel.popupWidth;
    let top = offset.top + 31;
    let left = offset.left;
    let docWidth = document.documentElement.clientWidth;
    let docHeight = document.documentElement.clientHeight;
    //根据页面大小自动调整显示位置
    if ((left + width) > docWidth) {
      left = (offset.left + this._jqObj.outerWidth()) - width;
      if (left < 0) left = 0;
    }
    if ((top + 245) > docHeight) {
      top = offset.top - 245;
      if (top < 0) top = 0;
    }
    let html = "<div class=\"tfp-cascader-menus\" style=\"top: "
      + top + "px; left:" + left + "px; width: " + width + "px;\">";
    //默认显示第一层菜单
    html += "<div class=\"tfp-cascader-items\" style=\"flex-basis: " + width + "px;\">";
    for (let i = 0; i < this.rootNodes.length; i++) {
      let node = this.nodes[this.rootNodes[i]];
      if (node.childNodes.length > 0) {
        html += "<div nodeid=\"" + node.id + "\" data-value=\"" + node.value + "\" data-level=\"1\">" + node.name + "<span class='tfp-ci-arrow'></span></div>"
      } else {
        html += "<div nodeid=\"" + node.id + "\" data-value=\"" + node.value + "\" data-level=\"1\">" + node.name + "</div>"
      }
    }
    html += "</div>";
    html += "</div>";
    $("body").append(html);
    $("body").bind("click", this.closePicker);
    let that = this;
    $(".tfp-cascader-menus").find(".tfp-cascader-items").find("div").click(function (e) {
      //实现菜单单击相关功能
      $(this).addClass('active').siblings().removeClass('active');

      let nodeItem = that.nodes[that.rootNodes[$(this).index()]];
      if (nodeItem.childNodes.length == 0) {
        var nodeText = '';
        var nodeValue = '';
        var nodeLevel = '';
        for (var i = 0; i < $('.tfp-cascader-items').length; i++) {
          if (nodeText == '') {
            nodeText += $('.tfp-cascader-items .active').eq(i).text();
            nodeValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
            nodeLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
          } else {
            nodeText += '/';
            nodeText += $('.tfp-cascader-items .active').eq(i).text();
            nodeValue += '/';
            nodeValue += $('.tfp-cascader-items .active').eq(i).attr('data-value');
            nodeLevel += '|';
            nodeLevel += $('.tfp-cascader-items .active').eq(i).attr('data-level');
          }
          if ($('.tfp-cascader-items .active').eq(i).children().length == 0) break;
        }
        that._jqObj.children("input").attr('data-value', nodeValue);
        that._jqObj.children("input").attr('nodeid', nodeItem.id);
        that._jqObj.children("input").attr('data-level', nodeLevel);
        that._jqObj.children("input").val(nodeText);

        that.setValue(nodeValue)
        that.closePicker()
      }

      $(this).parent().nextAll().remove();
      let nodeId = $(this).attr("nodeid");
      let level = parseInt($(this).attr("data-level"));
      that.showMenuItems(nodeId, level);

      e.stopPropagation();
    });
  }

  closePicker() {
    $(".tfp-cascader-menus").remove();
  }

  setValue(value) {
    this.dataModel.value = value;
    this.valueOnChange();
    this.exeEventHandler("onChange", value);
    this._jqObj.find("input").focus();
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.css("padding-left", "0px");
      this._jqObj.find("img").css("display", "none");
      this._jqObj.find("input").css("padding-left", "0px");
    }

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    } else if (this.dataModel.typeCode) {
      this._tfp.use("Service", function () {
        let service = that._tfp.new("Service");
        service.path = "sys/service/data_dic/getDataDicList.tbs";
        service.request(null, function (req, res) {
          that.bindData(res.data);
        });
      });
    }

    this._jqObj.click(function (e) {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      if ($(".tfp-cascader-menus").length > 0) return;
      if (that.isLoad == false) return;

      that.showPicker();
      e.stopPropagation();
    });

    that._jqObj.hover(function () {
      if(that._tfp.curPage.bgColorMode=="light" && !(that.disabled || that.readonly)) {
        that._jqObj.css("background-color", "#F6F6F6");
        that._jqObj.find("input").css("background-color", "#F6F6F6");
      }
      if (that.isLoad == false) return;
      if (that._jqObj.children("input").val() != '') {
        that._jqObj.children("img").attr('src', '' + that._tfp.rootPath + '/src/components/select/images/close-' + that._tfp.curPage.contentColorMode + '.png');
      }
      that._jqObj.find('img').on('click', function (e) {
        if (that._jqObj.children("input").val() != '') {
          e.stopPropagation();
          that._jqObj.children("input").removeAttr('data-value')
          that._jqObj.children("input").removeAttr('nodeid')
          that._jqObj.children("input").removeAttr('data-level')
          that._jqObj.children("input").val('')
          that.setValue(that._jqObj.children("input").val())
        }
      });
    }, function () {
      if(that._tfp.curPage.bgColorMode=="light" && !(that.disabled || that.readonly) && !that._jqObj.find("input").is(":focus")) {
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
      if (that.isLoad == false) return;
      if ($(".tfp-cascader-menus").length == 0) {
        that._jqObj.children("img").attr('src', '' + that._tfp.rootPath + '/src/components/select/images/arrow-down-' + that._tfp.curPage.contentColorMode + '.png');
      } else {
        that._jqObj.children("img").attr('src', '' + that._tfp.rootPath + '/src/components/select/images/arrow-down-' + that._tfp.curPage.contentColorMode + '.png');
      }
    })

    this._jqObj.find("input").focus(function () {
      if (that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") 
        that._jqObj.css("outline", "1px solid var(--sys-theme-color)");
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find("input").blur(function () {
      if (that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") 
        that._jqObj.css("outline", "0");
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    })
  }
}