import { FormInput } from "../controller.js";

/**
 * 日历
 * @param {[type]} dataModel [description]
 */
export default class Calendar extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Calendar", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value }
  set value(value) {
    if (value) {
      this.dataModel.value = new Date(value).format("yyyy-MM-dd");
    } else {
      this.dataModel.value = new Date().format("yyyy-MM-dd");
    }

    if (this._jqObj) {
      this._jqObj.find("div").eq(0).attr("data-value", this.dataModel.value)
      this.reRender(this.dataModel.value)
    }

    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      if (this.dataModel.onChange) {
        eval(this.dataModel.onChange);
      }
    }
  }

  reRender(date) {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml(date));

    if (!this._tfp.isDesigning) {
      this.datePickerValueChange();
    }
  }

  getBodyHtml(date) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";
    let val = new Date();
    if (date) val = new Date(date);

    let imgDir = this._tfp.rootPath + "/src/components/calendar/images/";
    html += indent + "<div style=\"width:100%;height:30px;border-bottom: 1px solid #CCCCCC;\" data-value=" + val.format("yyyy-MM-dd") + ">"
      + "<div class=\"tfp-calendar-header\">"
      + "<div style=\"width:16px;\" title=\"上一年\"><img src=\"" + imgDir + "double-arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;\" title=\"上一月\"><img src=\"" + imgDir + "arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:166px; text-align:center;\">"
      + "<input ";
    if (this._tfp.isDesigning) html += "readonly";
    html += " class=\"tfp-calendar-year\" type=\"text\" value=" + val.getFullYear() + " /> 年 ";
    html += "<input ";
    if (this._tfp.isDesigning) html += "readonly";
    html += " class=\"tfp-calendar-month\" type=\"text\" value=" + (val.getMonth() + 1) + " /> 月";
    html += "</div>"
      + "<div style=\"width:16px;\" title=\"下一月\"><img src=\"" + imgDir + "arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;\" title=\"下一年\"><img src=\"" + imgDir + "double-arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "</div></div>";
    html += "<div style=\"width:100%;height:230px;\">"
      + "<div class=\"tfp-calendar-grid\">"
      + "<div class=\"tfp-calendar-grid-header\">"
      + "<div>一</div><div>二</div><div>三</div><div>四</div><div>五</div><div>六</div><div>日</div>"
      + "</div>";
    html += this.getDatePickerValue(val);
    html += "</div></div>";
    return html + "\t";
  }

  getDatePickerValue(date) {
    let firstDate = new Date(date.format("yyyy-MM-01"));
    let curWeek = firstDate.getDay();
    if (curWeek == 0) curWeek = 7;
    curWeek--;
    if (curWeek > 0) firstDate.setDate(firstDate.getDate() - curWeek);

    let grid = '';

    var index = 0;
    for (var i = 0; i < 6; i++) {
      let rowHtml = "<div class=\"tfp-calendar-grid-row\">";
      for (var j = 0; j < 7; j++) {
        let dateTmp = new Date(firstDate.format("yyyy-MM-dd"));
        dateTmp.setDate(dateTmp.getDate() + index);
        let colorClass = "";
        if (this.dataModel.value && dateTmp.format("yyyy-MM-dd") == this.dataModel.value) {
          colorClass = "tfp-calendar-choose";
        } else if (!this.dataModel.value && dateTmp.format("yyyy-MM-dd") == new Date().format("yyyy-MM-dd")) {
          colorClass = "tfp-calendar-choose";
        } else if (dateTmp.format("yyyy-MM") != date.format("yyyy-MM")) {
          colorClass = "tfp-calendar-nochoose";
        }
        rowHtml += "<div data-value=\"" + dateTmp.format("yyyy-MM-dd")
          + "\" class=\"" + colorClass + "\">" + dateTmp.format("dd") + "</div>";
        index++;
      }
      rowHtml += "</div>";
      grid += rowHtml;
    }
    return grid;
  }

  datePickerValueChange() {
    let that = this;
    let grid = $(".tfp-calendar-grid");
    $(".tfp-calendar-header").find("img").each(function (index) {
      $(this).click(function () {
        if (index == 0) {
          that.toPrevYear();
        } else if (index == 1) {
          that.toPrevMonth();
        } else if (index == 2) {
          that.toNextMonth();
        } else if (index == 3) {
          that.toNextYear();
        }
        event.stopPropagation();
      });
    });
    $(".tfp-calendar-header").find("input").eq(0).change(function () {
      var reyear = /^(1949|19[5-9]\d|20\d{2}|2100)$/;
      var date = new Date($(".tfp-calendar").find("div").eq(0).attr("data-value"));
      var dateYear = new Date($(this).val()).getFullYear();

      if (!reyear.test(dateYear)) {
        $(".tfp-calendar-header").find("input").eq(0).val(date.getFullYear());
        that.reRender(date);
        return;
      }

      date.setYear(dateYear);
      that.reRender(date);
    })
    $(".tfp-calendar-header").find("input").eq(1).change(function () {
      var remonth = /0?[0-9]|1[0-2]/;
      var date = new Date($(".tfp-calendar").find("div").eq(0).attr("data-value"));
      var dateMonth = new Date($(this).val()).getMonth();

      if (!remonth.test(dateMonth)) {
        $(".tfp-calendar-header").find("input").eq(1).val(date.getMonth());
        that.reRender(date);
        return;
      }

      date.setMonth(dateMonth);
      that.reRender(date);
    })
    grid.find(".tfp-calendar-grid-row").each(function () {
      $(this).find("div").click(function () {
        that.value = new Date($(this).attr("data-value")).format("yyyy-MM-dd");
        that.reRender(that.value);
      });
    });
  }

  toPrevYear() {
    var date = new Date($(".tfp-calendar").find("div").eq(0).attr("data-value"));
    date.setYear(date.getFullYear() - 1);
    this.reRender(date)
  }

  toPrevMonth() {
    let date = new Date($(".tfp-calendar").find("div").eq(0).attr("data-value"));
    date.setMonth(date.getMonth() - 1);
    this.reRender(date)
  }

  toNextYear() {
    var date = new Date($(".tfp-calendar").find("div").eq(0).attr("data-value"));
    date.setYear(date.getFullYear() + 1);
    this.reRender(date)
  }

  toNextMonth() {
    let date = new Date($(".tfp-calendar").find("div").eq(0).attr("data-value"));
    date.setMonth(date.getMonth() + 1);
    this.reRender(date)
  }

  initRuntime() {
    let that = this;

    if (that.dataModel.readonly || that.dataModel.disabled) return that.getBodyHtml();
    if (that.dataModel.value) that.reRender(that.dataModel.value);
    else that.reRender();
  }
}