import TFPComponentRender from '../render.js'

export default class ButtonRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getSpecialClass() {
    let classHtml = " tfp-button-" + (this.dataModel.buttonType ? this.dataModel.buttonType : "default");
    if (this.dataModel.plain) classHtml += "-plain";
    classHtml += " tfp-button-" + (this.dataModel.theme ? this.dataModel.theme : "rect");
    return classHtml;
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);
    if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0)
      attrHtml += " readonly";
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();

    if (this.dataModel.value) {
      bodyHtml += indent + "\t<label style=\"line-height:" + this._tfp.formatPx(this.cpt.labelHeight)
        + ";\">" + this.dataModel.value + "</label>\r\n";
    }

    return bodyHtml + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    if (this.dataModel.value) cpt_wx.wxml = this.dataModel.value;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("button", false, parentIndent, retainStyleAttr, otherOptions);
  }
}