import TFPComponentRender from '../render.js'

export default class ButtonRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getSpecialClass() {
    let classHtml = " tfp-button-" + (this.dataModel.buttonType ? this.dataModel.buttonType : "default");
    if (this.dataModel.plain) classHtml += "-plain";
    classHtml += " tfp-button-" + (this.dataModel.theme ? this.dataModel.theme : "rect");
    classHtml += " tfp-button-" + (this.dataModel.portrait ? "column" : "row");
    return classHtml;
  }

  getAttrHtml(retainStyleAttr) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);
    if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0)
      attrHtml += " readonly";
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    let fontWeight = "";
    if (this.dataModel.labelWeight) fontWeight = "font-weight:bold;";
    if (this.dataModel.showImage) {
      let imgUrl = this.dataModel.imageUrl;
      if (!imgUrl) {
        imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";
      } else if (this._tfp.isDesigning) {
        if (imgUrl.indexOf("tfp-button-icon")<0) imgUrl = this._tfp.getUrlRealPath(imgUrl);
      }
      let imgWidth = 20;
      if (this.dataModel.imageWidth) imgWidth = parseInt(this.dataModel.imageWidth);
      let imgHeight = 20;
      if (this.dataModel.imageHeight) imgHeight = parseInt(this.dataModel.imageHeight);
      let labelColor = '';
      if (this.dataModel.labelColor) labelColor = "color:" + this.dataModel.labelColor + ";";
      let imgHtml = '';
      if (imgUrl.indexOf("tfp-button-icon")<0) {
        imgHtml = indent + "\t<img src=\"" + imgUrl + "\" width=\"" + imgWidth + "\" height=\""
          + imgHeight + "\" style=\"margin-top:3px; margin-bottom:3px;\" />\r\n";
      } else {
        let fontSize = imgWidth ? imgWidth : imgHeight;
        imgHtml = indent + "\t<span class=\"" + imgUrl + "\" style=\"font-size:" + fontSize + "px;margin-top:3px; margin-bottom:3px;" + labelColor + "\"></span>\r\n";
      }

      if (this.dataModel.hiddenText) {
        bodyHtml += indent + "\t" + imgHtml + "\r\n";
        bodyHtml += indent + "\t<label style=\"display:none;line-height:" + this._tfp.formatPx(this.cpt.labelHeight)
          + ";font-size:14px;\">" + this.dataModel.value + "</label>\r\n";
      } else {
        if (this.dataModel.portrait) {
          bodyHtml += indent + "\t" + imgHtml + "\r\n";
          bodyHtml += indent + "\t<label style=\"line-height:" + this._tfp.formatPx(this.cpt.labelHeight)
            + ";font-size:" + this._tfp.formatPx(this.cpt.labelSize)
            + ";" + labelColor + "" + fontWeight + "\">" + this.dataModel.value + "</label>\r\n";
        } else {
          bodyHtml += indent + "\t" + imgHtml + "\r\n";
          bodyHtml += indent + "\t<label style=\"margin-left:7px;line-height:" + this._tfp.formatPx(this.cpt.labelHeight)
            + ";font-size:" + this._tfp.formatPx(this.cpt.labelSize)
            + ";" + labelColor + "" + fontWeight + "\">" + this.dataModel.value + "</label>\r\n";
        }
      }
    } else {
      if (this.dataModel.value) {
        bodyHtml += indent + "\t<label style=\"line-height:" + this._tfp.formatPx(this.cpt.labelHeight)
          + ";font-size:" + this._tfp.formatPx(this.cpt.labelSize) + ";";
        if (this.dataModel.labelColor) bodyHtml += "color:" + this.dataModel.labelColor + ";";
        if (fontWeight) bodyHtml += "" + fontWeight + "";
        bodyHtml += "\">" + this.dataModel.value + "</label>\r\n";
      }
    }
    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}