export default {
  "name": "Button",
  "comment": "按钮",
  "cssFiles": [
    "style.{bgColorMode}.css",
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    }
  ],
  "attrs": [
    {
      "name": "buttonInfo",
      "comment": "按钮信息",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "按钮文本",
          "type": "String",
          "default": "{id}"
        },
        {
          "name": "buttonType",
          "comment": "按钮类型",
          "type": "Select",
          "options": [
            {
              "value": "default",
              "text": "默认按钮"
            },
            {
              "value": "primary",
              "text": "主要按钮"
            },
            {
              "value": "info",
              "text": "信息按钮"
            },
            {
              "value": "warning",
              "text": "警告按钮"
            },
            {
              "value": "success",
              "text": "成功按钮"
            },
            {
              "value": "danger",
              "text": "危险按钮"
            }
          ]
        },
        {
          "name": "theme",
          "comment": "按钮风格",
          "type": "Select",
          "options": [
            {
              "value": "rect",
              "text": "默认"
            },
            {
              "value": "round",
              "text": "圆角矩形"
            },
            {
              "value": "circle",
              "text": "椭圆形"
            }
          ]
        },
        {
          "name": "plain",
          "comment": "浅色背景",
          "type": "Switch"
        },
        {
          "name": "title",
          "comment": "组件提示",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "labelSetting",
      "comment": "文本设置",
      "type": "group",
      "items": [
        {
          "name": "labelSize",
          "comment": "文本字号",
          "type": "Int",
          "default": 14
        },
        {
          "name": "labelHeight",
          "comment": "文本高度",
          "type": "Int",
          "default": "30"
        },
        {
          "name": "labelColor",
          "comment": "文本颜色",
          "type": "Color"
        },
        {
          "name": "labelWeight",
          "comment": "文本加粗",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "imageSetting",
      "comment": "图标设置",
      "type": "group",
      "items": [
        {
          "name": "showImage",
          "comment": "显示图标",
          "type": "Switch"
        },
        {
          "name": "imageUrl",
          "comment": "图标",
          "type": "IconPicker",
          "fileTypes": ["image"],
          "hidden": "'{showImage}'!='true'"
        },
        {
          "name": "imageWidth",
          "comment": "图标宽度",
          "type": "Int",
          "default": 16,
          "hidden": "'{showImage}'!='true'"
        },
        {
          "name": "imageHeight",
          "comment": "图标高度",
          "type": "Int",
          "default": 16,
          "hidden": "'{showImage}'!='true'"
        },
        {
          "name": "portrait",
          "comment": "竖向显示",
          "type": "Switch",
          "hidden": "'{showImage}'!='true' || '{hiddenText}'=='true'"
        },
        {
          "name": "hiddenText",
          "comment": "隐藏文字",
          "type": "Switch",
          "hidden": "'{showImage}'!='true'"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "cursor": "pointer",
    "padding-left": "10px",
    "padding-right": "10px",
    "text-align": "center"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时",
      "isNotHtmlEvent": true
    }, {
      "name": "onFocus",
      "comment": "获得焦点时"
    }, {
      "name": "onBlur",
      "comment": "失去焦点时"
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }, {
      "name": "onMouseOver",
      "comment": "鼠标经过时"
    }, {
      "name": "onMouseOut",
      "comment": "鼠标移出时"
    }]
}