import { VisibleComponent } from "../controller.js";

/**
 * 按钮组件
 * @param {[type]} dataModel [description]
 */
export default class Button extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Button", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.find("label").text(value);
      this.exeEventHandler("onChange");
    }
  }

  get buttonType() { return this.dataModel.buttonType }
  set buttonType(value) {
    this.dataModel.buttonType = value;

    if (this._jqObj) {
      this._jqObj.removeClass("wx-button-primary");
      this._jqObj.removeClass("wx-button-default");
      this._jqObj.removeClass(" wx-button-warn");
      this._jqObj.addClass("wx-button-" + value);
    }
  }

  get sizeType() { return this.dataModel.sizeType }
  set sizeType(value) {
    this.dataModel.sizeType = value;
    if (this._jqObj) {
      if (value) {
        this._jqObj.attr("size", "mini");
      } else {
        this._jqObj.removeAttr("size");
      }
    }
  }

  get plain() { return this.dataModel.plain }
  set plain(value) {
    this.dataModel.plain = value ? true : false;
    if (this._jqObj) {
      this._jqObj.attr("plain", true);
      if (!value) {
        this._jqObj.removeAttr("plain");
      }

    }
  }

  get buttonDisabled() { return this.dataModel.buttonDisabled }
  set buttonDisabled(value) {
    this.dataModel.buttonDisabled = value;
    // this.dataModel.buttonDisabled = value ? true : false;
    if (this._jqObj) {
      this._jqObj.attr("disabled", true);
      if (!value) {
        this._jqObj.removeAttr("disabled");
      }
    }
  }

  get loading() { return this.dataModel.loading }
  set loading(value) {
    this.dataModel.loading = value;
    if (this._jqObj) {
      if (value) {
        let imgUrl = this._tfp.rootPath + "/src/components/button/images/lodding.png";
        let str = `<div class="lodding"> <img class="loddingImg" src="${imgUrl}"   /> </div>`
        this._jqObj.prepend(str)
      } else {
        this._jqObj.find(".lodding").remove();
        this._jqObj.removeAttr("lodding");
      }
    }
  }

  get formType() { return this.dataModel.formType }
  set formType(value) {
    this.dataModel.formType = value;
  }

  get opentype() { return this.dataModel.opentype }
  set opentype(value) {
    this.dataModel.opentype = value;
  }

}