import { VisibleComponent } from "../controller.js";

/**
 * 按钮组件
 * @param {[type]} dataModel [description]
 */
export default class Button extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Button", dataModel, parent);
  }

  get value() { return this.dataModel.value }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.find("label").text(value);
      this.exeEventHandler("onChange");
    }
  }

  get buttonType() { return this.dataModel.buttonType }
  set buttonType(value) {
    let buttonType = "default";
    if (value) buttonType = value;
    if (!this.checkAttrOption("buttonType", buttonType)) {
      this._tfp.showMsg("按钮组件不支持类型：" + buttonType + "！");
      return;
    }
    this.dataModel.buttonType = buttonType;
    if (this._jqObj) {
      this._jqObj.removeClass("tfp-button-default tfp-button-primary tfp-button-info"
        + " tfp-button-warning tfp-button-success tfp-button-danger");
      this._jqObj.removeClass("tfp-button-default-plain tfp-button-primary-plain tfp-button-info-plain"
        + " tfp-button-warning-plain tfp-button-success-plain tfp-button-danger-plain");
      if (this.plain) {
        this._jqObj.addClass("tfp-button-" + buttonType + "-plain");
      } else {
        this._jqObj.addClass("tfp-button-" + buttonType);
      }
    }
  }

  get theme() { return this.dataModel.theme }
  set theme(value) {
    let theme = "rect";
    if (value) theme = value;
    if (!this.checkAttrOption("theme", theme)) {
      this._tfp.showMsg("按钮组件不支持风格：" + theme + "！");
      return;
    }
    this.dataModel.theme = theme;
    if (this._jqObj) {
      this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");
      this._jqObj.addClass("tfp-button-" + theme);
    }
  }

  get plain() { return this.dataModel.plain }
  set plain(value) {
    this.dataModel.plain = value ? true : false;
    if (this._jqObj) {
      this._jqObj.removeClass("tfp-button-default tfp-button-primary tfp-button-info"
        + " tfp-button-warning tfp-button-success tfp-button-danger");
      this._jqObj.removeClass("tfp-button-default-plain tfp-button-primary-plain tfp-button-info-plain"
        + " tfp-button-warning-plain tfp-button-success-plain tfp-button-danger-plain");
      var buttonType = this.buttonType;
      if (!buttonType) buttonType = "default";
      if (this.dataModel.plain) {
        this._jqObj.addClass("tfp-button-" + buttonType + "-plain");
      } else {
        this._jqObj.addClass("tfp-button-" + buttonType);
      }
    }
  }

  get showImage() { return this.dataModel.showImage }
  set showImage(value) {
    this.dataModel.showImage = value ? true : false;
    if (this._jqObj) {
      if (value) {
        if (this._jqObj.find("img").length > 0) {
          this._jqObj.find("img").show();
          return;
        }
        if (this._jqObj.find("span").length > 0) {
          this._jqObj.find("span").show();
          return;
        }
        if (this._tfp.isDesigning) {
          uiDesigner.showAttrSettingRow("imageUrl");
          uiDesigner.showAttrSettingRow("imageWidth");
          uiDesigner.showAttrSettingRow("imageHeight");
          uiDesigner.showAttrSettingRow("portrait");
          uiDesigner.showAttrSettingRow("hiddenText");
        }
        let imgUrl = this.dataModel.imageUrl;
        if (!imgUrl) {
          imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";
        } else if (this._tfp.isDesigning) {
          imgUrl = this._tfp.getUrlRealPath(imgUrl);
        }
        let imgWidth = 16;
        if (this.dataModel.imageWidth) imgWidth = this.dataModel.imageWidth;
        if ((imgWidth + "").indexOf("px") < 0) imgWidth += "px";
        let imgHeight = 16;
        if (this.dataModel.imageHeight) imgHeight = this.dataModel.imageHeight;
        if ((imgHeight + "").indexOf("px") < 0) imgHeight += "px";
        uiDesigner.setCurCptAttrSettingVal("imageWidth", "16");
        uiDesigner.setCurCptAttrSettingVal("imageHeight", "16");
        let imgHtml = "<img src=\"" + imgUrl + "\" style=\"width:" + imgWidth
          + ";height:" + imgHeight + ";\" />";
        this._jqObj.find("label").before(imgHtml);
        if(!this.dataModel.portrait) this._jqObj.find("label").css("margin-left", "7px");
        //this._jqObj.find("label").css("line-height", this._jqObj.height() + "px");
      } else {
        if (this._jqObj.find("img")) this._jqObj.find("img").remove();
        if (this._jqObj.find("span")) this._jqObj.find("span").remove();
        this.dataModel.portrait = false;
        this.dataModel.hiddenText = false;
        this.dataModel.imageUrl = "";
        this.dataModel.imageWidth = 16;
        this.dataModel.imageHeight = 16;
        this._jqObj.find("label").css("margin-left", "0px");
        this._jqObj.find("label").css("line-height", "30px");
        this._jqObj.find("label").show();
        if (this._tfp.isDesigning) {
          uiDesigner.hideAttrSettingRow("imageUrl");
          uiDesigner.hideAttrSettingRow("imageWidth");
          uiDesigner.hideAttrSettingRow("imageHeight");
          uiDesigner.setCurCptAttrSettingVal("imageWidth", "16");
          uiDesigner.setCurCptAttrSettingVal("imageHeight", "16");
          //window.parent.$("[attr-name=imageWidth]").find("input").val("24");
          //window.parent.$("[attr-name=imageHeight]").find("input").val("24");
          uiDesigner.setCurCptAttrSettingVal("portrait", false);
          uiDesigner.hideAttrSettingRow("portrait");
          uiDesigner.setCurCptAttrSettingVal("hiddenText", false);
          uiDesigner.hideAttrSettingRow("hiddenText");
        }
      }
    }
  }

  get imageUrl() { return this.dataModel.imageUrl }
  set imageUrl(value) {
    this.dataModel.imageUrl = value;
    if (this._jqObj) {
      let imgWidth = 20;
      if (this.dataModel.imageWidth) imgWidth = parseInt(this.dataModel.imageWidth);
      let imgHeight = 20;
      if (this.dataModel.imageHeight) imgHeight = parseInt(this.dataModel.imageHeight);
      let imgMargin = 3;
      if (this.dataModel.portrait && !this.dataModel.hiddenText) imgMargin = 10;
      let labelColor = '';
      if (this.dataModel.labelColor) labelColor = "color:" + this.dataModel.labelColor + ";";
      if (this._tfp.isDesigning && value) {
        if (this._jqObj.find("img")) this._jqObj.find("img").remove();
        if (this._jqObj.find("span")) this._jqObj.find("span").remove();
        if (value.indexOf("tfp-button-icon")>=0) {
          let fontSize = imgWidth ? imgWidth : imgHeight;
          this._jqObj.find("label").before('<span class="' + value + '" style=\"font-size:' + fontSize + 'px;margin-top:' + imgMargin + 'px; margin-bottom:3px;' + labelColor + '\"></span>');
        } else {
          this._jqObj.find("label").before('<img src="' + this._tfp.getUrlRealPath(value) + '" width=\"' + imgWidth + '\" height=\"'
            + imgHeight + '\" style=\"margin-top:' + imgMargin + 'px; margin-bottom:3px;\">');
        }
      } else {
        if (this._jqObj.find("img")) this._jqObj.find("img").remove();
        if (this._jqObj.find("span")) this._jqObj.find("span").remove();
        let imgUrl = this._tfp.rootPath + "/src/components/button/images/default-photo.png";
        this._jqObj.find("label").before('<img src="' + imgUrl + '" width=\"' + imgWidth + '\" height=\"'
          + imgHeight + '\" style=\"margin-top:' + imgMargin + 'px; margin-bottom:3px;\">');
      }
    }
  }

  get imageWidth() { return this.dataModel.imageWidth }
  set imageWidth(value) {
    this.dataModel.imageWidth = value;
    if (this._jqObj) {
      if (this.dataModel.imageUrl && this.dataModel.imageUrl.indexOf("tfp-button-icon")>=0) {
        this._jqObj.find("span").css("font-size", value + 'px');
      } else {
        this._jqObj.find("img").attr("width", value);
      }
    }
  }

  get imageHeight() { return this.dataModel.imageHeight }
  set imageHeight(value) {
    this.dataModel.imageHeight = value;
    if (this._jqObj) {
      if (this.dataModel.imageUrl && this.dataModel.imageUrl.indexOf("tfp-button-icon")>=0) {
        this._jqObj.find("span").css("font-size", value + 'px');
      } else {
        this._jqObj.find("img").attr("height", value);
      }
      //if (!this.portrait) this._jqObj.find("label").css("line-height",
      //  (this._jqObj.find("img").height() + 6) + "px");
    }
  }

  get hiddenText() { return this.dataModel.hiddenText }
  set hiddenText(value) {
    this.dataModel.hiddenText = value ? true : false;
    if (this._jqObj) {
      if (this._jqObj.find("label").length == 0) return;
      if (value) {
        this.portrait = false;
        uiDesigner.setCurCptAttrSettingVal("portrait", false);
        uiDesigner.hideAttrSettingRow("portrait");
        this._jqObj.find("img").css("margin-top", "3px");
        this._jqObj.find("label").hide();
      } else {
        this._jqObj.find("label").show();
        //this._jqObj.find("div").css("float", "left");
        //this._jqObj.find("img").css("margin-top", "3px");
        if(!this.dataModel.portrait) this._jqObj.find("label").css("margin-left", "7px");
        //this._jqObj.find("label").css("line-height", (this._jqObj.find("img").height() + 6) + "px");
        uiDesigner.showAttrSettingRow("portrait");
      }
    }
  }

  get portrait() { return this.dataModel.portrait }
  set portrait(value) {
    this.dataModel.portrait = value ? true : false;
    if (this._jqObj) {
      if (value) {
        this._jqObj.css({ "flex-direction": "column" });
        /*this._jqObj.find("div").css("float", "none");
        this._jqObj.find("div").css("width", "100%");
        this._jqObj.find("img").css("margin-top", "10px");
        this._jqObj.find("label").css("margin-left", "0px");
        this._jqObj.find("label").css("line-height", "30px");*/
      } else {
        this._jqObj.css("flex-direction", "row");
        /*this._jqObj.find("div").css("float", "left");
        this._jqObj.find("div").css("width", "");
        this._jqObj.find("img").css("margin-top", "3px");
        this._jqObj.find("label").css("margin-left", "7px");
        this._jqObj.find("label").css("line-height", (this._jqObj.find("img").height() + 6) + "px");*/
      }
    }
  }

  get title() { return this.dataModel.title }
  set title(value) {
    this.dataModel.title = value;
    if (this._jqObj) {
      this._jqObj.attr("title", value);
    }
  }

  get labelSize() {
    if (this.dataModel.labelSize) return this._tfp.getPixel(this.dataModel.labelSize);
    return 14;
  }
  set labelSize(value) {
    this.dataModel.labelSize = value;
    if (this._jqObj) {
      let size = value;
      if ((size + "").indexOf("px") < 0) size += "px";
      this._jqObj.find("label").css("font-size", size);
    }
  }

  get labelHeight() {
    if (this.dataModel.labelHeight) return this._tfp.getPixel(this.dataModel.labelHeight);
    return 30;
  }
  set labelHeight(value) {
    this.dataModel.labelHeight = value;
    if (this._jqObj) {
      let height = value;
      if ((height + "").indexOf("px") < 0) height += "px";
      this._jqObj.find("label").css("line-height", height);
    }
  }

  get labelColor() {
    return this.dataModel.labelColor;
  }
  set labelColor(value) {
    this.dataModel.labelColor = value;
    if (this._jqObj) {
      let color = value;
      this._jqObj.find("label").css("color", color);
      if (this.dataModel.imageUrl && this.dataModel.imageUrl.indexOf("tfp-button-icon")>=0) {
        this._jqObj.find("span").css("color", color);
      }
    }
  }

  get labelWeight() {
    return this.dataModel.labelWeight;
  }
  set labelWeight(value) {
    this.dataModel.labelWeight = value ? true : false;
    if (this._jqObj) {
      if (value) {
        this._jqObj.find("label").css("font-weight", "bold");
      } else {
        this._jqObj.find("label").css("font-weight", "");
      }
    }
  }
  
  //是否禁用
  get disabled() { return this.dataModel.disabled ? true : false }
  set disabled(value) {
    this.dataModel.disabled = value ? true : false;
    if (!this.dataModel.disabled) delete this.dataModel.disabled;
    if (this._jqObj) {
      if(value) {
        this._jqObj.css("background-color", "#CCCCCC");
      } else {
        this._jqObj.css("background-color", "");
      }
    }
  }

  css(styleName, styleValue) {
    if (arguments.length == 0) return;
    //获取样式值
    if (arguments.length == 1) {
      if (!this.dataModel.styles) return null;
      return this.dataModel.styles[styleName];
    }
    super.css(styleName, styleValue);
    if (styleName == "height" && styleValue) {
      if (this._jqObj && !this.showImage) {
        //this._jqObj.css("line-height", styleValue);
        this._jqObj.find("label").css("line-height", styleValue);
      }
    }
  }

  show() {
    if(this._jqObj) this._jqObj.css("display", "inline-flex");
  }

  initRuntime() {
    let that = this;
    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled || !that.dataModel.onClick) return;
      try {
        if (that.dataModel.onClick.indexOf("(")<0) {
          eval(that.dataModel.onClick+"()");
        } else {
          eval(that.dataModel.onClick);
        }
      } catch (err) {
        console.log(err.message);
      }
    });
  }
}