import { FormInput } from "../controller.js";

/**
 * 面包屑组件
 * @param {[type]} dataModel [description]
 */
export default class Breadcrumb extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Breadcrumb", dataModel, parent);

    if (!this.dataModel.options) {
      this.dataModel.options = [{
        text: "breadcrumb1",
        href: "/app/sys/console/home.tfp"
      }, {
        text: "breadcrumb2",
        href: ""
      }, {
        text: "breadcrumb3",
        href: ""
      }
      ];
    }
  }

  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value;
  }

  get dataListBindingMember() { return this.dataModel.dataListBindingMember }
  set dataListBindingMember(value) {
    this.dataModel.dataListBindingMember = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  get dataListHrefFormat() { return this.dataModel.dataListHrefFormat }
  set dataListHrefFormat(value) {
    this.dataModel.dataListHrefFormat = value;
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let textFormat = this.dataModel.dataListTextFormat;
        if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
        option.text = this._tfp.replaceDataField(row, textFormat);
        if (option.text) option.text = this._tfp.exeExpress(option.text);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.text)) continue;
      if (this.dataModel.dataListHrefFormat) {
        try {
          let hrefFormat = this.dataModel.dataListHrefFormat;
          if (hrefFormat.indexOf("{") < 0 && hrefFormat.indexOf("#[") < 0) hrefFormat = "{" + hrefFormat + "}";
          option.href = this._tfp.replaceDataField(row, hrefFormat);
          if (option.href) option.href = this._tfp.exeExpress(option.href);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (isNull(option.href)) continue;
      options.push(option);
    }
    this.options = options;
  }

  get options() { return this.dataModel.options }
  set options(options) {
    if (this._jqObj && options && Array.isArray(options)) {
      this.dataModel.options = options;
      if (this._jqObj) {
        this.reRender();
      }
    }
  }

  get separator() { return this.dataModel.separator }
  set separator(value) {
    this.dataModel.separator = ">";
    if (value && value.length == 1) this.dataModel.separator = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    let color = "#303133";
    if (this._tfp.curPage.bgColorMode == 'dark') color = "#fff";
    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option = this.dataModel.options[i];
      bodyHtml += indent + `<div><a`;
      if (option.href && !this._tfp.isDesigning) {
        if(this.dataModel.onClick) bodyHtml += ` href="javascript:void(0)" onclick="${this.dataModel.onClick}"`;
        else bodyHtml += ` href="javascript:void(0)" onclick="tfp.openPage('` + option.text + `', '` + option.href + `')"`;
      }
      if (option.href) bodyHtml += ` class="href_col" style="font-weight:700;color:` + color + `;cursor:pointer;"`
      bodyHtml += `>` + option.text + `</a><span>` + this.dataModel.separator + `</span></div>`;
    }
    return bodyHtml + indent;
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListTextFormat) {
      alert("请为[" + this.id + "]设置选项文本数据格式！");
      return false;
    }
    return true;
  }

  initRuntime() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService 
      || (this.dataModel.dataQuerySetting
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    }
  }
}