import TFPComponentRender from '../render.js'

export default class BarCodeRender extends TFPComponentRender {
  // 生成组件HTML

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml (retainStyleAttr) {
    if (this._tfp.isDesigning) return "";
    let attrHtml = super.getAttrHtml(retainStyleAttr);
    attrHtml += " width=\"" + this.dataModel.width + "\" height=\"" + this.dataModel.height + "\"";
    return attrHtml;
  }

  //设计时，为了实现拖拽调整位置，需要用div+背景图片的形式，直接用图片无法拖拽
  getCustomStyleHtml() {
    if(this._tfp.isDesigning) {
      return "background-image:url("+this._tfp.rootPath + "/src/components/barcode/images/default-photo.png);background-size:"
        +this.dataModel.width+"px "+this.dataModel.height+"px;display:inline-block;width:"
        +this.dataModel.width+"px;height:"+this.dataModel.height+"px;";
    }
    return "";
  }

  getHtml (getComponentsHtml, parentIndent, retainStyleAttr) {
    if(this._tfp.isDesigning) {
      return super.getHtml("div", false, parentIndent, retainStyleAttr);
    } else {
      return super.getHtml("img", false, parentIndent, retainStyleAttr);
    }
  }
}