import { VisibleComponent } from "../controller.js";
// 可视组件  
// 不可视组件

/**
 * 二维码组件
 * @param {[type]} dataModel [description]
 */
export default class BarCode extends VisibleComponent {

  // 全局组件tfp     数据模型   上级组件 最上层的是窗口 

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "BarCode", dataModel, parent);
  }

  get text () { return this.dataModel.text }
  set text (value) {
    this.dataModel.text = value;
    if(value) this.renderQr(value);
  }

  get width () { return this.dataModel.width }
  set width (value) {
    this.dataModel.width = value;
    if (this._jqObj) { 
      this._jqObj.css("width", value + "px");
      if(this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width+"px "+this.dataModel.height+"px");
    }
  }

  get height () { return this.dataModel.height }
  set height (value) {
    this.dataModel.height = value;
    if (this._jqObj) {
      this._jqObj.css("height", value + "px"); 
      if(this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width+"px "+this.dataModel.height+"px");
    }
  }
  get displayValue () { return this.dataModel.displayValue }
  set displayValue (value) {
    this.dataModel.displayValue = value;
  }


  get textAlign () { return this.dataModel.textAlign }
  set textAlign (value) {
    this.dataModel.textAlign = value;
  }
  get textPosition () { return this.dataModel.textPosition }
  set textPosition (value) {
    this.dataModel.textPosition = value;
  }
  get fontSize () { return this.dataModel.fontSize }
  set fontSize (value) {
    this.dataModel.fontSize = value;
  }
  get background () { return this.dataModel.background }
  set background (value) {
    this.dataModel.background = value;
  }
  get lineColor () { return this.dataModel.lineColor }
  set lineColor (value) {
    this.dataModel.lineColor = value;
  }
  get margin () { return this.dataModel.margin }
  set margin (value) {
    this.dataModel.margin = value;
  }

  renderQr(txt) {
    //运行时不生产图片，因为图片无法拖拽调整位置
    if(this._tfp.isDesigning) return;
    this._jqObj.empty();
    JsBarcode("#"+this.id, txt, {
      format: "CODE39",//选择要使用的条形码类型
      width: 3,//设置条之间的宽度
      height: this.dataModel.height,//高度
      displayValue: this.dataModel.displayValue,//是否在条形码下方显示文字
      text: txt,//覆盖显示的文本
      // fontOptions: "bold italic",//使文字加粗体或变斜体
      font: "fantasy",//设置文本的字体
      textAlign: this.dataModel.textAlign,//设置文本的水平对齐方式
      textPosition: this.dataModel.textPosition,//设置文本的垂直位置
      textMargin: 5,//设置条形码和文本之间的间距
      fontSize: this.dataModel.fontSize,//设置文本的大小
      background: this.dataModel.background,//设置条形码的背景
      lineColor: this.dataModel.lineColor,//设置条和文本的颜色。
      margin: this.dataModel.margin
    });
  }

  initDesigning() {
    if(this._jqObj) {
      if(this._jqObj.parent().get(0).tagName=="TD") {
        this._jqObj.css("vertical-align", "middle");
        if(!(this.dataModel.styles && this.dataModel.styles.display)) this._jqObj.css("display", "inline-block");
      }
    }
  }

  // 初始化 运行时   页面渲染完成执行
  initRuntime () {
    this.initDesigning();

    var that = this;
    let txt = this.dataModel.text;
    if (!txt) {
      txt = "taskbuilder"
    }
    if (that.dataModel.margin) { that.dataModel.margin = parseInt(that.dataModel.margin) }
    //如果不是动态绑定的后台数据，则初始化时即可渲染，否则需要等绑定数据后再渲染
    if(txt.indexOf("{")<0) this.renderQr(txt);

    this._jqObj.click(function () {
      if (that.dataModel.onClick) {
        eval(that.dataModel.onClick)
      }
    });
  }

  styleOnChange(styleName, styleValue) {
    if(this._tfp.isDesigning && (styleName=="width" || styleName=="height")) {
      if(styleName=="width") {
        this.width = this._tfp.getPx(styleValue);
      } else if(styleName=="height") {
        this.height = this._tfp.getPx(styleValue);
      }
    }
  }

}