import TFPComponentRender from '../render.js'

export default class AudioCodeRender extends TFPComponentRender {
  // 生成组件HTML

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let imgUrl = this._tfp.rootPath + "/src/components/audio/images/default-photo.png";
    html += indent + "<image  src=\"" + imgUrl + "\"";
    html += " width=\"100%\"";
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `   <audio src="` + this.dataModel.src + `"`
    if (this.dataModel.poster != '') {
      bodyHtml += ` poster="` + this.dataModel.poster + `"`;
    }
    if (this.dataModel.name) {
      bodyHtml += ` name="` + this.dataModel.name + `"`;
    }
    if (this.dataModel.author) {
      bodyHtml += ` author="` + this.dataModel.author + `"`;
    }
    if(this.dataModel.controls){
      bodyHtml += ` controls`;
    }
    bodyHtml += `></audio>\r`;
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
    // 最外层节点   是否传给上层   父组件前面空格缩进    是否保留属性
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}