import TFPComponentRender from '../render.js'

export default class AudioCodeRender extends TFPComponentRender {
  // 生成组件HTML

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml (retainStyleAttr) {
    let attrHtml = super.getAttrHtml(retainStyleAttr);

    attrHtml += " style=\"width:" + this.dataModel.width + "px;\"";


    if (this._tfp.isDesigning) {
      let imgUrl = this._tfp.rootPath + "/src/components/audio/images/default-photo.png";

      attrHtml += " src=\"" + imgUrl + "\"";
    } else {
      attrHtml += " src=\"" + this.dataModel.src + "\"";

      if (this.dataModel.controls == true) {
        attrHtml += " controls=\"" + this.dataModel.controls + "\"";
      }

      if (this.dataModel.loop == true) {
        attrHtml += " loop=\"" + this.dataModel.loop + "\"";
      }
      if (this.dataModel.muted == true) {
        attrHtml += " muted=\"" + this.dataModel.muted + "\"";
      }
      if (this.dataModel.autoplay == true) {
        attrHtml += " autoplay=\"" + this.dataModel.autoplay + "\"";
      }
    }
    return attrHtml;
  }

  getBodyHtml() {
    return "";
  }
  
  getHtml (getComponentsHtml, parentIndent, retainStyleAttr) {
    if (this._tfp.isDesigning) {
      return super.getHtml("img", false, parentIndent, retainStyleAttr);
    } else {
      return super.getHtml("audio", false, parentIndent, retainStyleAttr);
    }

    // 最外层节点   是否传给上层   父组件前面空格缩进    是否保留属性
  }
}