import { VisibleComponent } from "../controller.js";
// 可视组件  
// 不可视组件

/**
 * 音频组件
 * @param {[type]} dataModel [description]
 */
export default class Audio extends VisibleComponent {

  // 全局组件tfp     数据模型   上级组件 最上层的是窗口 

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Audio", dataModel, parent);
  }


  get src () { return this.dataModel.src }
  set src (value) {
    this.dataModel.src = value;
    if (this._jqObj) {  //
      this._jqObj.attr("src", value);
    } 
  }

  get controls () { return this.dataModel.controls }
  set controls (value) {
    this.dataModel.controls = value;
  }

  get loop () { return this.dataModel.loop }
  set loop (value) {
    this.dataModel.loop = value;
  }

  get poster () { return this.dataModel.poster }
  set poster (value) {
    this.dataModel.poster = value;
  }

  get name () { return this.dataModel.name }
  set name (value) {
    this.dataModel.name = value;
  }

  get author () { return this.dataModel.author }
  set author (value) {
    this.dataModel.author = value;
  }
}