import { VisibleComponent } from "../controller.js";
// 可视组件  
// 不可视组件

/**
 * 二维码组件
 * @param {[type]} dataModel [description]
 */
export default class Audio extends VisibleComponent {

  // 全局组件tfp     数据模型   上级组件 最上层的是窗口 

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Audio", dataModel, parent);
  }


  get src () { return this.dataModel.src }
  set src (value) {
    this.dataModel.src = value;
    if (this._jqObj) {  //
      this._jqObj.attr("src", value);
    }
  }
  get width () { return this.dataModel.width }
  set width (value) {
    this.dataModel.width = value;
    if (this._jqObj) {  //
      this._jqObj.css("width", value + "px");
    }
  }


  get controls () { return this.dataModel.controls }
  set controls (value) {
    this.dataModel.controls = value;
  }

  get loop () { return this.dataModel.loop }
  set loop (value) {
    this.dataModel.loop = value;
  }

  get muted () { return this.dataModel.muted }
  set muted (value) {
    this.dataModel.muted = value;
  }
  get autoplay () { return this.dataModel.autoplay }
  set autoplay (value) {
    this.dataModel.autoplay = value;
  }
  get poster () { return this.dataModel.poster }
  set poster (value) {
    this.dataModel.poster = value;
  }


  // 初始化 运行时   页面渲染完成执行
  initRuntime () {
    var that = this;
    this._jqObj.click(function () {
      if (that.dataModel.onClick) {
        eval(that.dataModel.onClick)
      }
    })
    this._jqObj.click(function () {
      if (that.dataModel.onMouseOver) {
        eval(that.dataModel.onMouseOver)
      }
    })
    this._jqObj.click(function () {
      if (that.dataModel.onMouseOut) {
        eval(that.dataModel.onMouseOut)
      }
    })
  }

  play () {
    // Play the video
    this._jqObj.trigger('play');
  }
  pause () {
    this._jqObj.trigger('pause');
  }
}