export default [
  {
    "id": "Container",
    "name": "容器组件",
    "components": [
      {
        "name": "Panel",
        "comment": "面板",
        "matchAllClient": true
      },
      {
        "name": "FlexPanel",
        "comment": "弹性面板",
        "matchAllClient": true
      },
      {
        "name": "Form",
        "comment": "表单",
        "matchAllClient": true
      },
      {
        "name": "FlexBox",
        "comment": "弹性栅格",
        "matchAllClient": true,
        "dependencies": ["Panel", "FlexPanel"]
      },
      {
        "name": "GridDataRow",
        "comment": "数据表格行",
        "dependent": true
      },
      {
        "name": "Grid",
        "comment": "数据表格",
        "dependencies": ["GridDataRow"]
      },
      {
        "name": "DataSet",
        "comment": "可编辑表格"
      },
      {
        "name": "DataCard",
        "comment": "数据卡片",
        "matchAllClient": true
      },
      {
        "name": "TabPage",
        "comment": "选项页",
        "matchAllClient": true,
        "dependent": true
      },
      {
        "name": "Tab",
        "comment": "选项卡",
        "matchAllClient": true,
        "dependencies": ["TabPage"]
      },
      {
        "name": "Swiper",
        "comment": "轮播图",
        "matchAllClient": true
      },
      {
        "name": "Iframe",
        "comment": "嵌入页面",
        "matchAllClient": true
      },
      {
        "name": "UserComponent",
        "comment": "自定义组件",
        "matchAllClient": true
      }
    ]
  },
  {
    "id": "ReadOnlyInput",
    "name": "只读组件",
    "components": [
      {
        "name": "Button",
        "comment": "按钮",
        "matchAllClient": true
      },
      {
        "name": "Link",
        "comment": "链接",
        "matchAllClient": true
      },
      {
        "name": "Label",
        "comment": "文本标签",
        "matchAllClient": true
      },
      {
        "name": "Pre",
        "comment": "文本段落",
        "matchAllClient": true
      },
      {
        "name": "Heading",
        "comment": "标题",
        "matchAllClient": true
      },
      {
        "name": "Line",
        "comment": "分割线",
        "matchAllClient": true
      },
      {
        "name": "Image",
        "comment": "图片",
        "matchAllClient": true
      },
      {
        "name": "Imagelist",
        "comment": "图片组"
      },
      {
        "name": "Progress",
        "comment": "进度条",
        "matchAllClient": true
      }
    ]
  },
  {
    "id": "Input",
    "name": "基础输入项",
    "components": [
      {
        "name": "Text",
        "comment": "单行输入框",
        "matchAllClient": true
      },
      {
        "name": "TextArea",
        "comment": "多行输入框",
        "matchAllClient": true
      },
      {
        "name": "Radio",
        "comment": "单选框",
        "matchAllClient": true
      },
      {
        "name": "CheckBox",
        "comment": "复选框",
        "matchAllClient": true
      },
      {
        "name": "Select",
        "comment": "弹出列表"
      },
      {
        "name": "List",
        "comment": "只读列表",
        "matchAllClient": true
      },
      {
        "name": "Switch",
        "comment": "开关",
        "matchAllClient": true
      },
      {
        "name": "Password",
        "comment": "密码",
        "matchAllClient": true
      },
      {
        "name": "Hidden",
        "comment": "隐藏域",
        "matchAllClient": true
      },
      {
        "name": "Date",
        "comment": "日期"
      },
      {
        "name": "Time",
        "comment": "时间"
      },
      {
        "name": "DateTime",
        "comment": "日期时间"
      },
      {
        "name": "FileUpload",
        "comment": "文件上传",
        "matchAllClient": true
      },
      {
        "name": "PhotoUpload",
        "comment": "图片上传"
      },
      {
        "name": "InputNumber",
        "comment": "计数器",
        "matchAllClient": true
      },
      {
        "name": "Slider",
        "comment": "滑块",
        "matchAllClient": true
      }
    ]
  },
  {
    "id": "InputEx",
    "name": "扩展输入项",
    "components": [
      {
        "name": "QrCode",
        "comment": "二维码",
        "matchAllClient": true
      },
      {
        "name": "BarCode",
        "comment": "条形码",
        "matchAllClient": true
      },
      {
        "name": "ScanCode",
        "comment": "扫一扫"
      },
      {
        "name": "Share",
        "comment": "分享"
      },
      {
        "name": "Rate",
        "comment": "评分",
        "matchAllClient": true
      },
      {
        "name": "Signatures",
        "comment": "手写签名"
      },
      {
        "name": "EncodingRule",
        "comment": "编码规则",
        "matchAllClient": true
      },
      {
        "name": "DataDic",
        "comment": "数据字典"
      },
      {
        "name": "CascaderRegion",
        "comment": "地区选择"
      },
      {
        "name": "Cascader",
        "comment": "级联选择"
      },
    ]
  },
  {
    "id": "Invisible",
    "name": "不可视组件",
    "components": [
      {
        "name": "Service",
        "comment": "服务请求",
        "matchAllClient": true,
        "isInvisible": true
      },
      {
        "name": "Timer",
        "comment": "定时器",
        "matchAllClient": true,
        "isInvisible": true
      }
    ]
  },
  {
    "id": "Media",
    "name": "媒体组件",
    "components": [
      {
        "name": "Audio",
        "comment": "音频",
        "matchAllClient": true
      }, {
        "name": "Video",
        "comment": "视频",
        "matchAllClient": true
      },

    ]
  },
  {
    "id": "Chart",
    "name": "统计图表",
    "components": [
      {
        "name": "ChartLine",
        "comment": "折线图",
        "matchAllClient": true
      },
      {
        "name": "ChartBar",
        "comment": "柱状图",
        "matchAllClient": true
      },
      {
        "name": "ChartBarY",
        "comment": "条形图",
        "matchAllClient": true
      },
      {
        "name": "ChartLineBar",
        "comment": "线柱结合图",
        "matchAllClient": true
      },
      {
        "name": "ChartPie",
        "comment": "饼状图",
        "matchAllClient": true
      },
      {
        "name": "ChartAnnular",
        "comment": "环形图",
        "matchAllClient": true
      }
    ]
  }
]