export default [
  {
    "id": "Base",
    "name": "基本",
    "components": [
      {
        "name": "Text",
        "comment": "单行输入",
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "formula",
            "comment": "自动计算表达式",
            "type": "formula"
          },
          {
            "name": "value",
            "comment": "文本内容",
            "type": "String"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "verify",
            "comment": "文本验证",
            "type": "verify"
          },
          {
            "name": "uniqueVerify",
            "comment": "唯一验证",
            "type": "Switch"
          }
        ]
      },
      {
        "name": "TextArea",
        "comment": "多行输入",
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "formula",
            "comment": "自动计算表达式",
            "type": "formula"
          },
          {
            "name": "value",
            "comment": "文本内容",
            "type": "String"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "verify",
            "comment": "文本验证",
            "type": "verify"
          }
        ]
      },
      {
        "name": "Select",
        "comment": "下拉框",
        "default": {
          "jsonDataSet": {
            "options": [
              {
                "value": 1,
                "text": "选项1"
              },
              {
                "value": 2,
                "text": "选项2"
              }]
          }
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "value",
            "comment": "组件值",
            "type": "String"
          },
          {
            "name": "jsonDataSet",
            "comment": "数据集",
            "type": "DatasetPro"
          }
        ]
      },
      {
        "name": "Switch",
        "comment": "开关",
        "default": {
          "styles": {
            "width": "40px"
          }
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "options",
            "comment": "选项",
            "type": "SwitchOptions",
            "default": [0, 1],
          },
          {
            "name": "value",
            "comment": "组件值",
            "type": "String"
          }
        ]
      },
      {
        "name": "Radio",
        "comment": "单选框",
        "default": {
          "options": [
            {
              "value": 1,
              "text": "选项1"
            },
            {
              "value": 2,
              "text": "选项2"
            }]
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "portrait",
            "comment": "竖向显示",
            "type": "Switch"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "options",
            "comment": "选项",
            "type": "Dataset"
          },
          {
            "name": "value",
            "comment": "组件值",
            "type": "String"
          }
        ]
      },
      {
        "name": "CheckBox",
        "comment": "多选框",
        "default": {
          "options": [
            {
              "value": 1,
              "text": "选项1"
            },
            {
              "value": 2,
              "text": "选项2"
            }]
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "portrait",
            "comment": "竖向显示",
            "type": "Switch"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "options",
            "comment": "选项",
            "type": "Dataset"
          },
          {
            "name": "value",
            "comment": "组件值",
            "type": "String"
          }
        ]
      },
      // {
      //   "name": "Rate",
      //   "comment": "等级",
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      // {
      //   "name": "Slider",
      //   "comment": "滑块",
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      {
        "name": "Date",
        "comment": "日期",
        "default": {
          "showIcon": true
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "showMode",
            "comment": "格式",
            "type": "Select",
            "default": "defaultMode",
            "options": [
              {
                "value": "defaultMode",
                "text": "日期"
              },
              {
                "value": "yearMonthMode",
                "text": "年月"
              },
              {
                "value": "yearMode",
                "text": "年"
              }
            ]
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "value",
            "comment": "组件值",
            "type": "String"
          },
          {
            "name": "defaultNow",
            "comment": "默认当前时间",
            "type": "Switch"
          }
        ]
      },
      {
        "name": "Time",
        "comment": "时间",
        "default": {
          "showIcon": true
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "value",
            "comment": "组件值",
            "type": "String"
          },
          {
            "name": "defaultNow",
            "comment": "默认当前时间",
            "type": "Switch"
          }
        ]
      },
      {
        "name": "Dep",
        "comment": "部门",
        "default": {
          "showIcon": true,
          "valueType": "str",
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "multiCheck",
            "comment": "多选",
            "type": "Switch"
          }
        ]
      },
      {
        "name": "User",
        "comment": "用户",
        "default": {
          "showIcon": true,
          "valueType": "str",
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "controlDirection",
            "comment": "方向",
            "type": "Select",
            "mode": "main",
            "options": [
              {
                "value": "row",
                "text": "横向",
              },
              {
                "value": "column",
                "text": "纵向"
              }
            ],
            "default": "column"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
          {
            "name": "readonly",
            "comment": "只读",
            "type": "Switch"
          },
          {
            "name": "disabled",
            "comment": "禁用",
            "type": "Switch",
          },
          {
            "name": "multiCheck",
            "comment": "多选",
            "type": "Switch"
          }
        ]
      },
      // {
      //   "name": "Org",
      //   "comment": "组织",
      //   "default": {
      //     "showIcon": true,
      //     "valueType": "str",
      //   },
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      // {
      //   "name": "Role",
      //   "comment": "角色",
      //   "default": {
      //     "showIcon": true,
      //     "valueType": "str",
      //   },
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      {
        "name": "FileUpload",
        "comment": "文件",
        "default": {
          "size": "10",
          "allowUpload": true,
          "allowDelete": true
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "size",
            "comment": "文件总数",
            "type": "number"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
        ]
      },
      {
        "name": "PhotoUpload",
        "comment": "图片",
        "default": {
          "appCode": "tad_image",
          "allowUpload": true,
          "allowDelete": true,
          "size": "3",
					"imageWidth": "90",
					"imageHeight": "90",
					"imageMargin": "10",
					"allowShowBigImage": true,
					"allowDelete": true,
					"maxSize": "960",
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "size",
            "comment": "文件总数",
            "type": "number"
          },
          {
            "name": "imageWidth",
            "comment": "图片显示宽度",
            "type": "number",
          },
          {
            "name": "imageHeight",
            "comment": "图片显示高度",
            "type": "number",
          },
          {
            "name": "imageMargin",
            "comment": "图片边距",
            "type": "number",
          },
          {
            "name": "allowShowBigImage",
            "comment": "允许点击查看大图",
            "type": "Switch",
          },
          {
            "name": "compress",
            "comment": "压缩图片",
            "type": "Switch",
          },
          {
            "name": "maxSize",
            "comment": "图片最大尺寸",
            "type": "number"
          },
          {
            "name": "required",
            "comment": "必填",
            "type": "Switch"
          },
        ]
      },
    ]
  },
  {
    "id": "Senior",
    "name": "高级",
    "components": [
      // {
      //   "name": "RichText",
      //   "comment": "富文本",
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      // {
      //   "name": "QrCode",
      //   "comment": "二维码",
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      {
        "name": "Sign",
        "comment": "签章",
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "signType",
            "comment": "签章类型",
            "type": "Select",
            "default": "name",
            "options": [
              {
                "value": "name",
                "text": "姓名"
              },
              {
                "value": "sign",
                "text": "签章"
              }
            ]
          },
          {
            "name": "isInputPassword",
            "comment": "输入密码",
            "type": "Switch"
          },
          {
            "name": "horizontal",
            "comment": "是否水平",
            "type": "Switch"
          },
        ]
      },
      // {
      //   "name": "Countersign",
      //   "comment": "会签",
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
    ]
  },
  {
    "id": "Join",
    "name": "关联",
    "components": [
      // {
      //   "name": "Record",
      //   "comment": "记录",
      //   "attrs": [
      //     {
      //       "name": "controlId",
      //       "comment": "控件编码",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlName",
      //       "comment": "控件名称",
      //       "type": "text"
      //     },
      //     {
      //       "name": "controlWidth",
      //       "comment": "宽度",
      //       "type": "taggroup"
      //     }
      //   ]
      // },
      {
        "name": "DataSet",
        "comment": "子表",
        "default": {
          "showAddButton": true,
          "addButtonText": "添加",
          "enableDelete": true,
          "columns": [
            {
              "id": "id",
              "name": "ID",
              "type": "Text",
              "hidden": true,
              "standard": true
            },
            {
              "id": "code",
              "name": "代码",
              "type": "Text",
              "dataBindingFormat": "{code}",
              "width": "60px"
            },
            {
              "id": "name",
              "name": "名称",
              "type": "Text",
              "dataBindingFormat": "{name}",
              "width": "60px"
            }
          ]
        },
        "attrs": [
          {
            "name": "controlId",
            "comment": "控件编码",
            "type": "text"
          },
          {
            "name": "controlName",
            "comment": "控件名称",
            "type": "text"
          },
          {
            "name": "controlWidth",
            "comment": "宽度",
            "type": "taggroup"
          },
          {
            "name": "columns",
            "comment": "数据列",
            "type": "Columns"
          },
          {
            "name": "showAddButton",
            "comment": "允许添加",
            "type": "Switch"
          },
          {
            "name": "enableInsert",
            "comment": "允许插入",
            "type": "Switch"
          },
          {
            "name": "enableMove",
            "comment": "允许更改位置",
            "type": "Switch"
          },
          {
            "name": "enableDelete",
            "comment": "允许删除",
            "type": "Switch"
          }
        ]
      }
    ]
  }
]