export default [
	{
		"name": "common",
		"comment": "基本语句",
		"color": "#3399FF",
		"statements": [
			{
				"name": "declare",
				"comment": "变量声明",
				"color": "#FF9900",
				"format": "var {varName} = {defaultVal}",
				"inputs": [
					{
						"name": "varName",
						"comment": "名称",
						"type": "string",
						"width": "150px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "varType",
						"comment": "类型",
						"type": "select",
						"options": [
							{
								"value": "null",
								"text": "空值"
							},
							{
								"value": "string",
								"text": "字符串"
							},
							{
								"value": "int",
								"text": "整数"
							},
							{
								"value": "float",
								"text": "浮点数"
							},
							{
								"value": "bool",
								"text": "布尔值"
							},
							{
								"value": "array",
								"text": "数组"
							},
							{
								"value": "map",
								"text": "键值对"
							},
							{
								"value": "date",
								"text": "日期"
							},
							{
								"value": "object",
								"text": "对象"
							},
							{
								"value": "function",
								"text": "函数"
							}
						]
					},
					{
						"name": "defaultVal",
						"comment": "默认值",
						"type": "string",
						"width": "118px",
						"nullVal": "null"
					}
				]
			},
			{
				"name": "assign",
				"comment": "变量赋值",
				"color": "#FF9900",
				"format": "{varName} {operator} {value}",
				"inputs": [
					{
						"name": "varName",
						"comment": "名称",
						"width": "150px",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "operator",
						"comment": "运算符",
						"type": "select",
						"required": true,
						"options": [
							{
								"value": "=",
								"text": "="
							},
							{
								"value": "+=",
								"text": "+="
							},
							{
								"value": "-=",
								"text": "-="
							}
						],
						"default": "="
					},
					{
						"name": "value",
						"comment": "值",
						"type": "string",
						"required": true,
						"width": "150px"
					}
				]
			},
			{
				"name": "if",
				"comment": "判断",
				"haveStatements": true,
				"inputs": [
					{
						"name": "condition",
						"comment": "",
						"type": "string",
						"width": "flex",
						"minWidth": "400px",
						"required": true
					}
				]
			},
			{
				"name": "for",
				"comment": "循环",
				"haveStatements": true,
				"inputs": [
					{
						"name": "cycleNumber",
						"comment": "循环次数",
						"type": "string",
						"width": "100px",
						"default": "10",
						"required": true
					},
					{
						"name": "indexVar",
						"comment": "索引变量名",
						"type": "string",
						"width": "80px",
						"default": "i",
						"required": true
					},
					{
						"name": "indexStart",
						"comment": "起始索引",
						"type": "string",
						"width": "60px",
						"default": "0",
						"required": true
					}
				]
			},
			{
				"name": "iteratearray",
				"comment": "遍历数组元素",
				"haveStatements": true,
				"inputs": [
					{
						"name": "arrVar",
						"comment": "数组变量名",
						"type": "varList",
						"width": "100px",
						"required": true
					},
					{
						"name": "indexVar",
						"comment": "索引变量名",
						"type": "string",
						"width": "40px",
						"default": "i",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "startIndex",
						"comment": "起始索引",
						"type": "string",
						"width": "60px",
						"required": true,
						"default": "0"
					}
				]
			},
			{
				"name": "iterateobject",
				"comment": "遍历对象属性",
				"haveStatements": true,
				"inputs": [
					{
						"name": "objVar",
						"comment": "对象变量名",
						"type": "varList",
						"width": "150px",
						"required": true
					},
					{
						"name": "propVar",
						"comment": "属性变量名",
						"type": "string",
						"width": "80px",
						"default": "prop",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "continue",
				"comment": "继续循环",
				"format": "continue"
			},
			{
				"name": "break",
				"comment": "跳出循环",
				"color": "#CC0000",
				"format": "break"
			},
			{
				"name": "return",
				"comment": "返回",
				"format": "return {retVal}",
				"color": "#CC0000",
				"inputs": [
					{
						"name": "retVal",
						"comment": "返回值",
						"type": "string",
						"width": "200px"
					}
				]
			},
			{
				"name": "comment",
				"comment": "添加注释",
				"color": "#999999",
				"format": "//{message}",
				"inputs": [
					{
						"name": "message",
						"comment": "注释内容",
						"type": "string",
						"width": "300px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "log",
				"comment": "输出控制台信息",
				"color": "#999999",
				"format": "console.log({message})",
				"inputs": [
					{
						"name": "message",
						"comment": "信息内容",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			},
			{
				"name": "callFunc",
				"comment": "函数调用",
				"color": "#9933CC",
				"inputs": [
					{
						"name": "funcName",
						"comment": "函数名称",
						"type": "funcList",
						"width": "200px",
						"required": true
					}
				]
			},
			{
				"name": "custom",
				"comment": "自定义语句",
				"color": "#9933CC",
				"format": "{content}",
				"inputs": [
					{
						"name": "content",
						"comment": "语句内容",
						"type": "string",
						"required": true,
						"width": "400px"
					}
				]
			}
		]
	},
	{
		"name": "framework",
		"comment": "tfp框架基本功能",
		"color": "#0033FF",
		"statements": [
			{
				"name": "tfp.showMsg",
				"comment": "显示弹窗提示",
				"format": "tfp.showMsg({message})",
				"color": "#0033FF",
				"inputs": [
					{
						"name": "message",
						"comment": "提示信息",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			},
			{
				"name": "tfp.showConfirm",
				"comment": "显示弹窗确认",
				"format": "tfp.showConfirm({message}, function({cbArg}) {[[statements]]})",
				"color": "#0033FF",
				"haveStatements": true,
				"haveCbFunc": true,
				"inputs": [
					{
						"name": "message",
						"comment": "提示信息",
						"type": "string",
						"required": true,
						"width": "300px"
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"width": "50px",
						"default": "ret",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.showToast",
				"comment": "显示自动隐藏提示",
				"client": "pc",
				"format": "tfp.showToast({message})",
				"color": "#0033FF",
				"inputs": [
					{
						"name": "message",
						"comment": "提示信息",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			},
			{
				"name": "tfp.getUrlArg",
				"comment": "获得URL参数值",
				"format": "tfp.getUrlArg('{argName}')",
				"color": "#0033FF",
				"icon": "",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "argName",
						"comment": "参数名称",
						"type": "string",
						"required": true,
						"width": "200px",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.addUrlArg",
				"comment": "在URL里追加参数",
				"format": "tfp.addUrlArg({url}, '{argName}', {argVal})",
				"color": "#0033FF",
				"icon": "",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "url",
						"comment": "URL路径",
						"type": "string",
						"required": true,
						"width": "200px"
					},
					{
						"name": "argName",
						"comment": "参数名称",
						"type": "string",
						"required": true,
						"width": "100px",
						"isOnlyStr": true
					},
					{
						"name": "argVal",
						"comment": "参数值",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "tfp.setUrlAuthData",
				"comment": "为URL添加身份验证信息",
				"format": "tfp.setUrlAuthData({url})",
				"color": "#0033FF",
				"icon": "",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "url",
						"comment": "URL路径",
						"type": "string",
						"required": true,
						"width": "200px"
					}
				]
			},
			{
				"name": "tfp.openImage",
				"comment": "打开图片查看器",
				"client": "pc",
				"format": "tfp.openImage({url})",
				"icon": "",
				"inputs": [
					{
						"name": "url",
						"comment": "图片路径",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			},
			{
				"name": "tfp.openReport",
				"comment": "打开报表页面",
				"client": "pc",
				"format": "tfp.openReport({url})",
				"icon": "",
				"inputs": [
					{
						"name": "url",
						"comment": "报表文件路径",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			},
			{
				"name": "tfp.openPdfViewer",
				"comment": "打开PDF文件",
				"format": "tfp.openPdfViewer({url})",
				"client": "pc",
				"icon": "",
				"inputs": [
					{
						"name": "url",
						"comment": "PDF文件路径",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			}
		]
	},/*
	{
		"name": "jquery",
		"comment": "jQuery操作",
		"color": "#0033FF",
		"statements": [
			{
				"name": "jqSelector",
				"comment": "选择符合条件的元素",
				"format": "$({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true,
						"width": "200px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqLength",
				"comment": "获得符合条件的元素数量",
				"format": "{jqObj}.length",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "jqEach",
				"comment": "遍历所有选择的元素",
				"format": "{jqObj}.each(function(){[[statements]]})",
				"haveStatements": true,
				"inputs": [
					{
						"name": "jqObj",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "jqFind",
				"comment": "查找符合条件的后代元素",
				"format": "{jqObj}.find({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqChildren",
				"comment": "查找符合条件的子元素",
				"format": "{jqObj}.children({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqParent",
				"comment": "获得父元素",
				"format": "{jqObj}.parent({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqClosest",
				"comment": "获得最先找到的祖先元素",
				"format": "{jqObj}.closest({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqParents",
				"comment": "获得所有符合条件的祖先元素",
				"format": "{jqObj}.parents({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"fontsize": "12px",
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqPrev",
				"comment": "获得前一个同辈元素",
				"format": "{jqObj}.prev({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqNext",
				"comment": "获得后一个同辈元素",
				"format": "{jqObj}.next({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqPrevAll",
				"comment": "获得前面的所有同辈元素",
				"format": "{jqObj}.prevAll({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqNextAll",
				"comment": "获得后面的所有同辈元素",
				"format": "{jqObj}.nextAll({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqSiblings",
				"comment": "获得所有同辈元素",
				"format": "{jqObj}.siblings({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqFirst",
				"comment": "获得匹配的第1个元素",
				"format": "{jqObj}.first()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "jqLast",
				"comment": "获得匹配的最后1个元素",
				"format": "{jqObj}.last()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "jqEq",
				"comment": "获得指定索引的元素",
				"format": "{jqObj}.eq({index})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "index",
						"comment": "索引",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "jqAdd",
				"comment": "添加元素到已有集合中",
				"format": "{jqObj}.add({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqNot",
				"comment": "从已有集合中删除元素",
				"format": "{jqObj}.not({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqSlice",
				"comment": "裁剪已选择的元素集合",
				"format": "{jqObj}.slice({start}, {end})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "start",
						"comment": "开始索引",
						"type": "string",
						"required": true, 
						"width": "100px"
					},
					{
						"name": "end",
						"comment": "结束索引",
						"type": "string",
						"required": true, 
						"width": "100px"
					}
				]
			},
			{
				"name": "jqFilter",
				"comment": "筛选已选择的元素",
				"format": "{jqObj}.filter({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqHas",
				"comment": "根据子元素筛选",
				"format": "{jqObj}.has({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "jqIs",
				"comment": "检测元素是否匹配指定条件",
				"format": "{jqObj}.is({sltStr})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "jqObj",
						"comment": "jQuery对象",
						"type": "varList",
						"required": true, 
						"isOnlyStr": true,
						"width": "100px"
					},
					{
						"name": "sltStr",
						"comment": "元素选择表达式",
						"type": "string",
						"required": true, 
						"width": "150px"
					},
					{
					  "name": "setting",
					  "comment": "设置",
					  "type": "dialog",
					  "url": "taskbuilder-tfp-designer/jqSelectorSetting.html",
					  "width": "720px",
					  "height": "540px",
					  "saveRetToAttr": "attrs"
					}
				]
			}
		]
	},*/
	{
		"name": "page",
		"comment": "页面操作",
		"color": "#3399FF",
		"statements": [
			{
				"name": "location.reload",
				"comment": "刷新当前页面",
				"format": "location.reload()"
			},
			{
				"name": "history.back",
				"comment": "返回上一页",
				"format": "history.back()"
			},
			{
				"name": "tfp.gotoPage",
				"comment": "跳转到指定页面",
				"format": "tfp.gotoPage({url})",
				"inputs": [
					{
						"name": "url",
						"comment": "页面地址",
						"type": "string",
						"required": true,
						"width": "300px"
					}
				]
			},
			{
				"name": "tfp.openPage",
				"comment": "打开新页面",
				"client": "pc",
				"format": "tfp.openPage({title}, {url})",
				"inputs": [
					{
						"name": "title",
						"comment": "标题",
						"type": "string",
						"required": true,
						"width": "100px"
					},
					{
						"name": "url",
						"comment": "页面地址",
						"type": "string",
						"required": true,
						"width": "200px"
					}
				]
			},
			{
				"name": "tfp.openWindow",
				"comment": "打开新浏览器窗口",
				"client": "pc",
				"format": "window.open({url}, {title}, {features})",
				"inputs": [
					{
						"name": "url",
						"comment": "页面地址",
						"type": "string",
						"required": true,
						"width": "200px"
					},
					{
						"name": "title",
						"comment": "标题",
						"type": "string",
						"width": "100px"
					},
					{
						"name": "features",
						"comment": "选项",
						"type": "string",
						"width": "100px"
					}
				]
			},
			{
				"name": "tfp.getCurPage",
				"comment": "获得当前页面",
				"client": "pc",
				"format": "tfp.getCurPage()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "curPage",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.closeCurPage",
				"comment": "关闭当前页面",
				"client": "pc",
				"format": "tfp.closeCurPage()"
			},
			{
				"name": "tfp.getPageList",
				"comment": "获得所有页面列表",
				"client": "pc",
				"format": "tfp.getPageList()",
				"return": {
					"must": true,
					"type": "Array"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "pages",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.showPage",
				"comment": "显示指定ID页面",
				"client": "pc",
				"format": "tfp.showPage({id})",
				"icon": "",
				"inputs": [
					{
						"name": "id",
						"comment": "页面ID",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "tfp.hidePage",
				"comment": "隐藏指定ID页面",
				"client": "pc",
				"format": "tfp.hidePage({id})",
				"icon": "",
				"inputs": [
					{
						"name": "id",
						"comment": "页面ID",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "tfp.closePage",
				"comment": "关闭指定ID页面",
				"client": "pc",
				"format": "tfp.closePage({id})",
				"icon": "",
				"inputs": [
					{
						"name": "id",
						"comment": "页面ID",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "getLocation",
				"comment": "获得页面路径信息",
				"format": "location",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "loc",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getUserAgent",
				"comment": "获得浏览器信息",
				"format": "navigator.userAgent",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "userAgent",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getScreen",
				"comment": "获得屏幕信息",
				"format": "window.screen",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "scr",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getBodyWidth",
				"comment": "获得页面可见区域宽度",
				"format": "document.documentElement.clientWidth || document.body.clientWidth",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "clientWidth",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getBodyHeight",
				"comment": "获得页面可见区域高度",
				"format": "document.documentElement.clientHeight || document.body.clientHeight",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "clientHeight",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getScrollWidth",
				"comment": "获得页面正文全文宽度",
				"format": "Math.max(document.documentElement.scrollWidth, document.body.scrollWidth)",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "scrollWidth",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getScrollHeight",
				"comment": "获得页面正文全文高度",
				"format": "Math.max(document.documentElement.scrollHeight, document.body.scrollHeight)",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "scrollHeight",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getIframeWindow",
				"comment": "获得框架页的窗口对象",
				"format": "window.frames['{frameId}'].contentWindow",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "frameId",
						"comment": "框架页id",
						"type": "string",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "frameWin",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getParentWindow",
				"comment": "获得当前页的父窗口对象",
				"format": "window.parent",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "parentWin",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getTopWindow",
				"comment": "获得最顶层页的窗口对象",
				"format": "window.top",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "topWin",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getOpenerWindow",
				"comment": "获得打开当前页面的窗口对象",
				"format": "window.opener",
				"return": {
					"must": true,
					"type": "bool"
				},
				"fontsize": "12px",
				"inputs": [
					{
						"name": "retVarName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"default": "opener",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "scrollTo",
				"comment": "内容滚动到指定的坐标",
				"client": "pc",
				"format": "window.scrollTo({x}, {y})",
				"icon": "",
				"inputs": [
					{
						"name": "x",
						"comment": "x坐标",
						"type": "string",
						"required": true,
						"width": "100px"
					},
					{
						"name": "y",
						"comment": "y坐标",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "moveTo",
				"comment": "窗口移动到指定的坐标",
				"client": "pc",
				"format": "window.moveTo({x}, {y})",
				"icon": "",
				"inputs": [
					{
						"name": "x",
						"comment": "x坐标",
						"type": "string",
						"required": true,
						"width": "100px"
					},
					{
						"name": "y",
						"comment": "y坐标",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "printWindow",
				"comment": "打印当前窗口",
				"client": "pc",
				"format": "window.print()"
			}
		]
	},
	{
		"name": "extend",
		"comment": "手机",
		"color": "#663366",
		"client": "phone",
		"mobileType": "TaskMsg",
		"statements": [
			{
				"name": "openWebPage",
				"comment": "打开网页",
				"format": "tfp.openPageMobile({url: {url}, title: {title}, hideNavBar: {hideNavBar}, callback: function({cbArg}){[[statements]]}})",
				"haveStatements": true,
				"inputs": [
					{
						"name": "url",
						"comment": "地址",
						"type": "string",
						"width": "200px",
						"required": true,
					},
					{
						"name": "title",
						"comment": "标题",
						"type": "string",
						"required": true,
					},
					{
						"name": "hideNavBar",
						"comment": "隐藏标题栏",
						"type": "select",
						"options": [
							{
								"value": "true",
								"text": "是"
							},
							{
								"value": "false",
								"text": "否"
							}
						],
						"default": "false"
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"isOnlyStr": true,
						"default": ""
					}
				]
			},
			{
				"name": "close",
				"comment": "关闭当前窗口",
				"format": "tmClient.closePageMobile()"
			},
			{
				"name": "invokeOpenerCallbackFunc",
				"comment": "返回数据并关闭当前窗口",
				"format": "tfp.invokeOpenerFuncMobile({arg})",
				"inputs": [
					{
						"name": "arg",
						"comment": "返回参数名",
						"type": "string",
						"isOnlyStr": true,
						"required": true,
					}
				]
			},
			{
				"name": "setToolBtn",
				"comment": "设置右上角按钮",
				"format": "tfp.setToolBtnMobile('{text}', '{jsStatement}')",
				"inputs": [
					{
						"name": "text",
						"comment": "按钮文本",
						"type": "string",
						"isOnlyStr": true,
						"required": true,
					},
					{
						"name": "jsStatement",
						"comment": "执行方法",
						"width": "160px",
						"type": "string",
						"required": true,
					}
				]
			},
			{
				"name": "setMoreMenu",
				"comment": "设置更多菜单",
				"format": "tfp.setMoreMenuMobile({menu})",
				"inputs": [
					{
						"name": "menu",
						"comment": "执行方法",
						"width": "400px",
						"type": "string",
						"required": true,
					}
				]
			},
			{
				"name": "setTitle",
				"comment": "设置窗口标题",
				"format": "tfp.setTitleMobile('{title}')",
				"inputs": [
					{
						"name": "title",
						"comment": "标题",
						"type": "string",
						"required": true,
					}
				]
			},
		]
	},
	{
		"name": "dialog",
		"comment": "对话框操作",
		"client": "pc",
		"color": "#3399FF",
		"statements": [
			{
				"name": "tfp.openDialog",
				"comment": "打开对话框",
				"format": "tfp.openDialog([[options]])",
				"haveStatements": true,
				"inputs": [
					{
						"name": "title",
						"comment": "标题",
						"type": "string",
						"width": "80px",
						"required": true,
						"mergeTo": "options",
						"default": "'标题'"
					},
					{
						"name": "url",
						"comment": "路径",
						"type": "string",
						"required": true,
						"width": "200px",
						"mergeTo": "options",
						"default": "'/app/xxx.tfp'"
					},
					{
						"name": "width",
						"comment": "宽度",
						"type": "string",
						"required": true,
						"hidden": true,
						"mergeTo": "options",
						"default": "'480px'"
					},
					{
						"name": "height",
						"comment": "高度",
						"type": "string",
						"required": true,
						"hidden": true,
						"mergeTo": "options",
						"default": "'320px'"
					},
					{
						"name": "left",
						"comment": "左边距",
						"type": "string",
						"hidden": true,
						"mergeTo": "options"
					},
					{
						"name": "top",
						"comment": "上边距",
						"type": "string",
						"hidden": true,
						"mergeTo": "options"
					},
					{
						"name": "hideCloseButton",
						"comment": "隐藏关闭按钮",
						"type": "bool",
						"mergeTo": "options",
						"hidden": true
					},
					{
						"name": "disableMove",
						"comment": "禁止移动",
						"type": "bool",
						"mergeTo": "options",
						"hidden": true
					},
					{
						"name": "fullScreen",
						"comment": "全屏显示",
						"type": "bool",
						"mergeTo": "options",
						"hidden": true
					},
					{
						"name": "args",
						"comment": "传入参数",
						"type": "varList",
						"mergeTo": "options",
						"hidden": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"default": "ret",
						"hidden": true,
						"isOnlyStr": true
					},
					{
						"name": "cb",
						"comment": "回调函数",
						"type": "cbFunc",
						"mergeTo": "options",
						"format": "function({cbArg}) {[[statements]]}",
						"hidden": true
					},
					{
						"name": "setting",
						"type": "dialog"
					}
				]
			},
			{
				"name": "tfp.getDialogArgs",
				"comment": "获得传给对话框的参数",
				"format": "tfp.getDialogArgs()",
				"return": {
					"must": true,
					"type": "Object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "args",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.closeCurDialog",
				"comment": "关闭当前对话框",
				"format": "tfp.closeCurDialog({ret})",
				"icon": "",
				"inputs": [
					{
						"name": "ret",
						"comment": "返回值",
						"type": "string",
						"width": "100px"
					}
				]
			},
			{
				"name": "tfp.getCurDialog",
				"comment": "获得当前对话框",
				"format": "tfp.getCurDialog()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "dialog",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getCurDialogOpener",
				"comment": "获得打开当前对话框的窗口",
				"format": "tfp.getCurDialog().opener",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "opener",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getCurDialogId",
				"comment": "获得当前对话框的ID",
				"format": "tfp.getCurDialogId()",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "dialogId",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.closeDialog",
				"comment": "关闭指定ID的对话框",
				"format": "tfp.closeDialog({id})",
				"icon": "",
				"inputs": [
					{
						"name": "id",
						"comment": "对话框ID",
						"type": "string",
						"required": true,
						"width": "100px"
					}
				]
			},
			{
				"name": "tfp.closeAllDialogs",
				"comment": "关闭所有对话框",
				"format": "tfp.closeAllDialogs()"
			},
			{
				"name": "tfp.getDialog",
				"comment": "获得指定ID的对话框",
				"format": "tfp.getDialog({id})",
				"return": {
					"must": true,
					"type": "Object"
				},
				"inputs": [
					{
						"name": "id",
						"comment": "对话框ID",
						"type": "string",
						"required": true,
						"width": "100px"
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "dialog",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getTopDialog",
				"comment": "获得最顶层的对话框",
				"format": "tfp.getTopDialog()",
				"return": {
					"must": true,
					"type": "Object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "dialogTop",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getDialogs",
				"comment": "获得对话框集合",
				"format": "tfp.getDialogs()",
				"return": {
					"must": true,
					"type": "Object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "dialogs",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getDialogList",
				"comment": "获得对话框列表",
				"format": "tfp.getDialogList()",
				"return": {
					"must": true,
					"type": "Array"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "dialogList",
						"required": true,
						"isOnlyStr": true
					}
				]
			}
		]
	},
	{
		"name": "drawer",
		"comment": "抽屉页操作",
		"color": "#3399FF",
		"client": "pc",
		"statements": [
			{
				"name": "tfp.openDrawer",
				"comment": "打开抽屉页",
				"format": "tfp.openDrawer([[options]])",
				"haveStatements": true,
				"inputs": [
					{
						"name": "title",
						"comment": "标题",
						"type": "string",
						"width": "80px",
						"required": true,
						"mergeTo": "options",
						"default": "'标题'"
					},
					{
						"name": "url",
						"comment": "路径",
						"type": "string",
						"required": true,
						"width": "200px",
						"mergeTo": "options",
						"default": "'/app/xxx.tfp'"
					},
					{
						"name": "width",
						"comment": "宽度",
						"type": "string",
						"required": true,
						"hidden": true,
						"mergeTo": "options",
						"default": "'960px'"
					},
					{
						"name": "okButtonText",
						"comment": "确定按钮文字",
						"type": "string",
						"width": "80px",
						"hidden": true,
						"mergeTo": "options",
						"default": "'确定'"
					},
					{
						"name": "hideOKButton",
						"comment": "隐藏确定按钮",
						"type": "bool",
						"mergeTo": "options",
						"hidden": false
					},
					{
						"name": "closeOnClickMask",
						"comment": "点击其他区域时关闭",
						"type": "bool",
						"mergeTo": "options",
						"hidden": true
					},
					{
						"name": "args",
						"comment": "传入参数",
						"type": "varList",
						"mergeTo": "options",
						"hidden": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"default": "drawer",
						"hidden": true,
						"isOnlyStr": true
					},
					{
						"name": "cb",
						"comment": "回调函数",
						"type": "cbFunc",
						"mergeTo": "options",
						"format": "function({cbArg}) {[[statements]]}",
						"hidden": true
					},
					{
						"name": "setting",
						"type": "dialog"
					}
				]
			},
			{
				"name": "tfp.getCurDrawer",
				"comment": "获得当前抽屉页",
				"format": "tfp.getCurDrawer()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "curDrawer",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getCurDrawerOpener",
				"comment": "获得打开当前抽屉页的窗口",
				"format": "tfp.getCurDrawer().opener",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "opener",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.getCurDrawerArgs",
				"comment": "获得传给当前抽屉页的参数",
				"format": "tfp.getCurDrawer().args",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "args",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.closeDrawer",
				"comment": "关闭当前抽屉页",
				"format": "tfp.closeDrawer()"
			}
		]
	},
	{
		"name": "component",
		"comment": "组件操作",
		"color": "#9933CC",
		"statements": [
			{
				"name": "getCptJqObj",
				"comment": "获得组件的jQuery对象",
				"icon": "",
				"format": "{cptId}._jqObj",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cptJqObj",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptEl",
				"comment": "获得组件的DOM元素",
				"icon": "",
				"format": "{cptId}.el",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cptEl",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "callCptFunc",
				"comment": "调用组件方法",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "funcName",
						"comment": "方法名称",
						"type": "cptFuncList",
						"required": true
					},
					{
						"name": "setting",
						"comment": "参数设置",
						"type": "dialog",
						"url": "taskbuilder-tfp-designer/CptFuncSetting.html",
						"width": "640px",
						"height": "540px"
					}
				]
			},
			{
				"name": "setCptValue",
				"comment": "设置组件值",
				"icon": "",
				"format": "{cptId}.value = {val}",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "val",
						"comment": "组件值",
						"type": "string",
						"width": "120px",
						"required": true
					}
				]
			},
			{
				"name": "getCptValue",
				"comment": "获得组件值",
				"icon": "",
				"format": "{cptId}.value",
				"return": {
					"must": true,
					"type": "var"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "val",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptAttr",
				"comment": "获得组件属性",
				"icon": "",
				"format": "{cptId}.attr('{attrName}')",
				"return": {
					"must": true,
					"type": "var"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "attrName",
						"comment": "属性名称",
						"type": "select",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "attr",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "setCptAttr",
				"comment": "设置组件属性",
				"icon": "",
				"format": "{cptId}.attr('{attrName}', {attrVal})",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "attrName",
						"comment": "属性名称",
						"type": "select",
						"required": true
					},
					{
						"name": "attrVal",
						"comment": "属性值",
						"type": "string",
						"width": "120px",
						"required": true
					}
				]
			},
			{
				"name": "batchSetCptAttr",
				"comment": "批量设置组件属性",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "setting",
						"type": "dialog",
						"url": "taskbuilder-tfp-designer/CptAttrSetting.html",
						"width": "720px",
						"height": "540px",
						"saveRetToAttr": "attrs"
					}
				]
			},
			{
				"name": "getCptCss",
				"comment": "获得组件样式",
				"icon": "",
				"format": "{cptId}.css('{styleName}')",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "styleName",
						"comment": "样式名称",
						"type": "select",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "style",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "setCptCss",
				"comment": "设置组件样式",
				"icon": "",
				"format": "{cptId}.css('{styleName}', {styleVal})",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "styleName",
						"comment": "样式名称",
						"type": "select",
						"required": true
					},
					{
						"name": "styleVal",
						"comment": "样式值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "batchSetCptCss",
				"comment": "批量设置组件样式",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "setting",
						"type": "dialog",
						"url": "taskbuilder-tfp-designer/CptStyleSetting.html",
						"width": "720px",
						"height": "540px",
						"saveRetToAttr": "styles"
					}
				]
			},
			{
				"name": "addCptCssClass",
				"comment": "为组件添加样式类",
				"icon": "",
				"format": "{cptId}._jqObj.addClass('{className}')",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "className",
						"comment": "样式类名称",
						"type": "string",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "removeCptCssClass",
				"comment": "移除组件的样式类",
				"icon": "",
				"format": "{cptId}._jqObj.removeClass('{className}')",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "className",
						"comment": "样式类名称",
						"type": "string",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "hasCptCssClass",
				"comment": "组件是否包含样式类",
				"icon": "",
				"format": "{cptId}._jqObj.hasClass('{className}')",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "className",
						"comment": "样式类名称",
						"type": "string",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "showCpt",
				"comment": "显示组件",
				"format": "{cptId}.show()",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					}
				]
			},
			{
				"name": "hideCpt",
				"comment": "隐藏组件",
				"format": "{cptId}.hide()",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					}
				]
			},
			{
				"name": "focusCpt",
				"comment": "让组件获得焦点",
				"format": "{cptId}.focus()",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					}
				]
			},
			{
				"name": "getCptWidth",
				"comment": "获得组件宽度",
				"icon": "",
				"format": "{cptId}._jqObj.width()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "width",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptHeight",
				"comment": "获得组件高度",
				"icon": "",
				"format": "{cptId}._jqObj.height()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "height",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptInnerWidth",
				"comment": "获得组件内部宽度",
				"icon": "",
				"format": "{cptId}._jqObj.innerWidth()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "innerWidth",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptInnerHeight",
				"comment": "获得组件内部高度",
				"icon": "",
				"format": "{cptId}._jqObj.innerHeight()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "innerHeight",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptOuterWidth",
				"comment": "获得组件外部宽度",
				"icon": "",
				"format": "{cptId}._jqObj.outerWidth()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "outerWidth",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getOuterHeight",
				"comment": "获得组件外部高度",
				"icon": "",
				"format": "{cptId}._jqObj.outerHeight()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "outerHeight",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptOffset",
				"comment": "获得组件相对页面的坐标",
				"icon": "",
				"format": "{cptId}._jqObj.offset()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "offset",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptPosition",
				"comment": "获得组件相对父组件位置",
				"icon": "",
				"format": "{cptId}._jqObj.position()",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "position",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.get",
				"comment": "获得指定id的组件",
				"icon": "",
				"format": "tfp.get({cptId})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件id",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cpt",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptType",
				"comment": "获得组件类型定义信息",
				"icon": "",
				"format": "tfp.type('{cptId}')",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cptType",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getCptDataModel",
				"comment": "获得组件数据模型",
				"icon": "",
				"format": "{cptId}.dataModel",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cptData",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.use",
				"comment": "添加组件相关文件引用",
				"format": "tfp.use({cptTypes}, function(){[[statements]]})",
				"icon": "",
				"haveStatements": true,
				"inputs": [
					{
						"name": "cptTypes",
						"comment": "组件类型",
						"type": "string",
						"width": "200px",
						"required": true
					}
				]
			},
			{
				"name": "tfp.new",
				"comment": "使用默认设置创建新组件",
				"format": "tfp.new('{typeName}', {parent})",
				"icon": "",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "typeName",
						"comment": "组件类型",
						"type": "string",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "parent",
						"comment": "父组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cpt",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.render",
				"comment": "根据数据模型创建新组件",
				"format": "tfp.render({dataModel}, {parent})",
				"icon": "",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "dataModel",
						"comment": "组件数据模型",
						"type": "string",
						"required": true
					},
					{
						"name": "parent",
						"comment": "父组件",
						"type": "component",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "cpt",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "removeCpt",
				"comment": "移除组件",
				"format": "{cptId}.remove()",
				"icon": "",
				"inputs": [
					{
						"name": "cptId",
						"comment": "组件",
						"type": "component",
						"required": true
					}
				]
			}
		]
	},
	{
		"name": "check",
		"comment": "数据格式校验",
		"color": "#0033AA",
		"statements": [
			{
				"name": "typeof",
				"comment": "获得变量的数据类型",
				"format": "typeof({varName})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isNull",
				"comment": "是否为空",
				"format": "isNull({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isUndefined",
				"comment": "是否为undefined",
				"format": "(typeof({varName})=='undefined')",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isNum",
				"comment": "是否是数值",
				"format": "!isNaN({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isInt",
				"comment": "是否是整数",
				"format": "tfp.isInt({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isString",
				"comment": "是否是字符串",
				"format": "(typeof({varName})=='string')",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isArray",
				"comment": "是否是数组",
				"format": "Array.isArray({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isObj",
				"comment": "是否是JSON对象",
				"format": "tfp.isObj({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "startWith",
				"comment": "是否以指定字符串开头",
				"format": "{varName}.startWith({str2})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "str2",
						"comment": "子字符串",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "endWith",
				"comment": "是否以指定字符串结尾",
				"format": "{varName}.endWith({str2})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "str2",
						"comment": "子字符串",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "isArrContains",
				"comment": "数组是否包含指定元素",
				"format": "{varName}.contains({item})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "item",
						"comment": "元素值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "isPhone",
				"comment": "是否是有效的手机号",
				"format": "tfp.isPhone({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isTel",
				"comment": "是否是有效的座机号",
				"format": "tfp.isTel({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isIDCard",
				"comment": "是否是有效的身份证号",
				"format": "tfp.isIDCard({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isMail",
				"comment": "是否是有效的邮箱地址",
				"format": "tfp.isMail({varName})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "varName",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					}
				]
			}
		]
	},
	{
		"name": "convert",
		"comment": "数据格式转换",
		"color": "#0033AA",
		"statements": [
			{
				"name": "parseInt",
				"comment": "转换为整数",
				"format": "parseInt({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "表达式",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "num",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "parseFloat",
				"comment": "转换为小数",
				"format": "parseFloat({num})",
				"return": {
					"must": true,
					"type": "float"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "表达式",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "varList",
						"width": "100px",
						"default": "num",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "formatMoney",
				"comment": "数字转换为金额",
				"format": "tfp.formatMoney({num}, {decimal}, {thousands})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "表达式",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "decimal",
						"comment": "小数位数",
						"type": "number",
						"width": "50px",
						"maxLength": 4,
						"default": "2",
						"required": true
					},
					{
						"name": "thousands",
						"comment": "显示千分位",
						"type": "select",
						"width": "50px",
						"default": "true",
						"required": true,
						"options": [
							{
								"value": "true",
								"text": "是"
							},
							{
								"value": "false",
								"text": "否"
							}
						]
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "money",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "formatFileSize",
				"comment": "格式化文件大小",
				"format": "tfp.formatFileSize({bytes})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "bytes",
						"comment": "表达式",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "fileSize",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "strToDate",
				"comment": "字符串转换为日期",
				"format": "new Date({str})",
				"return": {
					"must": true,
					"type": "date"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "表达式",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "date",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "dateToStrCommon",
				"comment": "日期转换为常用格式",
				"format": "tfp.formatDate({date}, '{style}')",
				"return": {
					"must": true,
					"type": "date"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"required": true
					},
					{
						"name": "style",
						"comment": "日期格式",
						"type": "select",
						"width": "180px",
						"required": true,
						"options": [
							{
								"value": "yyyy-MM-dd hh:mm:ss",
								"text": "yyyy-MM-dd hh:mm:ss"
							},
							{
								"value": "yyyy/MM/dd hh:mm:ss",
								"text": "yyyy/MM/dd hh:mm:ss"
							},
							{
								"value": "yyyy-MM-dd",
								"text": "yyyy-MM-dd"
							},
							{
								"value": "yyyy/MM/dd",
								"text": "yyyy/MM/dd"
							},
							{
								"value": "yyyy年MM月dd日",
								"text": "yyyy年MM月dd日"
							},
							{
								"value": "hh:mm:ss",
								"text": "hh:mm:ss"
							},
							{
								"value": "hh时mm分ss秒",
								"text": "hh时mm分ss秒"
							}
						]
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "dateToStrCustom",
				"comment": "日期转换为自定义格式",
				"format": "tfp.formatDate({date}, '{style}')",
				"return": {
					"must": true,
					"type": "date"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"required": true
					},
					{
						"name": "style",
						"comment": "日期格式",
						"type": "string",
						"width": "180px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "strToArray",
				"comment": "字符串拆分为数组",
				"format": "{str}.split('{separateChar}')",
				"return": {
					"must": true,
					"type": "array"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "表达式",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "separateChar",
						"comment": "分隔符",
						"type": "string",
						"default": ",",
						"width": "20px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "arr",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "arrayToStr",
				"comment": "数组拼接为字符串",
				"format": "{arr}.join('{separateChar}')",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "separateChar",
						"comment": "分隔符",
						"type": "string",
						"default": ",",
						"width": "20px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "JSONParse",
				"comment": "将字符串解析为JSON对象",
				"format": "JSON.parse({str})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "150px",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "obj",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "JSONStringify",
				"comment": "将JSON对象转换为字符串",
				"format": "JSON.stringify({obj})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "obj",
						"comment": "JSON对象变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "formatPx",
				"comment": "格式化像素值",
				"format": "tfp.formatPx({value})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "value",
						"comment": "像素值",
						"width": "100px",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "getPx",
				"comment": "获得像素整数值",
				"format": "tfp.getPx({value})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "value",
						"comment": "像素值",
						"width": "100px",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "rgbToHex",
				"comment": "格式化RGB颜色值",
				"format": "tfp.rgbToHex({value})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "value",
						"comment": "颜色值",
						"width": "120px",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "btoa",
				"comment": "BASE64字符串编码",
				"format": "window.btoa({str})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "atob",
				"comment": "BASE64字符串解码",
				"format": "window.atob({str})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "encodeURI",
				"comment": "编码URL路径",
				"format": "encodeURI({url})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "url",
						"comment": "URL路径",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "url",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "encodeURIComponent",
				"comment": "编码URL字符串",
				"format": "encodeURIComponent({str})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "decodeURI",
				"comment": "解码URL路径",
				"format": "decodeURI({url})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "url",
						"comment": "URL路径",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "url",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "decodeURIComponent",
				"comment": "解码URL字符串",
				"format": "decodeURIComponent({str})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			}
		]
	},
	{
		"name": "string",
		"comment": "字符串处理",
		"color": "#FF6633",
		"statements": [
			{
				"name": "length",
				"comment": "获得字符串长度",
				"format": "{str}.length",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "len",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "gblen",
				"comment": "获得字符串字节长度",
				"format": "{str}.gblen()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "len",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "charAt",
				"comment": "返回指定位置的字符",
				"format": "{str}.charAt({index})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "index",
						"comment": "字符位置索引",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "chr",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "indexOf",
				"comment": "查找子字符串首次出现位置",
				"format": "{str1}.indexOf({str2}, {fromindex})",
				"return": {
					"must": true,
					"type": "int"
				},
				"fontsize": "12px",
				"inputs": [
					{
						"name": "str1",
						"comment": "字符串",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "str2",
						"comment": "子字符串",
						"type": "string",
						"required": true
					},
					{
						"name": "fromindex",
						"comment": "查找起始位置索引",
						"type": "string",
						"default": 0
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "pos",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "lastIndexOf",
				"comment": "查找子字符串最后出现位置",
				"format": "{str1}.lastIndexOf({str2}, {fromindex})",
				"return": {
					"must": true,
					"type": "int"
				},
				"fontsize": "12px",
				"inputs": [
					{
						"name": "str1",
						"comment": "字符串",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "str2",
						"comment": "子字符串",
						"type": "string",
						"required": true
					},
					{
						"name": "fromindex",
						"comment": "起始位置",
						"type": "string"
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "pos",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "substring",
				"comment": "截取起止位置的字符串",
				"format": "{str1}.substring({from}, {to})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str1",
						"comment": "字符串",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "from",
						"comment": "起始位置",
						"type": "string",
						"required": true
					},
					{
						"name": "to",
						"comment": "截止位置",
						"type": "string"
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "substr",
				"comment": "截取指定长度的字符串",
				"format": "{str1}.substr({start}, {length})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str1",
						"comment": "字符串",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "start",
						"comment": "起始位置",
						"type": "string",
						"required": true
					},
					{
						"name": "length",
						"comment": "长度",
						"type": "string"
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "replace",
				"comment": "替换第一个匹配项",
				"format": "{str1}.replace({str2})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str1",
						"comment": "被替换的字符串",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "str2",
						"comment": "要替换的字符串",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "replaceAll",
				"comment": "全部替换",
				"format": "tfp.replaceAll({str1}, {str2})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str1",
						"comment": "被替换的字符串",
						"width": "150px",
						"type": "string",
						"required": true
					},
					{
						"name": "str2",
						"comment": "要替换的字符串",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "trim",
				"comment": "去掉字符串两端空格",
				"format": "{str}.trim()",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "split",
				"comment": "分割成字符串数组",
				"format": "{str}.split('{separator}')",
				"return": {
					"must": true,
					"type": "array"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "separator",
						"comment": "分割字符",
						"type": "string",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "arr",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "toLowerCase",
				"comment": "转换为小写字母",
				"format": "{str}.toLowerCase()",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "toUpperCase",
				"comment": "转换为大写字母",
				"format": "{str}.toUpperCase()",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "startsWith",
				"comment": "是否以指定字符串开头",
				"format": "{str1}.startsWith({str2})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "str1",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "str2",
						"comment": "子字符串",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "endsWith",
				"comment": "是否以指定字符串结尾",
				"format": "{str1}.endsWith({str2})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "str1",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "str2",
						"comment": "子字符串",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "JSONParse",
				"comment": "将字符串解析为JSON对象",
				"format": "JSON.parse({str})",
				"return": {
					"must": true,
					"type": "object"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"width": "200px",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "obj",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "JSONStringify",
				"comment": "将JSON对象转换为字符串",
				"format": "JSON.stringify({obj})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "obj",
						"comment": "JSON对象",
						"type": "varList",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			}
		]
	},
	{
		"name": "number",
		"comment": "数值处理",
		"color": "#33A922",
		"statements": [
			{
				"name": "parseInt",
				"comment": "转换为整数",
				"format": "parseInt({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "num",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "parseFloat",
				"comment": "转换为小数",
				"format": "parseFloat({num})",
				"return": {
					"must": true,
					"type": "float"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "num",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.prefixInteger",
				"comment": "数值前面补零",
				"format": "tfp.prefixInteger({num}, {len})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					},
					{
						"name": "len",
						"comment": "长度",
						"type": "int",
						"required": true
					}
				]
			},
			{
				"name": "toFixed",
				"comment": "四舍五入为指定位数小数",
				"format": "{num}.toFixed({len})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					},
					{
						"name": "len",
						"comment": "小数点位数",
						"type": "int",
						"required": true
					}
				]
			},
			{
				"name": "abs",
				"comment": "返回绝对值",
				"format": "Math.abs({num})",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "ceil",
				"comment": "向上舍入为最接近的整数",
				"format": "Math.ceil({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "floor",
				"comment": "向下舍入为最接近的整数",
				"format": "Math.floor({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "round",
				"comment": "舍入为最接近的整数",
				"format": "Math.round({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "trunc",
				"comment": "返回数值的整数部分",
				"format": "Math.trunc({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "sign",
				"comment": "返回数值的符号",
				"format": "Math.sign({num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "num",
						"comment": "数值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "pow",
				"comment": "返回x的y次幂",
				"format": "Math.pow({x}, {y})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "x",
						"comment": "x",
						"type": "string",
						"required": true
					},
					{
						"name": "y",
						"comment": "y",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "sqrt",
				"comment": "返回x的平方根",
				"format": "Math.sqrt({x})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "x",
						"comment": "x",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "random",
				"comment": "返回0到1之间的随机数",
				"format": "Math.random()",
				"return": {
					"must": true,
					"type": "float"
				}
			}
		]
	},
	{
		"name": "date",
		"comment": "日期时间处理",
		"color": "#99C90E",
		"statements": [
			{
				"name": "now",
				"comment": "获得当前时间",
				"format": "new Date()",
				"return": {
					"must": true,
					"type": "date"
				},
				"inputs": [
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "today",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "strToDate",
				"comment": "转换为日期",
				"format": "new Date({str})",
				"return": {
					"must": true,
					"type": "date"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "表达式",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "date",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "tfp.formatDate",
				"comment": "格式化日期",
				"format": "tfp.formatDate({date}, '{format}')",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "表达式",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "format",
						"comment": "日期格式",
						"type": "select",
						"options": [
							{
								"value": "yyyy-MM-dd HH:mm:ss",
								"text": "yyyy-MM-dd HH:mm:ss"
							},
							{
								"value": "yyyy-MM-dd HH:mm",
								"text": "yyyy-MM-dd HH:mm"
							},
							{
								"value": "yyyy-MM-dd",
								"text": "yyyy-MM-dd"
							},
							{
								"value": "yyyy/MM/dd HH:mm:ss",
								"text": "yyyy/MM/dd HH:mm:ss"
							},
							{
								"value": "yyyy/MM/dd HH:mm",
								"text": "yyyy/MM/dd HH:mm"
							},
							{
								"value": "yyyy/MM/dd",
								"text": "yyyy/MM/dd"
							},
							{
								"value": "yyyy年MM月dd日HH时mm分ss秒",
								"text": "yyyy年MM月dd日HH时mm分ss秒"
							},
							{
								"value": "yyyy年MM月dd日HH时mm分",
								"text": "yyyy年MM月dd日HH时mm分"
							},
							{
								"value": "yyyy年MM月dd日",
								"text": "yyyy年MM月dd日"
							},
							{
								"value": "HH:mm:ss",
								"text": "HH:mm:ss"
							},
							{
								"value": "HH:mm",
								"text": "HH:mm"
							},
							{
								"value": "HH时mm分ss秒",
								"text": "HH时mm分ss秒"
							},
							{
								"value": "HH时mm分",
								"text": "HH时mm分"
							}
						],
						"required": true
					}
				]
			},
			{
				"name": "dateToStrCustom",
				"comment": "日期转换为自定义格式",
				"format": "tfp.formatDate({date}, '{style}')",
				"return": {
					"must": true,
					"type": "date"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"required": true
					},
					{
						"name": "style",
						"comment": "日期格式",
						"type": "string",
						"width": "180px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getFullYear",
				"comment": "返回年份",
				"format": "{date}.getFullYear()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "year",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getMonth",
				"comment": "返回月份",
				"format": "{date}.getMonth()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "month",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getDay",
				"comment": "返回星期中的第几天",
				"format": "{date}.getDay()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getDate",
				"comment": "返回月中的第几天",
				"format": "{date}.getDate()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getHours",
				"comment": "返回小时",
				"format": "{date}.getHours()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "hour",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getMinutes",
				"comment": "返回分钟",
				"format": "{date}.getMinutes()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "minute",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getSeconds",
				"comment": "返回秒数",
				"format": "{date}.getSeconds()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "second",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getMilliseconds",
				"comment": "返回毫秒",
				"format": "{date}.getMilliseconds()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "ms",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getTime",
				"comment": "返回毫秒总数",
				"format": "{date}.getTime()",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getIntervalBetweenDates",
				"comment": "返回两个日期的间隔",
				"format": "tfp.getIntervalBetweenDates({date1}, {date2}, '{intervalType}')",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date1",
						"comment": "日期变量1",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "date2",
						"comment": "日期变量1",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "intervalType",
						"comment": "间隔类型",
						"type": "select",
						"options": [
							{
								"value": "date",
								"text": "天"
							},
							{
								"value": "hour",
								"text": "小时"
							},
							{
								"value": "minute",
								"text": "分钟"
							},
							{
								"value": "second",
								"text": "秒"
							}
						],
						"required": true
					}
				]
			},
			{
				"name": "addDate",
				"comment": "日期加减",
				"format": "tfp.addDate({date}, '{intervalType}', {num})",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "date",
						"comment": "日期变量",
						"type": "varList",
						"width": "120px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "intervalType",
						"comment": "间隔类型",
						"type": "select",
						"options": [
							{
								"value": "year",
								"text": "年"
							},
							{
								"value": "month",
								"text": "月"
							},
							{
								"value": "week",
								"text": "周"
							},
							{
								"value": "date",
								"text": "日"
							},
							{
								"value": "hour",
								"text": "小时"
							},
							{
								"value": "minute",
								"text": "分钟"
							},
							{
								"value": "second",
								"text": "秒"
							}
						],
						"required": true
					},
					{
						"name": "num",
						"comment": "加减数量",
						"type": "int",
						"required": true
					}
				]
			}
		]
	},
	{
		"name": "array",
		"comment": "数组处理",
		"color": "#CA3575",
		"statements": [
			{
				"name": "length",
				"comment": "获得数组长度",
				"format": "{arr}.length",
				"return": {
					"must": true,
					"type": "int"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "len",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "pop",
				"comment": "删除最后一个元素",
				"format": "{arr}.pop()",
				"return": {
					"must": false,
					"type": "var"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "push",
				"comment": "在数组结尾处添加元素",
				"format": "{arr}.push({item})",
				"return": {
					"must": false,
					"type": "int"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "item",
						"comment": "元素",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "shift",
				"comment": "删除第一个元素",
				"format": "{arr}.shift()",
				"return": {
					"must": false,
					"type": "var"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "unshift",
				"comment": "在数组开头处添加元素",
				"format": "{arr}.unshift({item})",
				"return": {
					"must": false,
					"type": "int"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "item",
						"comment": "元素",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "setItem",
				"comment": "更改指定索引处元素值",
				"format": "{arr}.[{index}] = {var}",
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "index",
						"comment": "元素索引",
						"type": "string",
						"required": true
					},
					{
						"name": "val",
						"comment": "元素值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "getItem",
				"comment": "获得指定索引处元素值",
				"format": "{arr}.[{index}]",
				"return": {
					"must": true,
					"type": "var"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "index",
						"comment": "元素索引",
						"type": "string",
						"required": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "item",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "isArrContainsItem",
				"comment": "是否包含指定元素",
				"format": "{arr}.contains({item})",
				"return": {
					"must": true,
					"type": "bool"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "变量名",
						"type": "varList",
						"width": "100px",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "item",
						"comment": "元素值",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "exeArrFuncIndexOf",
				"comment": "查找元素首次出现的位置",
				"format": "{arr}.indexOf({item})",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "item",
						"comment": "回调参数名",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "exeArrFuncLastIndexOf",
				"comment": "查找元素最后出现的位置",
				"format": "{arr}.lastIndexOf({item})",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "item",
						"comment": "回调参数名",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "removeItem",
				"comment": "删除指定元素",
				"format": "{arr}.remove({item})",
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "item",
						"comment": "元素",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "splice",
				"comment": "删除指定索引位置元素",
				"format": "{arr}.splice({index}, {len})",
				"return": {
					"must": false,
					"type": "array"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "index",
						"comment": "元素索引",
						"type": "string",
						"required": true
					},
					{
						"name": "len",
						"comment": "删除数量",
						"type": "string",
						"required": true,
						"default": "1"
					}
				]
			},
			{
				"name": "slice",
				"comment": "裁剪数组",
				"format": "{arr}.slice({index}, {len})",
				"return": {
					"must": true,
					"type": "array"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "start",
						"comment": "开始索引",
						"type": "string",
						"required": true
					},
					{
						"name": "end",
						"comment": "结束索引",
						"type": "string",
						"required": true
					}
				]
			},
			{
				"name": "concat",
				"comment": "合并数组",
				"format": "{arr1}.concat({arr2})",
				"return": {
					"must": true,
					"type": "array"
				},
				"inputs": [
					{
						"name": "arr1",
						"comment": "数组变量1",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "arr2",
						"comment": "数组变量2",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "join",
				"comment": "将数组元素连接成字符串",
				"format": "{arr}.join('{separator}')",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量",
						"type": "varList",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "separator",
						"comment": "分割字符",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": ","
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "str",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getArrayMaxItem",
				"comment": "返回元素中最大的数值",
				"format": "Math.max.apply(null, {arr})",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "item",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getArrayMinItem",
				"comment": "返回元素中最小的数值",
				"format": "Math.min.apply(null, {arr})",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "item",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "getArrayMinItem",
				"comment": "求所有元素的合计值",
				"format": "{arr}.reduce(function(total, num){return total + num;})",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "retVarName",
						"comment": "返回给",
						"type": "string",
						"required": true,
						"default": "item",
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "exeArrFuncOrderBy",
				"comment": "对元素进行排序",
				"format": "{arr}.orderBy('{orderType}', {prop})",
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "orderType",
						"comment": "排序规则",
						"type": "select",
						"required": true,
						"options": [
							{
								"value": "asc",
								"text": "升序"
							},
							{
								"value": "desc",
								"text": "降序"
							}
						],
						"required": true
					},
					{
						"name": "prop",
						"comment": "属性名",
						"type": "string"
					}
				]
			},
			{
				"name": "exeArrFuncReverse",
				"comment": "反转元素顺序",
				"format": "{arr}.reverse()",
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					}
				]
			},
			{
				"name": "exeArrFuncFill",
				"comment": "替换元素值",
				"format": "{arr}.fill({value}, {start}, {end})",
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "value",
						"comment": "元素值",
						"type": "string",
						"width": "120px",
						"required": true
					},
					{
						"name": "start",
						"comment": "开始索引",
						"type": "string"
					},
					{
						"name": "end",
						"comment": "结束索引",
						"type": "string"
					}
				]
			},
			{
				"name": "exeArrFuncForEach",
				"comment": "遍历所有元素",
				"format": "{arr}.forEach(function({cbArg1}, {cbArg2}){[[statements]]})",
				"haveStatements": true,
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "cbArg1",
						"comment": "元素参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "item"
					},
					{
						"name": "cbArg2",
						"comment": "索引参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "index"
					}
				]
			},
			{
				"name": "exeArrFuncFilter",
				"comment": "过滤元素",
				"format": "{arr}.filter(function({cbArg}){[[statements]]})",
				"haveStatements": true,
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "item"
					}
				]
			},
			{
				"name": "exeArrFuncEvery",
				"comment": "检测所有元素是否满足条件",
				"format": "{arr}.every(function({cbArg}){[[statements]]})",
				"haveStatements": true,
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "item"
					}
				]
			},
			{
				"name": "exeArrFuncSome",
				"comment": "检测是否有满足条件元素",
				"format": "{arr}.some(function({cbArg}){[[statements]]})",
				"haveStatements": true,
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "item"
					}
				]
			},
			{
				"name": "exeArrFuncFind",
				"comment": "查找第1个满足条件的元素",
				"format": "{arr}.find(function({cbArg}){[[statements]]})",
				"haveStatements": true,
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "item"
					}
				]
			},
			{
				"name": "exeArrFuncFindIndex",
				"comment": "查找第1个满足条件的元素位置",
				"format": "{arr}.findIndex(function({cbArg}){[[statements]]})",
				"haveStatements": true,
				"return": {
					"must": true,
					"type": "number"
				},
				"fontsize": "12px",
				"inputs": [
					{
						"name": "arr",
						"comment": "数组变量名",
						"type": "varList",
						"required": true,
						"isOnlyStr": true
					},
					{
						"name": "cbArg",
						"comment": "回调参数名",
						"type": "string",
						"required": true,
						"isOnlyStr": true,
						"default": "item"
					}
					,
					{
						"name": "exeArrFuncFind",
						"comment": "查找第1个满足条件的元素",
						"format": "{arr}.find(function({cbArg}){[[statements]]})",
						"haveStatements": true,
						"return": {
							"must": true,
							"type": "number"
						},
						"inputs": [
							{
								"name": "arr",
								"comment": "数组变量名",
								"type": "varList",
								"required": true,
								"isOnlyStr": true
							},
							{
								"name": "cbArg",
								"comment": "回调参数名",
								"type": "string",
								"required": true,
								"isOnlyStr": true,
								"default": "item"
							}
						]
					}]
			}
			/*,
			{
				"name": "avg",
				"comment": "返回所有元素的平均值",
				"format": "{arr}.avg()",
				"return": {
					"must": true,
					"type": "number"
				},
				"inputs": [
					{
						"name": "arr",
						"comment": "数组名称",
						"type": "string",
						"required": true
					}
				]
			}*/
		]
	},
	{
		"name": "cache",
		"comment": "浏览器存储",
		"color": "#003399",
		"statements": [
			{
				"name": "localStorageSet",
				"comment": "设置永久存储键值对",
				"format": "localStorage.setItem('{key}', {value})",
				"inputs": [
					{
						"name": "key",
						"comment": "键",
						"type": "string",
						"width": "120px",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "value",
						"comment": "值",
						"type": "string",
						"width": "180px",
						"required": true
					}
				]
			},
			{
				"name": "localStorageGet",
				"comment": "获取永久存储键值",
				"format": "localStorage.getItem('{key}')",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "key",
						"comment": "键",
						"type": "string",
						"width": "120px",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "localStorageRemove",
				"comment": "移除永久存储键值对",
				"format": "localStorage.removeItem('{key}')",
				"inputs": [
					{
						"name": "key",
						"comment": "键",
						"type": "string",
						"width": "120px",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "localStorageClear",
				"comment": "清空永久存储键值对",
				"format": "localStorage.clear()"
			},
			{
				"name": "sessionStorageSet",
				"comment": "设置临时存储键值对",
				"format": "sessionStorage.setItem('{key}', {value})",
				"inputs": [
					{
						"name": "key",
						"comment": "键",
						"type": "string",
						"width": "120px",
						"isOnlyStr": true,
						"required": true
					},
					{
						"name": "value",
						"comment": "值",
						"type": "string",
						"width": "180px",
						"required": true
					}
				]
			},
			{
				"name": "sessionStorageGet",
				"comment": "获取临时存储键值",
				"format": "sessionStorage.getItem('{key}')",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "key",
						"comment": "键",
						"type": "string",
						"width": "120px",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "sessionStorageRemove",
				"comment": "移除临时存储键值对",
				"format": "sessionStorage.removeItem('{key}')",
				"inputs": [
					{
						"name": "key",
						"comment": "键",
						"type": "string",
						"width": "120px",
						"isOnlyStr": true,
						"required": true
					}
				]
			},
			{
				"name": "sessionStorageClear",
				"comment": "清空临时存储键值",
				"format": "sessionStorage.clear()"
			}
		]
	},
	{
		"name": "enc-dec",
		"comment": "加密解密",
		"color": "#990000",
		"statements": [
			{
				"name": "md5",
				"comment": "MD5加密",
				"format": "tfp.md5({str})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "200px",
						"required": true
					}
				]
			},
			{
				"name": "encDES",
				"comment": "DES加密",
				"format": "tfp.encDES({str}, {key})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "key",
						"comment": "密钥",
						"type": "string",
						"width": "120px",
						"required": true
					}
				]
			},
			{
				"name": "decDES",
				"comment": "DES解密",
				"format": "tfp.decDES({str}, {key})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "key",
						"comment": "密钥",
						"type": "string",
						"width": "120px",
						"required": true
					}
				]
			},
			{
				"name": "encAES",
				"comment": "AES加密",
				"format": "tfp.encAES({str}, {key}, {iv})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "key",
						"comment": "密钥",
						"type": "string",
						"width": "120px",
						"required": true
					},
					{
						"name": "iv",
						"comment": "向量",
						"type": "string",
						"width": "80px",
						"required": true
					}
				]
			},
			{
				"name": "decAES",
				"comment": "AES解密",
				"format": "tfp.decAES({str}, {key}, {iv})",
				"return": {
					"must": true,
					"type": "string"
				},
				"inputs": [
					{
						"name": "str",
						"comment": "字符串",
						"type": "string",
						"width": "200px",
						"required": true
					},
					{
						"name": "key",
						"comment": "密钥",
						"type": "string",
						"width": "120px",
						"required": true
					},
					{
						"name": "iv",
						"comment": "向量",
						"type": "string",
						"width": "80px",
						"required": true
					}
				]
			}
		]
	}
]