"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || (0, _typeof2["default"])(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * 动态引用js文件
 * @param  {[type]} url [description]
 * @return {[type]}     [description]
 */
function importJsFile(url) {
  return new Promise(function (resolve, reject) {
    var script = document.createElement("script");
    script.type = "text/javascript";

    if (script.readyState) {
      script.onreadystatechange = function () {
        if (script.readyState == "loaded" || script.readyState == "complete") {
          script.onreadystatechange = null;
          resolve();
        }
      };
    } else {
      script.onload = function () {
        resolve();
      };
    }

    script.src = url;
    document.body.appendChild(script);
  });
}
/**
 * 动态引入CSS文件
 * @param {*} filePath 
 * @returns 
 */


function importCssFile(filePath) {
  return new Promise(function (resolve, reject) {
    var xhr = new XMLHttpRequest();

    xhr.onreadystatechange = function () {
      if (xhr.readyState === 4 && xhr.status === 200) {
        var style = document.createElement("style");
        style.type = "text/css";
        style.innerHTML = xhr.responseText;
        style.setAttribute("filePath", filePath);
        document.head.appendChild(style);
        resolve();
      }
    };

    xhr.open("GET", filePath, true);
    xhr.send();
  });
}
/**
 * 获得需要导入的组件类型
 * @return {[type]} [description]
 */


function getNeedImportCptType(tfp, cptTypeName, needImportCptTypes) {
  var metadata = tfp.metaDatas[cptTypeName];
  if (!metadata) return; //如果有依赖项，则需要优先加载

  var dependencies = [];

  if (metadata.dependencies) {
    if (typeof metadata.dependencies == "string") {
      dependencies.push(metadata.dependencies);
    } else if (Array.isArray(metadata.dependencies)) {
      dependencies.push.apply(dependencies, metadata.dependencies);
    }
  }

  if (dependencies.length > 0) {
    for (var i = 0; i < dependencies.length; i++) {
      getNeedImportCptType(tfp, dependencies[i], needImportCptTypes);
    }
  }

  if (!needImportCptTypes.includes(cptTypeName)) needImportCptTypes.push(cptTypeName);
}
/**
 * 添加组件相关文件的引用
 * @param  {[type]}   tfp           [description]
 * @param  {[type]}   pageDataModel [description]
 * @param  {[type]}   cptTypes      [description]
 * @param  {Function} cb            [description]
 * @return {[type]}                 [description]
 */


function importCptFiles(_x, _x2, _x3, _x4) {
  return _importCptFiles.apply(this, arguments);
}

function _importCptFiles() {
  _importCptFiles = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(tfp, pageDataModel, cptTypes, cb) {
    var needImportCptTypes, i, _i, cptTypeName, metadata, metadataFile, controllerFile, renderFile, clientType, matchAllClient, isInvisible, dependencies, metaModule, controllerModule, renderModule, tfpPath, cssFiles, bgColorMode, j, styleFile, jsFiles, _j, jsFile;

    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            //获得所有需要导入的组件类型，包括相关依赖组件
            needImportCptTypes = [];

            for (i = 0; i < cptTypes.length; i++) {
              getNeedImportCptType(tfp, cptTypes[i], needImportCptTypes);
            }

            _i = 0;

          case 3:
            if (!(_i < needImportCptTypes.length)) {
              _context.next = 91;
              break;
            }

            cptTypeName = needImportCptTypes[_i];
            metadata = tfp.metaDatas[cptTypeName];

            if (metadata) {
              _context.next = 8;
              break;
            }

            return _context.abrupt("continue", 88);

          case 8:
            metadataFile = "./components/" + cptTypeName.toLowerCase() + "/metadata";
            controllerFile = "./components/" + cptTypeName.toLowerCase() + "/controller";
            renderFile = "./components/" + cptTypeName.toLowerCase() + "/render";
            clientType = pageDataModel.client;
            if (clientType == "tb") clientType = "pc";

            if (!metadata.matchAllClient) {
              if (clientType == "pc" && pageDataModel.pageType == "print-report" && (cptTypeName == "Page" || cptTypeName == "GridView")) {
                metadataFile += ".print";
              } else {
                metadataFile += "." + clientType;
              }

              controllerFile += "." + clientType;
              renderFile += "." + clientType;
            }

            metadataFile += ".js";
            controllerFile += ".js";
            renderFile += ".js";

            if (metadata.isLoaded) {
              _context.next = 31;
              break;
            }

            matchAllClient = metadata.matchAllClient;
            isInvisible = metadata.isInvisible;
            dependencies = null;
            if (metadata.dependencies) dependencies = metadata.dependencies;
            _context.next = 24;
            return Promise.resolve("".concat(metadataFile)).then(function (s) {
              return _interopRequireWildcard(require(s));
            });

          case 24:
            metaModule = _context.sent;
            metadata = metaModule["default"];
            metadata.isLoaded = true;
            if (matchAllClient) metadata.matchAllClient = matchAllClient;
            if (isInvisible) metadata.isInvisible = isInvisible;
            if (dependencies) metadata.dependencies = dependencies;
            tfp.metaDatas[cptTypeName] = metadata;

          case 31:
            if (tfp.controllers[cptTypeName]) {
              _context.next = 36;
              break;
            }

            _context.next = 34;
            return Promise.resolve("".concat(controllerFile)).then(function (s) {
              return _interopRequireWildcard(require(s));
            });

          case 34:
            controllerModule = _context.sent;
            tfp.controllers[cptTypeName] = controllerModule["default"];

          case 36:
            if (tfp.renders[cptTypeName]) {
              _context.next = 41;
              break;
            }

            _context.next = 39;
            return Promise.resolve("".concat(renderFile)).then(function (s) {
              return _interopRequireWildcard(require(s));
            });

          case 39:
            renderModule = _context.sent;
            tfp.renders[cptTypeName] = renderModule["default"];

          case 41:
            if (!(typeof window != "undefined")) {
              _context.next = 88;
              break;
            }

            tfpPath = tfp.rootPath + "/src/components/";

            if (tfp.isDesigning) {
              _context.next = 68;
              break;
            }

            cssFiles = [];

            if (metadata.cssFiles) {
              if (typeof metadata.cssFiles == "string") {
                cssFiles = [metadata.cssFiles];
              } else if (Array.isArray(metadata.cssFiles)) {
                cssFiles = metadata.cssFiles;
              }
            }

            bgColorMode = "light";
            if (pageDataModel.bgColorMode == "dark") bgColorMode = "dark";
            j = 0;

          case 49:
            if (!(j < cssFiles.length)) {
              _context.next = 68;
              break;
            }

            styleFile = cssFiles[j];

            if (!styleFile.onlyRuntime) {
              _context.next = 55;
              break;
            }

            if (!(tfp.isDesigning || pageDataModel.client == "tb")) {
              _context.next = 54;
              break;
            }

            return _context.abrupt("continue", 65);

          case 54:
            styleFile = styleFile.src;

          case 55:
            if (!styleFile.onlyDesigning) {
              _context.next = 59;
              break;
            }

            if (!(tfp.isRuntime && pageDataModel.client != "tb")) {
              _context.next = 58;
              break;
            }

            return _context.abrupt("continue", 65);

          case 58:
            styleFile = styleFile.src;

          case 59:
            styleFile = styleFile.replace("{client}", clientType);
            styleFile = styleFile.replace("{bgColorMode}", bgColorMode);
            styleFile = tfp.getCptIncludeFile(styleFile, cptTypeName, pageDataModel);

            if (!($("style[filePath='" + styleFile + "']").length == 0)) {
              _context.next = 65;
              break;
            }

            _context.next = 65;
            return importCssFile(styleFile);

          case 65:
            j++;
            _context.next = 49;
            break;

          case 68:
            jsFiles = [];

            if (metadata.jsFiles) {
              if (typeof metadata.jsFiles == "string") {
                jsFiles = [metadata.jsFiles];
              } else if (Array.isArray(metadata.jsFiles)) {
                jsFiles = metadata.jsFiles;
              }
            }

            _j = 0;

          case 71:
            if (!(_j < jsFiles.length)) {
              _context.next = 88;
              break;
            }

            jsFile = jsFiles[_j];

            if (!jsFile.onlyRuntime) {
              _context.next = 77;
              break;
            }

            if (!(tfp.isDesigning || pageDataModel.client == "tb")) {
              _context.next = 76;
              break;
            }

            return _context.abrupt("continue", 85);

          case 76:
            jsFile = jsFile.src;

          case 77:
            if (!jsFile.onlyDesigning) {
              _context.next = 81;
              break;
            }

            if (!(tfp.isRuntime && pageDataModel.client != "tb")) {
              _context.next = 80;
              break;
            }

            return _context.abrupt("continue", 85);

          case 80:
            jsFile = jsFile.src;

          case 81:
            jsFile = tfp.getCptIncludeFile(jsFile, cptTypeName, pageDataModel);

            if (!($("script[src='" + jsFile + "']").length == 0)) {
              _context.next = 85;
              break;
            }

            _context.next = 85;
            return importJsFile(jsFile);

          case 85:
            _j++;
            _context.next = 71;
            break;

          case 88:
            _i++;
            _context.next = 3;
            break;

          case 91:
            if (cb) cb();

          case 92:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _importCptFiles.apply(this, arguments);
}