"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 富文本展组件
 * @param {[type]} dataModel [description]
 */
var WxParse = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(WxParse, _VisibleComponent);

  var _super = _createSuper(WxParse);

  function WxParse(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, WxParse);
    return _super.call(this, __tfp, "WxParse", dataModel, parent);
  }

  (0, _createClass2["default"])(WxParse, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "wxParseData",
    get: function get() {
      return this.dataModel.wxParseData;
    },
    set: function set(value) {
      this.dataModel.wxParseData = value;
    } //富文本内容

  }, {
    key: "wxParseContent",
    get: function get() {
      return this.dataModel.wxParseContent;
    },
    set: function set(value) {
      this.dataModel.wxParseContent = value;

      if (this._jqObj) {
        if (!this.dataModel.loadDataService) {
          this._jqObj.html(value);
        }
      }
    }
  }, {
    key: "loadData",
    value: function loadData() {
      if (!this.dataModel.loadDataService) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.loadDataService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
        return;
      }

      if (!this.dataModel.dataBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      if (!this.dataModel.wxParseData) {
        alert("请为[" + this.id + "]设置富文本绑定字段！");
        return;
      }

      var that = this;
      serviceCpt.request(null, function (req, res) {
        var data = res[that.dataModel.dataBindingMember];
        that.bindData(data);
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel.loadDataService) {
        this.loadData();
      } else {
        if (this._jqObj) {
          this._jqObj.empty();
        }
      }
    }
  }]);
  return WxParse;
}(_controller.VisibleComponent);

exports["default"] = WxParse;