"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = _interopRequireDefault(require("../fileupload/controller.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 视频上传组件
 * @param {[type]} dataModel [description]
 */
var VideoUpload = /*#__PURE__*/function (_FileUpload) {
  (0, _inherits2["default"])(VideoUpload, _FileUpload);

  var _super = _createSuper(VideoUpload);

  function VideoUpload(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, VideoUpload);
    return _super.call(this, __tfp, dataModel, parent, "VideoUpload");
  } //保持唯一


  (0, _createClass2["default"])(VideoUpload, [{
    key: "onlyOne",
    get: function get() {
      return this.dataModel.onlyOne;
    },
    set: function set(value) {
      this.dataModel.onlyOne = value;
      this.dataModel.size = 1;

      if (this._tfp.isDesigning && this.dataModel.onlyOne) {
        uiDesigner.setCurCptAttrSettingVal("size", "1");
      }
    } //是否只读

  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      if (!this.dataModel.readonly) delete this.dataModel.readonly;
    } // 视频宽度

  }, {
    key: "videoWidth",
    get: function get() {
      return this.dataModel.videoWidth;
    },
    set: function set(value) {
      this.dataModel.videoWidth = value;

      if (this._jqObj) {
        if (value == '24') {
          this._jqObj.find(".video_box").css("height", "90px");

          this.dataModel.videoHeight = 90;
        } else if (value == '32') {
          this._jqObj.find(".video_box").css("height", "115px");

          this.dataModel.videoHeight = 115;
        } else if (value == '49') {
          this._jqObj.find(".video_box").css("height", "175px");

          this.dataModel.videoHeight = 175;
        } else if (value == '99') {
          this._jqObj.find(".video_box").css("height", "175px");

          this.dataModel.videoHeight = 175;
        }

        this._jqObj.find(".video_box").css("width", value + "%");
      }
    } // 视频高度

  }, {
    key: "videoHeight",
    get: function get() {
      return this.dataModel.videoHeight;
    },
    set: function set(value) {
      this.dataModel.videoHeight = value;

      if (this._jqObj) {
        this._jqObj.find(".video_box").css("height", value + "px");
      }
    } // 视频边距

  }, {
    key: "videoMargin",
    get: function get() {
      return this.dataModel.videoMargin;
    },
    set: function set(value) {
      this.dataModel.videoMargin = value;

      if (this._jqObj) {
        this._jqObj.find(".video_box").css("margin-bottom", value + "%");

        this._jqObj.find(".video_box").css("margin-right", value + "%");
      }
    } // 隐藏允许删除

  }, {
    key: "allowDelete",
    get: function get() {
      return this.dataModel.allowDelete;
    },
    set: function set(value) {
      this.dataModel.allowDelete = value;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find(".video_box.delvideo_box").css("display", 'none');
        } else {
          this._jqObj.find(".video_box.delvideo_box").css("display", 'flex');
        }
      }
    } // 隐藏允许添加

  }, {
    key: "allowAdd",
    get: function get() {
      return this.dataModel.allowAdd;
    },
    set: function set(value) {
      this.dataModel.allowAdd = value;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find(".video_box.addvideo_box").css("display", 'none');
        } else {
          this._jqObj.find(".video_box.addvideo_box").css("display", 'flex');
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      that.dataModel.videoWidth = '32';
    }
  }]);
  return VideoUpload;
}(_controller["default"]);

exports["default"] = VideoUpload;