"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Transfer",
  "comment": "穿梭框",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "列表设置",
    "type": "group",
    "items": [{
      "name": "defaultVal",
      "comment": "组件值",
      "type": "String"
    }, {
      "name": "options",
      "comment": "选项设置",
      "type": "Dataset",
      "columns": [{
        "id": "value",
        "name": "选项值",
        "type": "String",
        "required": true,
        "width": "200px"
      }, {
        "id": "text",
        "name": "选项文本",
        "type": "String",
        "width": "320px"
      }]
    }, {
      "name": "titleLeft",
      "comment": "左侧列表标题",
      "type": "String",
      "default": "列表1"
    }, {
      "name": "titleRight",
      "comment": "右侧列表标题",
      "type": "String",
      "default": "列表2"
    }, {
      "name": "search",
      "comment": "搜索",
      "type": "Switch",
      "default": false
    }, {
      "name": "valueType",
      "comment": "值类型",
      "type": "Select",
      "options": [{
        "value": "value",
        "text": "节点编号"
      }, {
        "value": "text",
        "text": "节点名称"
      }, {
        "value": "obj",
        "text": "节点对象"
      }],
      "default": "value",
      "notnull": true
    }]
  }, {
    "name": "dataSourceSetting",
    "comment": "数据源设置",
    "type": "group",
    "items": [{
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    }, {
      "name": "dataListValueFormat",
      "comment": "选项值数据格式",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "dataListTextFormat",
      "comment": "选项文本数据格式",
      "type": "String",
      "showModelFieldList": true
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "500px",
    "height": "300px",
    "min-width": "500px",
    "min-height": "150px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }],
  "methods": [{
    "name": "setValue",
    "comment": "设置默认值",
    "args": [{
      "name": "values",
      "comment": "默认值",
      "type": "String"
    }]
  }]
};
exports["default"] = _default;