"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 穿梭框组件
 * @param {[type]} dataModel [description]
 */
var Transfer = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Transfer, _FormInput);

  var _super = _createSuper(Transfer);

  function Transfer(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Transfer);
    return _super.call(this, __tfp, "Transfer", dataModel, parent);
  }

  (0, _createClass2["default"])(Transfer, [{
    key: "defaultVal",
    get: function get() {
      return this.dataModel.defaultVal;
    },
    set: function set(value) {
      this.dataModel.defaultVal = value;
      this.setDefaultVal();
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(options) {
      if (this._jqObj && options && Array.isArray(options)) {
        this.dataModel.options = options;

        if (this._jqObj) {
          this.reRender();
        }
      }
    }
  }, {
    key: "titleLeft",
    get: function get() {
      return this.dataModel.titleLeft;
    },
    set: function set(value) {
      this.dataModel.titleLeft = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "titleRight",
    get: function get() {
      return this.dataModel.titleRight;
    },
    set: function set(value) {
      this.dataModel.titleRight = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "search",
    get: function get() {
      return this.dataModel.search;
    },
    set: function set(value) {
      this.dataModel.search = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "valueType",
    get: function get() {
      return this.dataModel.valueType;
    },
    set: function set(value) {
      if (!this.checkAttrOption("valueType", value)) {
        this._tfp.showMsg("不支持类型：" + value + "！");

        return;
      }

      this.dataModel.valueType = value;
      this.setDefaultVal();
    }
  }, {
    key: "loadDataListService",
    get: function get() {
      return this.dataModel.loadDataListService;
    },
    set: function set(value) {
      this.dataModel.loadDataListService = value;
    }
  }, {
    key: "dataListBindingMember",
    get: function get() {
      return this.dataModel.dataListBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataListBindingMember = value;
    }
  }, {
    key: "dataListValueFormat",
    get: function get() {
      return this.dataModel.dataListValueFormat;
    },
    set: function set(value) {
      this.dataModel.dataListValueFormat = value;
    }
  }, {
    key: "dataListTextFormat",
    get: function get() {
      return this.dataModel.dataListTextFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTextFormat = value;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var valueFormat = this.dataModel.dataListValueFormat;
          if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
          option.value = this._tfp.replaceDataField(row, valueFormat);
          if (option.value) option.value = this._tfp.exeExpress(option.value);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.value)) continue;
        option.text = option.value;

        if (this.dataModel.dataListTextFormat) {
          try {
            var textFormat = this.dataModel.dataListTextFormat;
            if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
            option.text = this._tfp.replaceDataField(row, textFormat);
            if (option.text) option.text = this._tfp.exeExpress(option.text);
          } catch (e) {
            console.log(e);
            return;
          }
        }

        if (isNull(option.text)) continue;
        options.push(option);
      }

      this.options = options;
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());

      if (!this._tfp.isDesigning) this.bindTransferChange();
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";
      var arrVal = [];
      if (this.dataModel.defaultVal) arrVal = (this.dataModel.defaultVal + "").split(",");
      html += indent + "<div class=\"tfp-transfer-meun\">\n      <div class=\"tfp-transfer-title\">\n        <div><label><input type=\"checkbox\" class=\"left_checkbox\">" + this.dataModel.titleLeft + "</label></div>\n        <div class=\"tfp-transfer-num\"><span class=\"old_select_length\">0</span>/<span class=\"old_total_length\">0</span>\n        </div>\n      </div>";
      if (this.dataModel.search) html += "<div class=\"tfp-transfer-search\">\n        <input class=\"old_search\" type=\"text\" placeholder=\"\u8BF7\u8F93\u5165\" />\n      </div>";
      html += "<div class=\"old_select\"";
      if (!this.dataModel.search) html += " style=\"top:40px;\"";
      html += ">";
      if (this.dataModel.options) for (var i = 0; i < this.dataModel.options.length; i++) {
        var val = this.dataModel.options[i].value;
        var txt = this.dataModel.options[i].text;
        if (!txt) txt = val;
        if (!arrVal.includes(val)) html += "<label value=\"" + val + "\" title=\"" + txt + "\"><input type=\"checkbox\">" + txt + "</label>";
      }
      html += "</div>\n    </div>\n\n    <div class=\"tfp-transfer-meun\">\n      <div class=\"click_button\">\n        <div><button class=\"to_right\">></button></div>\n        <div><button class=\"to_left\"><</button></div>\n      </div>\n    </div>\n\n    <div class=\"tfp-transfer-meun\">\n      <div class=\"tfp-transfer-title\">\n        <div><label><input type=\"checkbox\" class=\"right_checkbox\">" + this.dataModel.titleRight + "</label></div>\n        <div class=\"tfp-transfer-num\"><span class=\"new_select_length\">0</span>/<span class=\"new_total_length\">0</span>\n        </div>\n      </div>";
      if (this.dataModel.search) html += "<div class=\"tfp-transfer-search\">\n        <input class=\"new_search\" type=\"text\" placeholder=\"\u8BF7\u8F93\u5165\" />\n      </div>";
      html += "<div class=\"new_select\"";
      if (!this.dataModel.search) html += " style=\"top:40px;\"";
      html += ">";
      if (this.dataModel.options) for (var i = 0; i < this.dataModel.options.length; i++) {
        var _val = this.dataModel.options[i].value;
        var _txt = this.dataModel.options[i].text;
        if (!_txt) _txt = _val;
        if (arrVal.includes(_val)) html += "<label value=\"" + _val + "\" title=\"" + _txt + "\"><input type=\"checkbox\">" + _txt + "</label>";
      }
      html += "</div>\n    </div>";
      return html + "\t";
    }
  }, {
    key: "bindTransferChange",
    value: function bindTransferChange() {
      var that = this;
      length_return();
      $(".left_checkbox").click(function () {
        if ($(this).is(":checked")) {
          $(".old_select").find("input").each(function () {
            $(this).prop("checked", true);
          });
        } else {
          $(".old_select").find("input").each(function () {
            $(this).prop("checked", false);
          });
        }

        length_return();
      });
      $(".right_checkbox").click(function () {
        if ($(this).is(":checked")) {
          $(".new_select").find("input").each(function () {
            $(this).prop("checked", true);
          });
        } else {
          $(".new_select").find("input").each(function () {
            $(this).prop("checked", false);
          });
        }

        length_return();
      });
      $(".old_select").find("input").click(function () {
        if ($(".old_select").find("label").length == 0) return;
        var flagLeft = true;
        $(".old_select").find("input").each(function () {
          if (!$(this).is(":checked")) flagLeft = false;
        });
        $(".left_checkbox").prop("checked", flagLeft);
        length_return();
      });
      $(".new_select").find("input").click(function () {
        if ($(".new_select").find("label").length == 0) return;
        var flagRight = true;
        $(".new_select").find("input").each(function () {
          if (!$(this).is(":checked")) flagRight = false;
        });
        $(".right_checkbox").prop("checked", flagRight);
        length_return();
      });
      $(".to_left").click(function () {
        var old_select = $(".old_select");
        var new_select = $(".new_select");
        var oldHtml = [];
        new_select.find("input:checked").each(function () {
          oldHtml.push($(this).parent());
        });
        old_select.prepend.apply(old_select, oldHtml);
        $("input").prop("checked", false);
        length_return();
        that.setTransferValue();
      });
      $(".to_right").click(function () {
        var old_select = $(".old_select");
        var new_select = $(".new_select");
        var newHtml = [];
        old_select.find("input:checked").each(function () {
          newHtml.push($(this).parent());
        });
        new_select.prepend.apply(new_select, newHtml);
        $("input").prop("checked", false);
        length_return();
        that.setTransferValue();
      });
      $(".old_search").on("input change", function (event) {
        var old_select = $(".old_select");
        var kw = $(this).val().trim();

        if (!kw) {
          old_select.find("label").show();
        }

        old_select.find("label").each(function () {
          $(this).show();

          if ($(this).text().indexOf(kw) < 0) {
            $(this).hide();
          }
        });
      });
      $(".new_search").on("input change", function (event) {
        var new_select = $(".new_select");
        var kw = $(this).val().trim();

        if (!kw) {
          new_select.find("label").show();
        }

        new_select.find("label").each(function () {
          $(this).show();

          if ($(this).text().indexOf(kw) < 0) {
            $(this).hide();
          }
        });
      });

      function length_return() {
        var old_total_length = $(".old_select").find("label").length;
        var old_select_length = $(".old_select").find("input[type=checkbox]:checked").length;
        var new_total_length = $(".new_select").find("label").length;
        var new_select_length = $(".new_select").find("input[type=checkbox]:checked").length;
        $(".old_total_length").text(old_total_length);
        $(".old_select_length").text(old_select_length);
        $(".new_total_length").text(new_total_length);
        $(".new_select_length").text(new_select_length);
      }

      ;
    }
  }, {
    key: "setTransferValue",
    value: function setTransferValue() {
      var transferObj = [];
      var transferValue = [];
      var transferText = [];

      for (var j = 0; j < $(".new_select").find("label").length; j++) {
        var label = $(".new_select").find("label").eq(j);

        for (var i = 0; i < this.dataModel.options.length; i++) {
          var option = this.dataModel.options[i];

          if (option.value == label.attr("value")) {
            transferObj.push(option);
            transferValue.push(option.value);
            if (option.text) transferText.push(option.text);
            break;
          }
        }
      }

      if (transferObj.length == 0 || transferValue.length == 0 || transferText.length == 0) {
        this.value = '';
        return '';
      }

      if (this.dataModel.valueType == "obj") {
        this.value = transferObj;
      } else if (this.dataModel.valueType == "text") {
        this.value = transferText;
      } else {
        this.value = transferValue;
      }
    }
  }, {
    key: "addRightOption",
    value: function addRightOption(value, text) {
      this._jqObj.find(".new_select").append("<label value=\"" + value + "\" title=\"" + text + "\"><input type=\"checkbox\">" + text + "</label>");
    }
  }, {
    key: "setDefaultVal",
    value: function setDefaultVal() {
      var arrVal = [];
      if (this.dataModel.defaultVal) arrVal = (this.dataModel.defaultVal + "").split(",");

      if (this.dataModel.options && arrVal) {
        var transferObj = [];
        var transferValue = [];
        var transferText = [];

        for (var i = 0; i < arrVal.length; i++) {
          var val = arrVal[i];

          for (var j = 0; j < this.dataModel.options.length; j++) {
            var option = this.dataModel.options[j];

            if (option.value == val) {
              transferObj.push(option);
              transferValue.push(option.value);
              if (option.text) transferText.push(option.text);
              break;
            }
          }
        }

        if (transferObj.length == 0 || transferValue.length == 0 || transferText.length == 0) {
          this.dataModel.value = '';
        }

        if (this.dataModel.valueType == "obj") {
          this.dataModel.value = transferObj;
        } else if (this.dataModel.valueType == "text") {
          this.dataModel.value = transferText;
        } else {
          this.dataModel.value = transferValue;
        }
      }

      if (!this._tfp.isDesigning) {
        this.value = this.dataModel.value;
        this.valueOnChange();
        this.exeEventHandler("onChange", this.value);
      }

      if (this.dataModel.value) {
        this.reRender();
      }
    }
  }, {
    key: "setValue",
    value: function setValue(values) {
      this.dataModel.defaultVal = values;
      this.setDefaultVal();
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListValueFormat) {
        alert("请为[" + this.id + "]设置选项值数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel.value) this.value = this.dataModel.value; //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this.setDefaultVal();
      this.bindTransferChange();
    }
  }]);
  return Transfer;
}(_controller.FormInput);

exports["default"] = Transfer;