"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "TimeLine",
  "comment": "时间线",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "basicSetting",
    "comment": "基础设置",
    "type": "group",
    "items": [{
      "name": "options",
      "comment": "选项设置",
      "type": "Dataset",
      "isPro": true,
      "keyCol": "name",
      "width": "640px",
      "height": "600px",
      "columns": [{
        "id": "text",
        "name": "节点标题",
        "type": "String"
      }, {
        "id": "time",
        "name": "节点时间",
        "type": "String"
      }, {
        "id": "color",
        "name": "节点颜色",
        "type": "Color",
        "default": "#e4e7ed"
      }, {
        "id": "icon",
        "name": "节点图标",
        "type": "String"
      }, {
        "id": "onClick",
        "name": "点击后执行的脚本",
        "type": "Event",
        "width": "180px",
        "wrap": true
      }]
    }, {
      "name": "alignment",
      "comment": "对齐方式",
      "type": "Select",
      "default": "left",
      "options": [{
        "value": "center",
        "text": "居中对齐"
      }, {
        "value": "left",
        "text": "左对齐"
      }]
    }, {
      "name": "sort",
      "comment": "排序方式",
      "type": "Select",
      "default": "positiveSequence",
      "options": [{
        "value": "positiveSequence",
        "text": "正序"
      }, {
        "value": "invertedOrder",
        "text": "倒序"
      }]
    }, {
      "name": "timeTop",
      "comment": "⾃定义时间戳",
      "type": "Switch"
    }, {
      "name": "broadwise",
      "comment": "横向时间线",
      "type": "Switch"
    }, {
      "name": "timeLineWidth",
      "comment": "时间线宽度",
      "type": "Int",
      "default": "200"
    }]
  }, {
    "name": "dataSourceSetting",
    "comment": "数据源设置",
    "type": "group",
    "items": [{
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    }, {
      "name": "dataListTextFormat",
      "comment": "节点标题数据格式",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "dataListTimeFormat",
      "comment": "节点时间数据格式",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "dataListIconFormat",
      "comment": "节点图标数据格式",
      "type": "String",
      "showModelFieldList": true
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "520px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClickOption",
    "comment": "点击节点项时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int",
      "required": true
    }, {
      "name": "value",
      "comment": "选项值",
      "type": "String",
      "required": true
    }]
  }]
};
exports["default"] = _default;