"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 时间线组件
 * @param {[type]} dataModel [description]
 */
var TimeLine = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(TimeLine, _FormInput);

  var _super = _createSuper(TimeLine);

  function TimeLine(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, TimeLine);
    _this = _super.call(this, __tfp, "TimeLine", dataModel, parent);

    if (!_this.dataModel.options || _this.dataModel.options.length == 0) {
      _this.dataModel.options = [{
        text: "timeline1",
        time: "2023-03-30"
      }, {
        text: "timeline2",
        time: "2023-03-31"
      }, {
        text: "timeline3",
        time: "2023-04-01"
      }];
    }

    return _this;
  }

  (0, _createClass2["default"])(TimeLine, [{
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(options) {
      if (this._jqObj && options && Array.isArray(options)) {
        this.dataModel.options = options;

        if (this._jqObj) {
          this.reRender();
        }
      }
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.dataModel.alignment;
    },
    set: function set(value) {
      this.dataModel.alignment = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "sort",
    get: function get() {
      return this.dataModel.sort;
    },
    set: function set(value) {
      this.dataModel.sort = value;

      if (this._jqObj) {
        if (this.dataModel.sort == "positiveSequence") {
          this.dataModel.options.reverse();
        } else if (this.dataModel.sort == "invertedOrder") {
          this.dataModel.options.reverse();
        }

        this.reRender();
      }
    }
  }, {
    key: "timeTop",
    get: function get() {
      return this.dataModel.timeTop;
    },
    set: function set(value) {
      this.dataModel.timeTop = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "broadwise",
    get: function get() {
      return this.dataModel.broadwise;
    },
    set: function set(value) {
      this.dataModel.broadwise = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "timeLineWidth",
    get: function get() {
      return this.dataModel.timeLineWidth;
    },
    set: function set(value) {
      this.dataModel.timeLineWidth = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "loadDataListService",
    get: function get() {
      return this.dataModel.loadDataListService;
    },
    set: function set(value) {
      this.dataModel.loadDataListService = value;
    }
  }, {
    key: "dataListBindingMember",
    get: function get() {
      return this.dataModel.dataListBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataListBindingMember = value;
    }
  }, {
    key: "dataListTextFormat",
    get: function get() {
      return this.dataModel.dataListTextFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTextFormat = value;
    }
  }, {
    key: "dataListTimeFormat",
    get: function get() {
      return this.dataModel.dataListTimeFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTimeFormat = value;
    }
  }, {
    key: "dataListIconFormat",
    get: function get() {
      return this.dataModel.dataListIconFormat;
    },
    set: function set(value) {
      this.dataModel.dataListIconFormat = value;
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());

      if (!this._tfp.isDesigning) this.bindItemEvent();
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";

      if (this.dataModel.broadwise) {
        html += indent + "\t<div class=\"tfp-timeline-b\">\r\n";
      } else {
        html += indent + "\t<div class=\"tfp-timeline-v\">\r\n";
      }

      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];
        var bgColor = "";
        var width = "200";
        if (!option.time) option.time = '';
        if (!option.icon) option.icon = '';
        if (option.color) bgColor = "background-color: " + option.color + ";";
        if (this.dataModel.timeLineWidth) width = this.dataModel.timeLineWidth;
        var iconHtml = "<div class=\"tfp-timeline-icon\" style=\"" + bgColor + "\"></div>";
        if (option.icon) iconHtml = "<img src=\"" + option.icon + "\" style=\"width: 24px; height: 24px;\">";
        var topStyle = "";
        var bottomStyle = "";

        if (this.dataModel.alignment == 'center') {
          topStyle = "left: calc(50% - 12px);";
          bottomStyle = "text-align: center;";
        } else if (this.dataModel.alignment == 'left') {
          topStyle = "left: 0;";
          bottomStyle = "text-align: left;";
        }

        if (this.dataModel.broadwise) {
          html += indent + "\t<div class=\"tfp-timeline-item\" style=\"width:" + width + "px;\">\r\n";
          html += indent + "\t<div class=\"tfp-timeline-top\" style=\"" + topStyle + "\">\r\n";
          html += indent + "\t<div class=\"tfp-timeline-line\" style=\"right:calc(" + width + "px - 12px);\"\"></div>\r\n";
          html += indent + "\t<div class=\"tfp-timeline-img\">" + iconHtml + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t<div class=\"tfp-timeline-bottom\" style=\"" + bottomStyle + "\">\r\n";

          if (this.dataModel.timeTop) {
            html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";
            html += indent + "\t<div class=\"tfp-timeline-text\"";
            if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
            html += ">" + option.text + "</div>\r\n";
          } else {
            html += indent + "\t<div class=\"tfp-timeline-text\"";
            if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
            html += ">" + option.text + "</div>\r\n";
            html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";
          }

          html += indent + "\t</div>\r\n";
          html += indent + "\t</div>\r\n";
        } else {
          html += indent + "\t<div class=\"tfp-timeline-item-v\" style=\"height:" + width + "px;\">\r\n";
          html += indent + "\t<div class=\"tfp-timeline-left-v\">\r\n";
          html += indent + "\t<div class=\"tfp-timeline-line-v\" style=\"top:calc(-" + width + "px + 12px);\"></div>\r\n";
          html += indent + "\t<div class=\"tfp-timeline-img\">" + iconHtml + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t<div class=\"tfp-timeline-right-v\" style=\"" + bottomStyle + "\">\r\n";

          if (this.dataModel.timeTop) {
            html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";
            html += indent + "\t<div class=\"tfp-timeline-text\"";
            if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
            html += ">" + option.text + "</div>\r\n";
          } else {
            html += indent + "\t<div class=\"tfp-timeline-text\"";
            if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
            html += ">" + option.text + "</div>\r\n";
            html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";
          }

          html += indent + "\t</div>\r\n";
          html += indent + "\t</div>\r\n";
        }
      }

      html += indent + "\t</div>\r\n";
      return html + "\t";
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListTextFormat) {
        alert("请为[" + this.id + "]设置节点标题数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.text)) continue;

        if (this.dataModel.dataListTimeFormat) {
          try {
            var timeFormat = this.dataModel.dataListTimeFormat;
            if (timeFormat.indexOf("{") < 0 && timeFormat.indexOf("#[") < 0) timeFormat = "{" + timeFormat + "}";
            option.time = this._tfp.replaceDataField(row, timeFormat);
            if (option.time) option.time = this._tfp.exeExpress(option.time);
          } catch (e) {
            console.log(e);
            return;
          }
        }

        if (this.dataModel.dataListIconFormat) {
          try {
            var iconFormat = this.dataModel.dataListIconFormat;
            if (iconFormat.indexOf("{") < 0 && iconFormat.indexOf("#[") < 0) iconFormat = "{" + iconFormat + "}";
            option.icon = this._tfp.replaceDataField(row, iconFormat);
            if (option.icon) option.icon = this._tfp.exeExpress(option.icon);
          } catch (e) {
            console.log(e);
            return;
          }
        }

        options.push(option);
      }

      this.options = options;
    }
  }, {
    key: "bindItemEvent",
    value: function bindItemEvent() {
      var that = this;

      this._jqObj.find(".tfp-timeline-text").click(function () {
        var index = $(this).parent().parent().index();
        var option = that.options[index];
        var value = option.text;
        that.dataModel.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        try {
          if (option.onClick) eval(option.onClick);
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this.reRender();
    }
  }]);
  return TimeLine;
}(_controller.FormInput);

exports["default"] = TimeLine;