"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Time",
  "comment": "时间",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "组件值",
      "type": "String"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "placeHolder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch"
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch"
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }, {
    "name": "timeSetting",
    "comment": "时间设置",
    "type": "group",
    "items": [{
      "name": "showIcon",
      "comment": "显示图标",
      "type": "Switch",
      "default": true
    }, {
      "name": "showSecond",
      "comment": "显示秒",
      "type": "Switch"
    }, {
      "name": "defaultNow",
      "comment": "默认当前时间",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "height": "30px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onBlur",
    "comment": "失去焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;