"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 时间组件
 * @param {[type]} dataModel [description]
 */
var Time = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Time, _FormInput);

  var _super = _createSuper(Time);

  function Time(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Time);
    _this = _super.call(this, __tfp, "Time", dataModel, parent);
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "resetWidth", function () {
      var iptWidth = this.dataModel.showSecond ? 62 : 42;
      var cptMinWidth = iptWidth;
      if (this.showIcon) cptMinWidth += 30;
      var cptWidth = cptMinWidth;

      if (this._jqObj) {
        this._jqObj.css("width", cptWidth + "px");

        this._jqObj.css("min-width", cptMinWidth + "px");

        this._jqObj.find("input").css("width", iptWidth + "px");
      }

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptMinWidth + "px";
    });
    return _this;
  } //属性


  (0, _createClass2["default"])(Time, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/time/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        this.resetWidth();
      }
    }
  }, {
    key: "showSecond",
    get: function get() {
      return this.dataModel.showSecond;
    },
    set: function set(value) {
      this.dataModel.showSecond = value ? true : false;

      if (this._jqObj) {
        this.resetWidth();

        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        }
      }
    }
  }, {
    key: "defaultNow",
    get: function get() {
      return this.dataModel.defaultNow;
    },
    set: function set(value) {
      this.dataModel.defaultNow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        } else {
          this._jqObj.find("input").val("");
        }
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = "";
      this.closePicker();
    }
  }, {
    key: "getCurTime",
    value: function getCurTime() {
      return new Date().format(this.showSecond ? "HH:mm:ss" : "HH:mm");
    }
  }, {
    key: "render",
    value: function render() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Time.prototype), "render", this).call(this);
      if (!this.dataModel.styles || !this.dataModel.styles.width) this.resetWidth();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        var arrVal = [];
        if (that.dataModel.value) arrVal = that.dataModel.value.split(":");
        var optionsList = [];
        var curHour = new Date().getHours();
        curHour = curHour < 10 ? "0" + curHour : curHour + "";
        var hourOptions = {
          options: [],
          width: "80px",
          value: curHour
        };
        if (arrVal.length > 0) hourOptions.value = arrVal[0];

        for (var i = 0; i <= 23; i++) {
          var hour = i < 10 ? "0" + i : i + "";
          hourOptions.options.push(hour);
        }

        optionsList.push(hourOptions);
        var curMinute = new Date().getMinutes();
        curMinute = curMinute < 10 ? "0" + curMinute : curMinute + "";
        var minuteOptions = {
          options: [],
          width: "80px",
          value: curMinute
        };
        if (arrVal.length > 1) minuteOptions.value = arrVal[1];

        for (var i = 0; i <= 59; i++) {
          var day = i < 10 ? "0" + i : i + "";
          minuteOptions.options.push(day);
        }

        optionsList.push(minuteOptions);

        if (that.showSecond) {
          var curSecond = new Date().getSeconds();
          curSecond = curSecond < 10 ? "0" + curSecond : curSecond + "";
          var secondOptions = {
            options: [],
            width: "60px",
            value: curSecond
          };
          if (arrVal.length > 2) secondOptions.value = arrVal[2];

          for (var i = 0; i <= 59; i++) {
            var _day = i < 10 ? "0" + i : i + "";

            secondOptions.options.push(_day);
          }

          optionsList.push(secondOptions);
        }

        window.popupList.show(optionsList, function (vals) {
          var val = vals[0] + ":" + vals[1];
          if (that.showSecond) val += ":" + vals[2];
          that.value = val;
        });
      });
    }
  }]);
  return Time;
}(_controller.FormInput);

exports["default"] = Time;