"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 时间组件
 * @param {[type]} dataModel [description]
 */
var Time = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Time, _FormInput);

  var _super = _createSuper(Time);

  function Time(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Time);
    _this = _super.call(this, __tfp, "Time", dataModel, parent);
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "resetWidth", function () {
      //如果当前组件的宽度设置为了100%，则不要因为是否显示图标、是否显示秒等参数变化而改变宽度
      if (this.dataModel.styles && this.dataModel.styles["width"] == "100%") return;
      var iptWidth = this.dataModel.showSecond ? 68 : 48;
      var cptMinWidth = iptWidth;
      if (this.showIcon) cptMinWidth += 30;
      var cptWidth = cptMinWidth;

      if (this._jqObj) {
        if (this.dataModel.styles["width"] != "100%") this._jqObj.css("width", cptWidth + "px");

        this._jqObj.css("min-width", cptMinWidth + "px");

        this._jqObj.find("input").css("width", iptWidth + "px");
      }

      if (!this.dataModel.styles) this.dataModel.styles = {};
      if (this.dataModel.styles["width"] != "100%") this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptMinWidth + "px";
    });
    return _this;
  } //属性


  (0, _createClass2["default"])(Time, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.find("input").attr("placeholder", value);
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/time/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        this.resetWidth();
      }
    }
  }, {
    key: "showSecond",
    get: function get() {
      return this.dataModel.showSecond;
    },
    set: function set(value) {
      this.dataModel.showSecond = value ? true : false;

      if (this._jqObj) {
        this.resetWidth();

        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        }
      }
    }
  }, {
    key: "defaultNow",
    get: function get() {
      return this.dataModel.defaultNow;
    },
    set: function set(value) {
      this.dataModel.defaultNow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        } else {
          this._jqObj.find("input").val("");
        }
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = "";
      this.closePicker();
    }
  }, {
    key: "closePicker",
    value: function closePicker() {
      $(".tfp-time-picker").remove();
      $("body").unbind("click", this.closePicker);
    }
  }, {
    key: "showPicker",
    value: function showPicker() {
      var offset = this._jqObj.offset();

      var colorClass = 'tfp-time-picker-bgcolor';
      var html = "<div class=\"tfp-time-picker\" data-cptid=\"" + this.id + "\" " + "style=\"width: " + (this.showSecond ? 164 : 110) + "px; top: " + (offset.top + 31) + "px; left:" + offset.left + "px; display:none;\">";
      var vals = [];

      if (this.dataModel.value) {
        vals = this.dataModel.value.split(":");
      } else {
        vals = this.getCurTime().split(":");
      }

      html += "<ul data-value=\"" + vals[0] + "\">";

      for (var i = 0; i < 24; i++) {
        var hour = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (hour == vals[0]) html += " class=\"" + colorClass + "\" style=\"color: #FFFFFF;\"";
        html += ">" + hour + "</li>";
      }

      html += "</ul>";
      html += "<ul data-value=\"" + vals[1] + "\">";

      for (var i = 0; i < 60; i++) {
        var minute = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (minute == vals[1]) html += " class=\"" + colorClass + "\" style=\"color: #FFFFFF;\"";
        html += ">" + minute + "</li>";
      }

      html += "</ul>";

      if (this.showSecond) {
        html += "<ul data-value=\"" + vals[2] + "\">";

        for (var i = 0; i < 60; i++) {
          var second = i < 10 ? "0" + i : i + "";
          html += "<li";
          if (second == vals[2]) html += " class=\"" + colorClass + "\" style=\"color: #FFFFFF;\"";
          html += ">" + second + "</li>";
        }

        html += "</ul>";
      }

      html += "<div class=\"tfp-time-picker-footer\"><span>清空</span>" + "<input type=\"button\" value=\"确定\" /></div>";
      html += "</div>";
      $("body").append(html);
      var timePicker = $(".tfp-time-picker");
      timePicker.fadeIn("slow");
      timePicker.bind("click", function () {
        event.stopPropagation();
      });
      timePicker.find("ul").each(function () {
        $(this).find("li").each(function () {
          $(this).click(function () {
            $(this).parent().find("li").attr("class", "");
            $(this).parent().find("li").css("color", "");
            $(this).attr("class", "tfp-time-picker-bgcolor");
            $(this).css("color", "#FFFFFF");
            $(this).parent().attr("data-value", $(this).html());
          });
        });
        $(this).get(0).scrollTop = parseInt($(this).attr("data-value") * 25);
      });
      var that = this;
      var footer = timePicker.find(".tfp-time-picker-footer");
      footer.find("span").click(function () {
        that.clear();
      });
      footer.find("input").click(function () {
        that.onCheckTime();
      });
      $("body").bind("click", this.closePicker);
    }
  }, {
    key: "onCheckTime",
    value: function onCheckTime() {
      var timePicker = $(".tfp-time-picker");
      var val = timePicker.find("ul").eq(0).attr("data-value");
      val += ":" + timePicker.find("ul").eq(1).attr("data-value");
      if (this.showSecond) val += ":" + timePicker.find("ul").eq(2).attr("data-value");
      this.value = val;
      this.closePicker();
    }
  }, {
    key: "getCurTime",
    value: function getCurTime() {
      return new Date().format(this.showSecond ? "HH:mm:ss" : "HH:mm");
    }
  }, {
    key: "render",
    value: function render() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Time.prototype), "render", this).call(this);
      if (!this.dataModel.styles || !this.dataModel.styles.width) this.resetWidth();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (this.readonly) {
        this._jqObj.find("input").css("padding-left", "0px");
      }

      this._jqObj.click(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        if ($(".tfp-time-picker").length > 0) {
          var cptId = $(".tfp-time-picker").attr("data-cptid");
          if (cptId == that.dataModel.id) return;
          that.closePicker();
        }

        that.showPicker();
        event.stopPropagation();
      });

      if (this.dataModel.defaultNow && !this.dataModel.value) {
        this.dataModel.value = this.getCurTime();

        this._jqObj.find("input").val(this.dataModel.value);
      }

      this._jqObj.find("input").focus(function () {
        if (that.disabled) return;

        try {
          if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.find("input").blur(function () {
        if (that.disabled) return;

        try {
          if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }]);
  return Time;
}(_controller.FormInput);

exports["default"] = Time;