"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "TextArea",
  "comment": "多行文本",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "文本内容",
      "type": "String"
    }, {
      "name": "placeholder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "maxlength",
      "comment": "最大长度",
      "type": "Int",
      "isHtmlAttr": true
    }, {
      "name": "confirmType",
      "comment": "键盘右下角文字",
      "type": "Select",
      "isHtmlAttr": true,
      "attrName": "confirm-type",
      "options": [{
        "value": "send",
        "text": "发送"
      }, {
        "value": "search",
        "text": "搜索"
      }, {
        "value": "next",
        "text": "下一个"
      }, {
        "value": "go",
        "text": "前往"
      }, {
        "value": "done",
        "text": "完成"
      }]
    }, {
      "name": "autoHeight",
      "comment": "是否自动增高",
      "type": "Switch",
      "isHtmlAttr": true,
      "attrName": "auto-height"
    }, {
      "name": "adjustPosition",
      "comment": "键盘是否自动上推页面",
      "type": "Switch",
      "isHtmlAttr": true,
      "attrName": "adjust-position"
    }, {
      "name": "disabled",
      "comment": "是否禁用",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "showConfirmBbar",
      "comment": "键盘上方带有”完成“",
      "type": "Switch",
      "isHtmlAttr": true,
      "attrName": "show-confirm-bar"
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "height": "80px",
    "resize": "none"
  },
  "events": [{
    "name": "bindfocus",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "获取焦点时"
  }, {
    "name": "bindblur",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "失去焦点时"
  }]
};
exports["default"] = _default;