"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "TextArea",
  "comment": "多行文本",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "文本内容",
      "type": "String"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "placeHolder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "maxLength",
      "comment": "最大长度",
      "type": "Int",
      "isHtmlAttr": true
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "320px",
    "height": "80px",
    "resize": "none"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时"
  }, {
    "name": "onBlur",
    "comment": "失去焦点时"
  }, {
    "name": "onKeyDown",
    "comment": "按下按键时"
  }, {
    "name": "onKeyPress",
    "comment": "按下并松开按键时"
  }, {
    "name": "onKeyUp",
    "comment": "松开按键时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;