"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 多行文本组件
 * @param {[type]} dataModel [description]
 */
var TextArea = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(TextArea, _FormInput);

  var _super = _createSuper(TextArea);

  function TextArea(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, TextArea);
    return _super.call(this, __tfp, "TextArea", dataModel, parent);
  }

  (0, _createClass2["default"])(TextArea, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
    /*get cols() { return this.dataModel.cols }
    set cols(value) { 
      this.dataModel.cols = value;
      if(this._jqObj) this._jqObj.attr("cols", value);
    }
      get rows() { return this.dataModel.rows }
    set rows(value) { 
      this.dataModel.rows = value;
      if(this._jqObj) this._jqObj.attr("rows", value);
    }*/

  }, {
    key: "maxLength",
    get: function get() {
      return this.dataModel.maxLength;
    },
    set: function set(value) {
      this.dataModel.maxLength = value;
      if (this._jqObj) this._jqObj.attr("maxlength", value);
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.attr("placeholder", value);
    }
  }, {
    key: "format",
    get: function get() {
      return this.dataModel.format;
    },
    set: function set(value) {
      this.dataModel.format = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (that.dataModel.readonly) {
        this._jqObj.attr("readonly", "readonly");
      } else if (that.dataModel.disabled) {
        this._jqObj.attr("disabled", "disabled");

        return;
      }

      this._jqObj.change(function () {
        // 文本验证
        var verify = that.dataModel.verify;

        if (verify && (0, _typeof2["default"])(verify) == 'object' && verify.verify && verify.verifyMsg) {
          var el = this;
          var jqObj = $(this);
          var reg = new RegExp(verify.verify);
          var tooltipId = 'tfp-tooltip-' + that.dataModel.id; // 判断文本验证是否通过

          if (!reg.test(val.toString())) {
            // 找到上一个浮动元素
            var _parent = $(el.offsetParent);

            if (!el.dataset.inputerror) jqObj.attr('data-bordercolor', jqObj.css('border-color'));
            if (_parent.css('position') == 'static' || !_parent.css('position')) _parent.css('position', 'relative');
            if ($('#' + tooltipId).length > 0) $('#' + tooltipId).remove(); // 创建提示框元素

            var _tooltip = $('<div>', {
              'id': tooltipId
            }).css({
              'position': 'absolute',
              'display': 'none',
              'margin': '0px',
              'padding': '8px 11px',
              'border': '1px solid #f56c6c',
              'border-radius': '4px',
              'font-size': '12px',
              'line-height': '12px',
              'color': '#606266',
              'white-space': 'nowrap'
            }).html(verify.verifyMsg).append($('<div>').css({
              'position': 'absolute',
              'top': '23px',
              'right': '20px',
              'width': '12px',
              'height': '12px',
              'background': '#fff',
              'border': '1px solid #f56c6c',
              'border-top': '0px',
              'border-left': '0px',
              'transform': 'rotate(45deg)',
              'border-radius': '0px 0px 4px 0px'
            })); // 将元素先添加到body中用于计算宽度


            $('body').append(_tooltip.css('top', '-10000px').show()); // 计算出提示框元素应在的位置

            _tooltip.css({
              'top': el.offsetTop - 40 + 'px',
              'left': el.offsetLeft + el.offsetWidth - _tooltip[0].offsetWidth + 'px'
            }).hide(); // 将提示框渐显


            _parent.append(_tooltip.fadeIn(300, 'linear')); // 将文本控件添加红色边框


            jqObj.css('border-color', '#f56c6c').attr('data-inputerror', 'true'); // 设置提示框定时关闭

            setTimeout(function () {
              _tooltip.fadeOut(300, 'linear', function () {
                $(this).remove();
              });
            }, 2000);
          }
        }

        that.dataModel.value = that._jqObj.val();
        that.valueOnChange();
        that.exeEventHandler("onChange", that.dataModel.value);
      }); // 监听输入框的输入事件


      this._jqObj.keypress(function (e) {
        // 如果输入框之前输入错误时校验当前输入是否符合文本验证规则
        if (this.dataset.inputerror) {
          var verify = that.dataModel.verify;
          var reg = new RegExp(verify.verify); // 如果符合验证规则则删除错误标志和红色表框

          if (reg.test(this.value + e.key)) {
            $(this).css('border-color', this.dataset.bordercolor).removeAttr('data-inputerror').removeAttr('data-bordercolor');
          }
        }
      }); // 监听输入框的改变事件


      this._jqObj.change(function (e) {
        // 如果输入框之前输入错误时校验当前输入是否符合文本验证规则
        if (this.dataset.inputerror) {
          var verify = that.dataModel.verify;
          var reg = new RegExp(verify.verify); // 如果符合验证规则则删除错误标志和红色表框

          if (!this.value || reg.test(this.value)) {
            $(this).css('border-color', this.dataset.bordercolor).removeAttr('data-inputerror').removeAttr('data-bordercolor');
          }
        }
      });
    }
  }]);
  return TextArea;
}(_controller.FormInput);

exports["default"] = TextArea;