"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 单行文本组件
 * @param {[type]} dataModel [description]
 */
var Text = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Text, _FormInput);

  var _super = _createSuper(Text);

  function Text(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Text);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Text", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Text, [{
    key: "value",
    get: function get() {
      if (this._jqObj && this._jqObj.val() != "") {
        this.dataModel.value = this._jqObj.val();
      }

      if (this.dataModel.value || this.dataModel.value == 0) return this.dataModel.value;
      return "";
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = "";
        this.dataModel.value = null;
      } else {
        //如果设置了计算公式，则需要替换掉金额里的逗号
        if (this.dataModel.formula) {
          val = (val + "").trim().replaceAll(",", "");
          if (isNaN(val)) return;
        }

        try {
          if (this.dataModel.dataType == "number") {
            val = parseInt(val);
          } else if (this.dataModel.dataType == "digit") {
            val = parseFloat(val);
          }
        } catch (err) {
          console.error(err.message); //this._tfp.showMsg(err.message);

          return;
        }

        this.dataModel.value = val;
      }

      if (this._jqObj) {
        this._jqObj.val(val);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", val);
      }
    }
  }, {
    key: "maxlength",
    get: function get() {
      return this.dataModel.maxlength;
    },
    set: function set(value) {
      this.dataModel.maxlength = value;
    }
  }, {
    key: "placeholder",
    get: function get() {
      return this.dataModel.placeholder;
    },
    set: function set(value) {
      this._jqObj.attr('placeholder', value);

      this.dataModel.placeholder = value;
    }
  }, {
    key: "dataType",
    get: function get() {
      if (!this.dataModel.dataType) this.dataModel.dataType = "text";
      return this.dataModel.dataType;
    },
    set: function set(value) {
      this.dataModel.dataType = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.blur(function () {
        var val = $(this).val().trim();

        if (!isNull(val)) {
          if (that.dataModel.dataType && that.dataModel.dataType != "text") {
            if (isNaN(val)) {
              $(this).focus();
              return;
            }
          }

          try {
            if (that.dataModel.dataType == "number") {
              if (!isInt(val)) {
                $(this).focus();
                return;
              }

              val = parseInt(val);
            } else if (that.dataModel.dataType == "idcard") {
              val = parseFloat(val);
            }
          } catch (err) {
            console.error(err.message);
            $(this).focus();
            return;
          }
        }

        that.dataModel.value = val;
        that.valueOnChange();
        that.exeEventHandler("onChange", val);
      });
    }
  }]);
  return Text;
}(_controller.FormInput);

exports["default"] = Text;