"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 单行文本组件
 * @param {[type]} dataModel [description]
 */
var Text = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Text, _FormInput);

  var _super = _createSuper(Text);

  function Text(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Text);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Text", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Text, [{
    key: "value",
    get: function get() {
      if (this._jqObj) {
        this.dataModel.value = this.dataModel.icon ? this._jqObj.find("input").val() : this._jqObj.val();
      }

      if (this.dataModel.value || this.dataModel.value == 0) return this.dataModel.value;
      return "";
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = "";
        this.dataModel.value = null;
      } else {
        //如果设置了计算公式，则需要替换掉金额里的逗号
        if (this.dataModel.formula) {
          val = (val + "").trim().replaceAll(",", "");
          if (isNaN(val)) return;
        }

        this.dataModel.value = this.formatValue(val);
        val = this.dataModel.value;
        if (isNull(val)) val = "";
      }

      if (this._jqObj) {
        if (this.dataModel.icon) {
          this._jqObj.find("input").val(val);
        } else {
          this._jqObj.val(val);
        }
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", val);
      }
    }
  }, {
    key: "maxLength",
    get: function get() {
      return this.dataModel.maxLength;
    },
    set: function set(value) {
      this.dataModel.maxLength = value;

      if (this._jqObj) {
        if (this.dataModel.icon) {
          this._jqObj.find("input").attr("maxlength", value);
        } else {
          this._jqObj.attr("maxlength", value);
        }
      }
    }
  }, {
    key: "precise",
    get: function get() {
      return this.dataModel.precise;
    },
    set: function set(value) {
      this.dataModel.precise = value;
    }
  }, {
    key: "min",
    get: function get() {
      return this.dataModel.min;
    },
    set: function set(value) {
      this.dataModel.min = value;

      if (this._jqObj) {
        if (this.dataModel.icon) {
          this._jqObj.find("input").attr("min", value);
        } else {
          this._jqObj.attr("min", value);
        }
      }
    }
  }, {
    key: "max",
    get: function get() {
      return this.dataModel.max;
    },
    set: function set(value) {
      this.dataModel.max = value;

      if (this._jqObj) {
        if (this.dataModel.icon) {
          this._jqObj.find("input").attr("max", value);
        } else {
          this._jqObj.attr("max", value);
        }
      }
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;

      if (this._jqObj) {
        if (this.dataModel.icon) {
          this._jqObj.find("input").attr("placeholder", value);
        } else {
          this._jqObj.attr("placeholder", value);
        }
      }
    }
  }, {
    key: "icon",
    get: function get() {
      return this.dataModel.icon;
    },
    set: function set(value) {
      this.dataModel.icon = value;

      if (!isNull(value)) {
        var imgHtml = '';

        var imgUrl = this._tfp.getUrlRealPath(value);

        imgHtml = "<img src=\"" + imgUrl + "\">";

        if (this._jqObj) {
          this._jqObj.find("input").css("width", "calc(100% - 30px)");

          this._jqObj.find("img").remove();

          this._jqObj.append(imgHtml);
        }
      } else {
        if (this._jqObj.find("img").length > 0) {
          if (this._jqObj) {
            this._jqObj.find("input").css("width", "100%");

            this._jqObj.find("img").remove();
          }
        }
      }
    }
  }, {
    key: "dataType",
    get: function get() {
      if (!this.dataModel.dataType) this.dataModel.dataType = "text";
      return this.dataModel.dataType;
    },
    set: function set(value) {
      this.dataModel.dataType = value;
    }
  }, {
    key: "subDataType",
    get: function get() {
      if (!this.dataModel.subDataType) this.dataModel.subDataType = "";
      return this.dataModel.subDataType;
    },
    set: function set(value) {
      this.dataModel.subDataType = value;
    }
  }, {
    key: "formatValue",
    value: function formatValue(value) {
      var dataType = this.dataModel.dataType;
      var isNumber = ['int', 'float', 'money'].includes(dataType);
      if (isNull(value)) return null;
      if (isNumber && isNaN(value)) return null;
      var val = value;

      if (isNumber) {
        var min = parseFloat(this.dataModel.min);
        var max = parseFloat(this.dataModel.max);

        if (!isNaN(min) && val < parseFloat(min)) {
          val = parseFloat(min);
        }

        if (!isNaN(max) && val > parseFloat(max)) {
          val = parseFloat(max);
        }

        var precise = parseInt(this.dataModel.precise);

        if (dataType == 'int') {
          val = parseInt(parseFloat(val).toFixed(0));
        } else if (dataType == 'float') {
          val = parseFloat(val);

          if (!isNaN(precise) && precise >= 0) {
            val = parseFloat(val.toFixed(precise));
          }
        } else if (dataType == 'money') {
          if (!isNaN(precise) && precise >= 0) {
            val = this._tfp.formatMoney(val, precise);
          } else {
            val = this._tfp.formatMoney(val, 2);
          }
        }
      }

      return val;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      var inputEl = that.dataModel.icon ? that._jqObj.find("input") : that._jqObj;
      var dataType = that.dataModel.dataType;
      var isNumber = ['int', 'float', 'money'].includes(dataType);

      if (isNumber) {
        inputEl.attr('type', 'number');
        if (that.dataModel.min) inputEl.attr('min', that.dataModel.min);
        if (that.dataModel.max) inputEl.attr('max', that.dataModel.max);
      }

      if (that.dataModel.readonly) {
        inputEl.attr("readonly", "readonly");
      } else if (that.dataModel.disabled) {
        inputEl.find("input").attr("disabled", "disabled");
      }

      inputEl.click(function () {
        if (that.dataModel.disabled) return;

        try {
          if (that.dataModel.onClick) eval(that.dataModel.onClick);
        } catch (err) {
          console.log(err.message);
        }
      });
      inputEl.dblclick(function () {
        if (that.dataModel.disabled) return;

        try {
          if (that.dataModel.onDblClick) eval(that.dataModel.onDblClick);
        } catch (err) {
          console.log(err.message);
        }
      });
      inputEl.focus(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        try {
          if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
        } catch (err) {
          console.log(err.message);
        }
      });
      inputEl.blur(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;
        var val = $(this).val().trim();
        if (isNull(val)) return next();
        if (isNumber) try {
          if (isNaN(val)) {
            that._tfp.showBubble(that, "\u8F93\u5165\u6709\u8BEF", {
              changeBorder: false
            });

            return next();
          }

          var min = parseFloat(that.dataModel.min);
          var max = parseFloat(that.dataModel.max);

          if (!isNaN(min) && parseFloat(val) < min) {
            val = min;

            that._tfp.showBubble(that, "\u8F93\u5165\u6700\u5C0F\u4E3A".concat(min), {
              changeBorder: false
            });

            return next();
          }

          if (!isNaN(max) && parseFloat(val) > max) {
            val = max;

            that._tfp.showBubble(that, "\u8F93\u5165\u6700\u5927\u4E3A".concat(max), {
              changeBorder: false
            });

            return next();
          }

          val = that.formatValue(val);
        } catch (err) {
          console.error(err.message); // $(this).focus();

          that._tfp.showBubble(that, "\u8F93\u5165\u6709\u8BEF", {
            changeBorder: false
          });

          return next();
        }
        return next();

        function next() {
          that.value = val;

          try {
            if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
          } catch (err) {
            console.log(err.message);
          }
        }
      });
      inputEl.keydown(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        try {
          if (that.dataModel.onKeyDown) eval(that.dataModel.onKeyDown);
        } catch (err) {
          console.log(err.message);
        }
      });
      inputEl.keyup(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        try {
          if (that.dataModel.onKeyUp) eval(that.dataModel.onKeyUp);
        } catch (err) {
          console.log(err.message);
        }
      });
      inputEl.keypress(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        try {
          if (that.dataModel.onKeyPress) eval(that.dataModel.onKeyPress);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }]);
  return Text;
}(_controller.FormInput);

exports["default"] = Text;