"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var TableRender = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(TableRender, _TFPComponentRender);

  var _super = _createSuper(TableRender);

  function TableRender(__tfp, _dataModel, _level) {
    (0, _classCallCheck2["default"])(this, TableRender);
    return _super.call(this, __tfp, _dataModel, _level);
  }

  (0, _createClass2["default"])(TableRender, [{
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var _this = this;

      var bodyHtml = "\r\n";
      var indent = this.getHtmlIndent();

      var _loop = function _loop(i) {
        var row = _this.dataModel.rows[i];
        bodyHtml += indent + "<tr height=\"" + row.height + "\">\r\n";

        var _loop2 = function _loop2(j) {
          var cell = row.cells[j];
          bodyHtml += indent + "\t<td";
          if (cell.rows > 1) bodyHtml += " rowspan=\"" + cell.rows + "\"";
          if (cell.cols > 1) bodyHtml += " colspan=\"" + cell.cols + "\"";
          if (cell.align) bodyHtml += " align=\"" + cell.align + "\"";
          if (cell.valign) bodyHtml += " align=\"" + cell.valign + "\"";
          var width = _this.dataModel.columns[j].width + "";
          if (width.indexOf("%") < 0) width += "px";
          bodyHtml += " style=\"width:" + width + ";";

          if (_this.dataModel.borderWidth && _this.dataModel.borderWidth + '' != '0') {
            var borderStyle = _this.dataModel.borderWidth + "px solid " + (_this.dataModel.borderColor ? _this.dataModel.borderColor : "#000000");

            if (cell.borderBottomWidth) {
              bodyHtml += "border-bottom:" + cell.borderBottomWidth + "px " + cell.borderBottomStyle + " #000000;";
            } else {
              bodyHtml += "border-bottom:" + borderStyle + ";";
            }

            if (cell.borderRightWidth) {
              bodyHtml += "border-right:" + cell.borderRightWidth + "px " + cell.borderRightStyle + " #000000;";
            } else {
              bodyHtml += "border-right:" + borderStyle + ";";
            }

            if (cell.borderTopWidth) {
              bodyHtml += "border-top:" + cell.borderTopWidth + "px " + cell.borderTopStyle + " #000000;";
            } else if (i == 0) {
              bodyHtml += "border-top:" + borderStyle + "; ";
            }

            if (cell.borderLeftWidth) {
              bodyHtml += "border-left:" + cell.borderLeftWidth + "px " + cell.borderLeftStyle + " #000000;";
            } else if (j == 0) {
              bodyHtml += "border-left:" + borderStyle + "; ";
            }
          } else {
            if (cell.borderTopWidth && cell.borderTopWidth + '' != '0') {
              bodyHtml += "border-top:" + cell.borderTopWidth + "px " + cell.borderTopStyle + " #000000;";
            } else if (_this._tfp.isDesigning && i == 0) {
              bodyHtml += "border-top:1px dashed #CCCCCC;";
            }

            if (cell.borderBottomWidth && cell.borderBottomWidth + '' != '0') {
              bodyHtml += "border-bottom:" + cell.borderBottomWidth + "px " + cell.borderBottomStyle + " #000000;";
            } else if (_this._tfp.isDesigning) {
              bodyHtml += "border-bottom:1px dashed #CCCCCC;";
            }

            if (cell.borderLeftWidth && cell.borderLeftWidth + '' != '0') {
              bodyHtml += "border-left:" + cell.borderLeftWidth + "px " + cell.borderLeftStyle + " #000000;";
            } else if (_this._tfp.isDesigning && j == 0) {
              bodyHtml += "border-left:1px dashed #CCCCCC;";
            }

            if (cell.borderRightWidth && cell.borderRightWidth + '' != '0') {
              bodyHtml += "border-right:" + cell.borderRightWidth + "px " + cell.borderRightStyle + " #000000;";
            } else if (_this._tfp.isDesigning) {
              bodyHtml += "border-right:1px dashed #CCCCCC;";
            }
          }

          if (_this.dataModel.cellPadding) bodyHtml += "padding:" + _this.dataModel.cellPadding + "px;";
          if (cell.hidden) bodyHtml += "display:none;";
          if (cell.bgColor) bodyHtml += "background-color:" + cell.bgColor + ";";
          bodyHtml += "\">";

          if (cell.components && cell.components.length > 0) {
            cell.components.forEach(function (cptId) {
              _this.dataModel.components.forEach(function (cdmChild) {
                if (cdmChild.id == cptId) {
                  if (_this._tfp.isDesigning || !_this._tfp.get(cdmChild.id) //|| (this._tfp.curPage.pageType=="print-report")
                  ) {
                    cdmChild.tableCellRowIndex = i;
                    cdmChild.tableCellColIndex = j;
                  } else {
                    var Render = _this._tfp.renders[cdmChild.type];
                    if (!Render) return;
                    var render = new Render(_this._tfp, cdmChild, _this.level + 1);
                    bodyHtml += render.getHtml(getComponentsHtml, indent, true);
                  }
                }
              });
            });
          }

          bodyHtml += "</td>\r\n";
        };

        for (var j = 0; j < row.cells.length; j++) {
          _loop2(j);
        }

        bodyHtml += indent + "</tr>\r\n";
      };

      for (var i = 0; i < this.dataModel.rows.length; i++) {
        _loop(i);
      }

      return bodyHtml + indent;
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(TableRender.prototype), "getHtml", this).call(this, "table", getComponentsHtml, parentIndent, retainStyleAttr);
    }
  }]);
  return TableRender;
}(_render["default"]);

exports["default"] = TableRender;