"use strict";

function TableDesigner() {
  this.selectedTableTds = null;
  this.pageDesigner = null;

  this.showTableRowSetting = function () {
    event.stopPropagation();
    $("#divTableColSetting").hide();
    var offset = $("#divTableToolBar").find(".row-setting").offset();
    $("#divTableRowSetting").css("top", offset.top + 28 + "px");
    $("#divTableRowSetting").css("left", offset.left + "px");
    $("#divTableRowSetting").css("display", "flex");
  };

  this.showTableColSetting = function () {
    event.stopPropagation();
    $("#divTableRowSetting").hide();
    var offset = $("#divTableToolBar").find(".col-setting").offset();
    $("#divTableColSetting").css("top", offset.top + 28 + "px");
    $("#divTableColSetting").css("left", offset.left + "px");
    $("#divTableColSetting").css("display", "flex");
  };

  this.talebMoveIconOnClick = function () {
    event.stopPropagation();
  };

  this.talebMoveIconOnMouseDown = function () {
    if (!uiDesigner.curSelectedCptId) return;
    event.stopPropagation();
    $("#divTableRowSetting").hide();
    $("#divTableColSetting").hide();
    var offset = $("#" + uiDesigner.curSelectedCptId).offset();
    this.pageDesigner.mouseInfo.offset = [{
      top: offset.top,
      left: offset.left
    }]; //获得鼠标按下的坐标

    this.pageDesigner.mouseInfo.downX = event.clientX;
    this.pageDesigner.mouseInfo.downY = event.clientY; //如果没有设置拖拽类型，则默认为移动组件

    this.pageDesigner.mouseInfo.dragType = "MoveComponent";
    this.pageDesigner.mouseInfo.cptId = uiDesigner.curSelectedCptId; //先不要设置为正在拖拽，只有当鼠标上下移动的位置超过一定范围后才能算是移动，否则点击选中组件也会造成组件移动

    this.pageDesigner.mouseInfo.isDrag = false;
    this.pageDesigner.mouseInfo.haveAddOperation = false; //是否已经添加操作记录
  };

  this.unSelectTable = function () {
    if (!this.selectedTableTds) return;
    $("#divTableToolBar").hide();
    $("#divTableRowSetting").hide();
    $("#divTableColSetting").hide();
    $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").children("td").css("background", "");
    this.selectedTableTds = null;
  };

  this.tableTdOnMouseDown = function (tableId, td) {
    event.stopPropagation();
    $("#divTableRowSetting").hide();
    $("#divTableColSetting").hide();
    $("#" + tableId).children("tbody").children("tr").children("td").css("background", "");
    $(td).css("background", "#C9EFFB");
    this.selectedTableTds = {
      tableId: tableId,
      srcRowIndex: $(td).parent().index(),
      srcColIndex: $(td).index(),
      srcRowSpan: 1,
      srcColSpan: 1,
      curRowIndex: $(td).parent().index(),
      curColIndex: $(td).index(),
      isDrag: false
    };
    var rowSpan = $(td).attr("rowspan");
    if (rowSpan && parseInt(rowSpan) > 1) this.selectedTableTds.srcRowSpan = parseInt(rowSpan);
    var colSpan = $(td).attr("colspan");
    if (colSpan && parseInt(colSpan) > 1) this.selectedTableTds.srcColSpan = parseInt(colSpan);
    if (rowSpan && parseInt(rowSpan) > 1 || colSpan && parseInt(colSpan) > 1) return;
    this.selectedTableTds.isDrag = true;
  };

  this.tableTdOnMouseMove = function (tableId, td) {
    if (!this.selectedTableTds || !this.selectedTableTds.isDrag) return;
    var curRowIndex = $(td).parent().index();
    var curColIndex = $(td).index();
    if (this.selectedTableTds.curRowIndex == curRowIndex && this.selectedTableTds.curColIndex == curColIndex) return;
    var startRowIndex = this.selectedTableTds.srcRowIndex;
    if (curRowIndex < this.selectedTableTds.srcRowIndex) startRowIndex = curRowIndex;
    var endRowIndex = curRowIndex;
    if (curRowIndex < this.selectedTableTds.srcRowIndex) endRowIndex = this.selectedTableTds.srcRowIndex;
    var startColIndex = this.selectedTableTds.srcColIndex;
    if (curColIndex < this.selectedTableTds.srcColIndex) startColIndex = curColIndex;
    var endColIndex = curColIndex;
    if (curColIndex < this.selectedTableTds.srcColIndex) endColIndex = this.selectedTableTds.srcColIndex;
    $("#" + tableId).children("tbody").children("tr").children("td").css("background", "");

    for (var i = startRowIndex; i <= endRowIndex; i++) {
      var tr = $("#" + tableId).children("tbody").children("tr").eq(i);

      for (var j = startColIndex; j <= endColIndex; j++) {
        var tdTmp = tr.children("td").eq(j);
        var rowSpan = $(tdTmp).attr("rowspan");

        if (rowSpan && parseInt(rowSpan) > 1) {
          this.selectedTableTds.isDrag = false;
          return;
        }

        var colSpan = $(tdTmp).attr("colspan");

        if (colSpan && parseInt(colSpan) > 1) {
          this.selectedTableTds.isDrag = false;
          return;
        }

        $(tdTmp).css("background", "#C9EFFB");
      }
    }

    this.selectedTableTds.curRowIndex = curRowIndex;
    this.selectedTableTds.curColIndex = curColIndex;
  };

  this.tableTdOnMouseUp = function () {
    if (!this.pageDesigner.mouseInfo || !this.pageDesigner.mouseInfo.dragType) event.stopPropagation();
    if (!this.selectedTableTds) return;
    this.selectedTableTds.isDrag = false; //console.log(this.selectedTableTds);

    $("#divTableToolBar").find("div:not(.table-move)").hide();
    $("#divTableToolBar").find(".cell-setting").show(); //如果只选中了一个单元格

    if (this.selectedTableTds.srcRowIndex == this.selectedTableTds.curRowIndex && this.selectedTableTds.srcColIndex == this.selectedTableTds.curColIndex) {
      $("#divTableToolBar").find(".cell-setting-split").show(); //如果单元格没有合并

      if (this.selectedTableTds.srcRowSpan == 1) {
        $("#divTableToolBar").find(".row-setting-split, .row-setting").show();
      }

      if (this.selectedTableTds.srcColSpan == 1) {
        $("#divTableToolBar").find(".col-setting-split, .col-setting").show();
      }

      if (this.selectedTableTds.srcRowSpan > 1 || this.selectedTableTds.srcColSpan > 1) {
        $("#divTableToolBar").find(".cell-split").show();
      }
    } else {
      $("#divTableToolBar").find(".cell-merge").show();
    }

    if (tfp.curPage.positionType != "absolute") {
      $("#divTableToolBar").find(".table-move").hide();
      $("#divTableToolBar").find(".cell-setting-split").hide();
    }
  };

  this.mergeTableCells = function () {
    event.stopPropagation();
    if (!this.selectedTableTds) return;
    if (this.selectedTableTds.curRowIndex == this.selectedTableTds.srcRowIndex && this.selectedTableTds.curColIndex == this.selectedTableTds.srcColIndex) return;
    var firstTd = null;
    var startRowIndex = this.selectedTableTds.srcRowIndex;
    if (this.selectedTableTds.curRowIndex < this.selectedTableTds.srcRowIndex) startRowIndex = this.selectedTableTds.curRowIndex;
    var endRowIndex = this.selectedTableTds.curRowIndex;
    if (this.selectedTableTds.curRowIndex < this.selectedTableTds.srcRowIndex) endRowIndex = this.selectedTableTds.srcRowIndex;
    var startColIndex = this.selectedTableTds.srcColIndex;
    if (this.selectedTableTds.curColIndex < this.selectedTableTds.srcColIndex) startColIndex = this.selectedTableTds.curColIndex;
    var endColIndex = this.selectedTableTds.curColIndex;
    if (this.selectedTableTds.curColIndex < this.selectedTableTds.srcColIndex) endColIndex = this.selectedTableTds.srcColIndex;
    var tableCpt = tfp.get(uiDesigner.curSelectedCptId);

    for (var i = startRowIndex; i <= endRowIndex; i++) {
      var tr = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(i);

      for (var j = startColIndex; j <= endColIndex; j++) {
        var tdTmp = tr.children("td").eq(j);
        var cell = tableCpt.dataModel.rows[i].cells[j];

        if (i == startRowIndex && j == startColIndex) {
          firstTd = tdTmp;
          cell.rows = endRowIndex - startRowIndex + 1;
          cell.cols = endColIndex - startColIndex + 1;
        } else {
          $(tdTmp).hide();
          $(tdTmp).css("background-color", "");
          $(tdTmp).empty();
          cell.hidden = true;
          cell.rows = 1;
          cell.cols = 1;
          delete cell["bgColor"];
          delete cell["align"];
          delete cell["valign"];
          cell.components = [];
        }

        $(tdTmp).css("background", "#C9EFFB");
      }
    }

    this.selectedTableTds.srcRowSpan = endRowIndex - startRowIndex + 1;
    this.selectedTableTds.srcColSpan = endColIndex - startColIndex + 1;
    if (endRowIndex > startRowIndex) $(firstTd).attr("rowspan", this.selectedTableTds.srcRowSpan);
    if (endColIndex > startColIndex) $(firstTd).attr("colspan", this.selectedTableTds.srcColSpan);
    this.selectedTableTds.curRowIndex = startRowIndex;
    this.selectedTableTds.curColIndex = startColIndex;
    this.selectedTableTds.srcRowIndex = startRowIndex;
    this.selectedTableTds.srcColIndex = startColIndex;
    this.tableTdOnMouseUp(); //console.log(this.selectedTableTds);
  };

  this.splitTableCells = function () {
    event.stopPropagation();
    if (!this.selectedTableTds) return;
    if (this.selectedTableTds.srcRowIndex != this.selectedTableTds.curRowIndex || this.selectedTableTds.srcColIndex != this.selectedTableTds.curColIndex) return;
    if (this.selectedTableTds.srcRowSpan == 1 && this.selectedTableTds.srcColSpan == 1) return;
    var tableCpt = tfp.get(uiDesigner.curSelectedCptId);

    for (var i = this.selectedTableTds.srcRowIndex; i < this.selectedTableTds.srcRowIndex + this.selectedTableTds.srcRowSpan; i++) {
      var tr = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(i);

      for (var j = this.selectedTableTds.srcColIndex; j < this.selectedTableTds.srcColIndex + this.selectedTableTds.srcColSpan; j++) {
        var tdTmp = tr.children("td").eq(j);
        var cell = tableCpt.dataModel.rows[i].cells[j];
        cell.rows = 1;
        cell.cols = 1;
        delete cell["hidden"];
        $(tdTmp).attr("rowspan", "");
        $(tdTmp).attr("colspan", "");
        $(tdTmp).show();
      }
    }

    this.selectedTableTds.curRowIndex = this.selectedTableTds.srcRowIndex + this.selectedTableTds.srcRowSpan - 1;
    this.selectedTableTds.curColIndex = this.selectedTableTds.srcColIndex + this.selectedTableTds.srcColSpan - 1;
    this.selectedTableTds.srcRowSpan = 1;
    this.selectedTableTds.srcColSpan = 1;
    this.tableTdOnMouseUp(); //console.log(this.selectedTableTds);
  };

  this.resetCptRowIndex = function (tableCpt, startIndex, isAdd) {
    for (var i = startIndex; i < tableCpt.dataModel.rows.length; i++) {
      var row = tableCpt.dataModel.rows[i];

      for (var j = 0; j < row.cells.length; j++) {
        var cell = row.cells[j];

        if (cell.components) {
          cell.components.forEach(function (cptId) {
            var cpt = tfp.get(cptId);

            if (cpt) {
              if (isAdd) {
                cpt.dataModel.tableCellRowIndex++;
              } else {
                cpt.dataModel.tableCellRowIndex--;
              }
            }
          });
        }
      }
    }
  };

  this.insertRow = function (position) {
    var _this = this;

    event.stopPropagation();
    $("#divTableRowSetting").hide();
    if (!this.selectedTableTds || this.selectedTableTds.srcRowSpan != 1) return;
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var curRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex);
    var curRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex];
    var rowHtml = "<tr height=\"" + curRow.height + "\">\r\n";
    var newRow = {
      height: curRow.height,
      cells: []
    };
    var borderStyle = "";

    if (tableCpt.dataModel.borderWidth) {
      borderStyle = tableCpt.dataModel.borderWidth + "px solid " + (tableCpt.dataModel.borderColor ? tableCpt.dataModel.borderColor : "#000000");
    }

    var spanCells = {};
    tableCpt.dataModel.columns.forEach(function (col, index) {
      var cellOld = curRow.cells[index];
      var cellNew = {
        "cols": cellOld.cols,
        "rows": 1,
        "components": []
      };

      if (cellOld.hidden) {
        cellNew.hidden = true; //先在当前行查找当前合并的起始单元格

        var tmpCellIndex = index; //是否是在当前行内合并的单元格

        var isCurRowSpanCell = false;

        while (tmpCellIndex > 0) {
          tmpCellIndex--;
          var cellTmp = curRow.cells[tmpCellIndex]; //如果遇到非隐藏单元格

          if (!cellTmp.hidden) {
            //如果该单元格的行进行了合并，则判断是否是包含当前单元格
            if (cellTmp.cols > 1 && cellTmp.cols > index - tmpCellIndex) {
              isCurRowSpanCell = true;
            }

            break;
          }
        } //如果不是在当前行内合并的单元格


        if (!isCurRowSpanCell) {
          var spanStartRowIndex = -1;
          var spanStartColIndex = -1;
          var tmpRowIndex = _this.selectedTableTds.srcRowIndex;

          while (tmpRowIndex > 0) {
            tmpRowIndex--;
            var rowTmp = tableCpt.dataModel.rows[tmpRowIndex];
            var _cellTmp = rowTmp.cells[index];

            if (!_cellTmp.hidden) {
              if (_cellTmp.rows > 1 && _cellTmp.rows > _this.selectedTableTds.srcRowIndex - tmpRowIndex) {
                spanStartRowIndex = tmpRowIndex;
                spanStartColIndex = index; //不能直接在这里改这个单元格的合并行数，因为当前行可能有多个单元格是被向上合并的
              }

              tmpRowIndex++;
              break;
            }
          }

          if (spanStartRowIndex >= 0 && !spanCells[spanStartRowIndex + "-" + spanStartColIndex]) {
            var cellSpan = tableCpt.dataModel.rows[spanStartRowIndex].cells[spanStartColIndex];
            cellSpan.rows++;
            var spanRowEl = $("#" + _this.selectedTableTds.tableId).children("tbody").children("tr").eq(spanStartRowIndex);
            var spanCell = spanRowEl.children("td").eq(spanStartColIndex);
            spanCell.attr("rowspan", cellSpan.rows);
            spanCells[spanStartRowIndex + "-" + spanStartColIndex] = true;
          }
        }
      } else if (cellOld.rows > 1) {
        //如果该单元格向下合并
        if (position == "after") {
          cellOld.rows++;
          curRowEl.children("td").eq(index).attr("rowspan", cellOld.rows);
          cellNew.hidden = true;
        } else {
          cellNew.rows = 1;
          cellNew.cols = 1;
        }
      }

      if (cellOld.bgColor) cellNew.bgColor = cellOld.bgColor;
      if (cellOld.align) cellNew.align = cellOld.align;
      if (cellOld.valign) cellNew.valign = cellOld.valign;
      newRow.cells.push(cellNew);
      rowHtml += "<td";
      if (cellNew.rows > 1) rowHtml += " rowspan=\"" + cellNew.rows + "\"";
      if (cellNew.cols > 1) rowHtml += " colspan=\"" + cellNew.cols + "\"";
      if (cellNew.align) rowHtml += " align=\"" + cellNew.align + "\"";
      if (cellNew.valign) rowHtml += " align=\"" + cellNew.valign + "\"";
      rowHtml += " style=\"width:" + col.width + "px;";
      if (cellNew.bgColor) rowHtml += "background-color:" + cellNew.bgColor + ";";
      if (cellNew.hidden) rowHtml += "display:none;";
      if (tableCpt.dataModel.cellPadding) rowHtml += "padding:" + tableCpt.dataModel.cellPadding + "px;";

      if (tableCpt.dataModel.borderWidth) {
        rowHtml += "border-bottom:" + borderStyle + "; border-right:" + borderStyle + ";";
      }

      rowHtml += "\"></td>\r\n";
    });
    rowHtml += "</tr>\r\n";
    var newRowEl = null;

    if (position == "before") {
      $(rowHtml).insertBefore(curRowEl);
      newRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex);
      tableCpt.dataModel.rows.splice(this.selectedTableTds.srcRowIndex, 0, newRow);

      if (this.selectedTableTds.srcRowIndex == 0 && tableCpt.dataModel.borderWidth) {
        newRowEl.children("td").css("border-top", borderStyle);
        var oldRowEl = newRowEl.next();
        oldRowEl.children("td").css("border-top", "");
      }

      this.selectedTableTds.srcRowIndex++;
      this.selectedTableTds.curRowIndex++;
      this.resetCptRowIndex(tableCpt, this.selectedTableTds.srcRowIndex, true);
    } else {
      $(rowHtml).insertAfter(curRowEl);
      newRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex + 1);
      tableCpt.dataModel.rows.splice(this.selectedTableTds.srcRowIndex + 1, 0, newRow);
      this.resetCptRowIndex(tableCpt, this.selectedTableTds.srcRowIndex + 1, true);
    }

    newRowEl.children("td").eq(0).css("border-left", borderStyle);
    var that = this;
    newRowEl.children("td").each(function () {
      that.bindTableTdEvent(that.selectedTableTds.tableId, this);
    });
  };

  this.delRow = function () {
    var _this2 = this;

    event.stopPropagation();
    $("#divTableRowSetting").hide();
    if (!this.selectedTableTds || this.selectedTableTds.srcRowSpan != 1) return;
    $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex).remove();
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var curRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex];
    curRow.cells.forEach(function (cell, index) {
      //如果是隐藏的单元格，则需要充值合并单元格的行数
      if (cell.hidden) {
        //先在当前行查找当前合并的起始单元格
        var tmpCellIndex = index; //是否是在当前行内合并的单元格

        var isCurRowSpanCell = false;

        while (tmpCellIndex > 0) {
          tmpCellIndex--;
          var cellTmp = curRow.cells[tmpCellIndex]; //如果遇到非隐藏单元格

          if (!cellTmp.hidden) {
            //如果该单元格的行进行了合并，则判断是否是包含当前单元格
            if (cellTmp.cols > 1 && cellTmp.cols > index - tmpCellIndex) {
              isCurRowSpanCell = true;
            }

            break;
          }
        } //如果不是在当前行内合并的单元格


        if (!isCurRowSpanCell) {
          var spanStartRowIndex = -1;
          var spanStartColIndex = -1;
          var tmpRowIndex = _this2.selectedTableTds.srcRowIndex;

          while (tmpRowIndex > 0) {
            tmpRowIndex--;
            var rowTmp = tableCpt.dataModel.rows[tmpRowIndex];
            var _cellTmp2 = rowTmp.cells[index];

            if (!_cellTmp2.hidden) {
              if (_cellTmp2.rows > 1 && _cellTmp2.rows > _this2.selectedTableTds.srcRowIndex - tmpRowIndex) {
                spanStartRowIndex = tmpRowIndex;
                spanStartColIndex = index; //不能直接在这里改这个单元格的合并行数，因为当前行可能有多个单元格是被向上合并的
              }

              tmpRowIndex++;
              break;
            }
          }

          var spanCells = {};

          if (spanStartRowIndex >= 0 && !spanCells[spanStartRowIndex + "-" + spanStartColIndex]) {
            var cellSpan = tableCpt.dataModel.rows[spanStartRowIndex].cells[spanStartColIndex];
            cellSpan.rows--;
            var spanRowEl = $("#" + _this2.selectedTableTds.tableId).children("tbody").children("tr").eq(spanStartRowIndex);
            var spanCell = spanRowEl.children("td").eq(spanStartColIndex);
            spanCell.attr("rowspan", cellSpan.rows);
            spanCells[spanStartRowIndex + "-" + spanStartColIndex] = true;
          }
        }
      } else if (cell.rows > 1) {
        var nextRow = tableCpt.dataModel.rows[_this2.selectedTableTds.srcRowIndex + 1];
        var nextCell = nextRow.cells[index];
        nextCell.rows = cell.rows - 1;
        nextCell.cols = cell.cols;
        delete nextCell["hidden"];
        var nextRowEl = $("#" + _this2.selectedTableTds.tableId).children("tbody").children("tr").eq(_this2.selectedTableTds.srcRowIndex);
        var nextCellEl = nextRowEl.children("td").eq(index);
        nextCellEl.attr("rowspan", nextCell.rows > 1 ? nextCell.rows : "");
        nextCellEl.attr("colspan", nextCell.cols > 1 ? nextCell.cols : "");
        nextCellEl.show();
      }
    });
    tableCpt.dataModel.rows.splice(this.selectedTableTds.srcRowIndex, 1);
    $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").children("td").css("background", "");
    $("#divTableToolBar").find("div:not(.table-move)").hide();
    this.resetCptRowIndex(tableCpt, this.selectedTableTds.srcRowIndex, false);
    this.selectedTableTds = null;
  };

  this.setTableRowHeight = function () {
    event.stopPropagation();
    $("#divTableRowSetting").hide();
    if (!this.selectedTableTds || this.selectedTableTds.srcRowSpan != 1) return;
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var curRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex];
    var args = {
      height: curRow.height
    };
    var that = this;
    tfp.openDialog("设置行高", "tfp/src/components/table/SetTableRowHeight.tfp", "200px", "130px", JSON.stringify(args), function (height) {
      curRow.height = height;
      $("#" + that.selectedTableTds.tableId).children("tbody").children("tr").eq(that.selectedTableTds.srcRowIndex).attr("height", height);
    });
  };

  this.resetCptColIndex = function (tableCpt, startIndex, isAdd) {
    for (var i = 0; i < tableCpt.dataModel.rows.length; i++) {
      var row = tableCpt.dataModel.rows[i];

      for (var j = startIndex; j < row.cells.length; j++) {
        var cell = row.cells[j];

        if (cell.components) {
          cell.components.forEach(function (cptId) {
            var cpt = tfp.get(cptId);

            if (cpt) {
              if (isAdd) {
                cpt.dataModel.tableCellColIndex++;
              } else {
                cpt.dataModel.tableCellColIndex--;
              }
            }
          });
        }
      }
    }
  };

  this.insertCol = function (position) {
    var _this3 = this;

    event.stopPropagation();
    $("#divTableColSetting").hide();
    if (!this.selectedTableTds || this.selectedTableTds.srcColSpan != 1) return;
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var curCol = tableCpt.dataModel.columns[this.selectedTableTds.srcColIndex];
    var newCol = {
      width: curCol.width
    };
    var borderStyle = "";

    if (tableCpt.dataModel.borderWidth) {
      borderStyle = tableCpt.dataModel.borderWidth + "px solid " + (tableCpt.dataModel.borderColor ? tableCpt.dataModel.borderColor : "#000000");
    }

    var tableEl = $("#" + this.selectedTableTds.tableId);
    tableCpt.dataModel.columns.splice(this.selectedTableTds.srcColIndex, 0, newCol);
    tableCpt.dataModel.rows.forEach(function (row, index) {
      var newCell = {
        "cols": 1,
        "rows": 1,
        "components": []
      };
      var curRowEl = tableEl.children("tbody").children("tr").eq(index);
      var curCellEl = curRowEl.children("td").eq(_this3.selectedTableTds.srcColIndex);
      var curCell = row.cells[_this3.selectedTableTds.srcColIndex];
      var newCellHtml = "<td "; //if(curCell.rows>1) newCellHtml += " rowspan=\""+curCell.rows+"\"";
      //if(curCell.cols>1) newCellHtml += " colspan=\""+curCell.cols+"\"";

      if (curCell.align) newCellHtml += " align=\"" + curCell.align + "\"";
      if (curCell.valign) newCellHtml += " align=\"" + curCell.valign + "\"";
      newCellHtml += " style=\"width:" + curCol.width + "px;";

      if (curCell.hidden) {
        //先在当前行查找当前合并的起始单元格
        var tmpCellIndex = _this3.selectedTableTds.srcColIndex; //是否是在当前行内合并的单元格

        var isCurRowSpanCell = false;

        while (tmpCellIndex > 0) {
          tmpCellIndex--;
          var cellTmp = row.cells[tmpCellIndex]; //如果遇到非隐藏单元格

          if (!cellTmp.hidden) {
            //如果该单元格的行进行了合并，则判断是否是包含当前单元格
            if (cellTmp.cols > 1 && cellTmp.cols > _this3.selectedTableTds.srcColIndex - tmpCellIndex) {
              cellTmp.cols++;
              var cellElTmp = curRowEl.children("td").eq(tmpCellIndex);
              cellElTmp.attr("colspan", cellTmp.cols);
              newCell.hidden = true;
              isCurRowSpanCell = true;
            }

            tmpCellIndex++;
            break;
          }
        }

        if (!isCurRowSpanCell) {
          if (position == "right") {
            newCell.hidden = true;
          } else if (tmpCellIndex < _this3.selectedTableTds.srcColIndex) {
            newCell.hidden = true;
          }
        }
      } else if (curCell.cols > 1) {
        //如果当前当前单元格是合并的起始单元格，且在右侧添加列
        //则该单元格合并列数加1，该行新加的单元格隐藏
        if (position == "right") {
          newCell.hidden = true;
          curCell.cols++;
          curCellEl.attr("colspan", curCell.cols);
        }
      }

      if (curCell.bgColor) newCellHtml += "background-color:" + cellNew.bgColor + ";";
      if (newCell.hidden) newCellHtml += "display:none;";
      if (tableCpt.dataModel.cellPadding) newCellHtml += "padding:" + tableCpt.dataModel.cellPadding + "px;";

      if (tableCpt.dataModel.borderWidth) {
        newCellHtml += "border-bottom:" + borderStyle + "; border-right:" + borderStyle + ";";
      }

      newCellHtml += "\"></td>";
      var newCellEl = null;

      if (position == "left") {
        row.cells.splice(_this3.selectedTableTds.srcColIndex, 0, newCell);
        $(newCellHtml).insertBefore(curCellEl);
        newCellEl = curRowEl.children("td").eq(_this3.selectedTableTds.srcColIndex);
      } else {
        row.cells.splice(_this3.selectedTableTds.srcColIndex + 1, 0, newCell);
        $(newCellHtml).insertAfter(curCellEl);
        newCellEl = curRowEl.children("td").eq(_this3.selectedTableTds.srcColIndex + 1);
      }

      if (index == 0) {
        newCellEl.css("border-top", borderStyle);
      }

      if (newCellEl.index() == 0) {
        newCellEl.css("border-left", borderStyle);
      }

      _this3.bindTableTdEvent(_this3.selectedTableTds.tableId, newCellEl.get(0));
    });

    if (position == "left") {
      this.selectedTableTds.srcColIndex++;
      this.selectedTableTds.curColIndex++;
      this.resetCptColIndex(tableCpt, this.selectedTableTds.srcColIndex, true);
    } else {
      this.resetCptColIndex(tableCpt, this.selectedTableTds.srcColIndex + 1, true);
    }

    this.resetTableWidth(tableCpt);
  };

  this.delCol = function () {
    var _this4 = this;

    event.stopPropagation();
    $("#divTableColSetting").hide();
    if (!this.selectedTableTds || this.selectedTableTds.srcColSpan != 1) return;
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var tableEl = $("#" + this.selectedTableTds.tableId);
    tableCpt.dataModel.columns.splice(this.selectedTableTds.srcColIndex, 1);
    tableCpt.dataModel.rows.forEach(function (row, index) {
      var curRowEl = tableEl.children("tbody").children("tr").eq(index);
      var curCellEl = curRowEl.children("td").eq(_this4.selectedTableTds.srcColIndex);
      var curCell = row.cells[_this4.selectedTableTds.srcColIndex];

      if (curCell.hidden) {
        //先在当前行查找当前合并的起始单元格
        var tmpCellIndex = _this4.selectedTableTds.srcColIndex; //是否是在当前行内合并的单元格

        var isCurRowSpanCell = false;

        while (tmpCellIndex > 0) {
          tmpCellIndex--;
          var cellTmp = row.cells[tmpCellIndex]; //如果遇到非隐藏单元格

          if (!cellTmp.hidden) {
            //如果该单元格的行进行了合并，则判断是否是包含当前单元格
            if (cellTmp.cols > 1 && cellTmp.cols > _this4.selectedTableTds.srcColIndex - tmpCellIndex) {
              cellTmp.cols--;
              var cellElTmp = curRowEl.children("td").eq(tmpCellIndex);
              cellElTmp.attr("colspan", cellTmp.cols);
              isCurRowSpanCell = true;
            }

            tmpCellIndex++;
            break;
          }
        }
      } else if (curCell.cols > 1) {
        var nextCell = row.cells[_this4.selectedTableTds.srcColIndex + 1];
        nextCell.cols = curCell.cols - 1;
        nextCell.rows = curCell.rows;
        delete nextCell["hidden"];
        var nextCellEl = curRowEl.children("td").eq(_this4.selectedTableTds.srcColIndex + 1);
        nextCellEl.attr("colspan", nextCell.cols > 1 ? nextCell.cols : "");
        nextCellEl.attr("rowspan", nextCell.rows > 1 ? nextCell.rows : "");
        nextCellEl.show();
      }

      row.cells.splice(_this4.selectedTableTds.srcColIndex, 1);
      curCellEl.remove();
    });
    $("#divTableToolBar").find("div:not(.table-move)").hide();
    this.resetCptColIndex(tableCpt, this.selectedTableTds.srcColIndex, false);
    this.selectedTableTds = null;
    this.resetTableWidth(tableCpt);
  };

  this.resetTableWidth = function (tableCpt) {
    var totalWidth = 0;
    tableCpt.dataModel.columns.forEach(function (col, index) {
      totalWidth += parseInt(col.width);
    });

    tableCpt._jqObj.css("width", totalWidth + "px");
  };

  this.setTableColWidth = function () {
    event.stopPropagation();
    $("#divTableColSetting").hide();
    if (!this.selectedTableTds || this.selectedTableTds.srcColSpan != 1) return;
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var curCol = tableCpt.dataModel.columns[this.selectedTableTds.srcColIndex];
    var args = {
      width: curCol.width
    };
    var that = this;
    tfp.openDialog("设置列宽", "tfp/src/components/table/SetTableColWidth.tfp", "200px", "130px", JSON.stringify(args), function (width) {
      curCol.width = width;
      var tableEl = $("#" + that.selectedTableTds.tableId);
      tableCpt.dataModel.rows.forEach(function (row, rowIndex) {
        var rowEl = tableEl.children("tbody").children("tr").eq(rowIndex);
        cellEl = rowEl.children("td").eq(that.selectedTableTds.srcColIndex);
        cellEl.css("width", width + ((width + '').indexOf("%") > 0 ? "" : "px"));
      });
      if ((width + '').indexOf("%") < 0) that.resetTableWidth(tableCpt);
    });
  };

  this.setCellStyle = function (tableCpt, cell, setting, rowIndex, colIndex) {
    delete cell["bgColor"];
    delete cell["align"];
    delete cell["valign"];
    delete cell["paddingLeft"];
    delete cell["paddingRight"];
    delete cell["paddingTop"];
    delete cell["paddingBottom"];
    delete cell["borderTopWidth"];
    delete cell["borderTopStyle"];
    delete cell["borderBottomWidth"];
    delete cell["borderBottomStyle"];
    delete cell["borderLeftWidth"];
    delete cell["borderLeftStyle"];
    delete cell["borderRightWidth"];
    delete cell["borderRightStyle"];

    for (var p in setting) {
      cell[p] = setting[p];
    }

    var rowEl = tableCpt._jqObj.children("tbody").children("tr").eq(rowIndex);

    var cellEl = rowEl.children("td").eq(colIndex); //cellEl.css("background-color", cell.bgColor ? cell.bgColor : "");

    cellEl.attr("align", cell.align ? cell.align : "");
    cellEl.attr("valign", cell.valign ? cell.valign : ""); //cellEl.css("padding-left", cell.paddingLeft ? cell.paddingLeft + "px" : "");
    //cellEl.css("padding-right", cell.paddingRight ? cell.paddingRight + "px" : "");
    //cellEl.css("padding-top", cell.paddingTop ? cell.paddingTop + "px" : "");
    //cellEl.css("padding-bottom", cell.paddingBottom ? cell.paddingBottom + "px" : "");

    if (cell.borderTopWidth) {
      cellEl.css("border-top", cell.borderTopWidth + "px " + cell.borderTopStyle + " #000000");
    } else {
      cellEl.css("border-top", "");
    }

    if (cell.borderBottomWidth) {
      cellEl.css("border-bottom", cell.borderBottomWidth + "px " + cell.borderBottomStyle + " #000000");
    } else {
      cellEl.css("border-bottom", "");
    }

    if (cell.borderLeftWidth) {
      cellEl.css("border-left", cell.borderLeftWidth + "px " + cell.borderLeftStyle + " #000000");
    } else {
      cellEl.css("border-left", "");
    }

    if (cell.borderRightWidth) {
      cellEl.css("border-right", cell.borderRightWidth + "px " + cell.borderRightStyle + " #000000");
    } else {
      cellEl.css("border-right", "");
    }
  };

  this.setCellSetting = function () {
    event.stopPropagation();
    $("#divTableRowSetting").hide();
    $("#divTableColSetting").hide();
    if (!this.selectedTableTds) return;
    var tableCpt = tfp.get(this.selectedTableTds.tableId);
    var args = {};
    var curCell = null;

    if (this.selectedTableTds.srcRowIndex == this.selectedTableTds.curRowIndex && this.selectedTableTds.srcColIndex == this.selectedTableTds.curColIndex) {
      curCell = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex].cells[this.selectedTableTds.srcColIndex];
      if (curCell.align) args.align = curCell.align;
      if (curCell.valign) args.valign = curCell.valign;
      if (curCell.bgColor) args.bgColor = curCell.bgColor;
      if (curCell.borderTopWidth) args.borderTopWidth = curCell.borderTopWidth;
      if (curCell.borderTopStyle) args.borderTopStyle = curCell.borderTopStyle;
      if (curCell.borderBottomWidth) args.borderBottomWidth = curCell.borderBottomWidth;
      if (curCell.borderBottomStyle) args.borderBottomStyle = curCell.borderBottomStyle;
      if (curCell.borderLeftWidth) args.borderLeftWidth = curCell.borderLeftWidth;
      if (curCell.borderLeftStyle) args.borderLeftStyle = curCell.borderLeftStyle;
      if (curCell.borderRightWidth) args.borderRightWidth = curCell.borderRightWidth;
      if (curCell.borderRightStyle) args.borderRightStyle = curCell.borderRightStyle;
    }

    var that = this;
    tfp.openDialog("单元格设置", "tfp/src/components/table/TableCellSetting.tfp", "360px", "250px", JSON.stringify(args), function (ret) {
      if (curCell) {
        that.setCellStyle(tableCpt, curCell, ret, that.selectedTableTds.srcRowIndex, that.selectedTableTds.srcColIndex);
      } else {
        for (var i = that.selectedTableTds.srcRowIndex; i <= that.selectedTableTds.curRowIndex; i++) {
          var row = tableCpt.dataModel.rows[i];

          for (var j = that.selectedTableTds.srcColIndex; j <= that.selectedTableTds.curColIndex; j++) {
            var cell = row.cells[j];
            that.setCellStyle(tableCpt, cell, ret, i, j);
          }
        }
      }
    });
  };

  this.bindTableTdEvent = function (tableId, td) {
    var that = this;
    $(td).mousedown(function () {
      that.tableTdOnMouseDown(tableId, this);
    });
    $(td).mousemove(function () {
      that.tableTdOnMouseMove(tableId, this);
    });
    $(td).mouseup(function () {
      that.tableTdOnMouseUp(tableId, this);
    });
    /*$(td).dblclick(function() {
        let html = $(this).html();
        let text = $(this).text();
        if (html.indexOf("<") < 0) {
            $(this).html("<input style=\"border:0;background-color:#FFFFFF; "
            +"border:0; width:"+$(this).width()+"px; height:"+$(this).height()+"px;\" "
            + "value=\"" + $(this).text() + "\" onblur=\"tfp.get('" + tableId + "').resetTdContent(this)\">");
            $(this).find("input").focus();
        }
    });*/
  };

  this.init = function (_pageDesigner) {
    this.pageDesigner = _pageDesigner;
    $("body").append("  <div id=\"divTableToolBar\" style=\"display: none;\">\n        <div class=\"table-move\" title=\"\u79FB\u52A8\u8868\u683C\" onclick=\"tableDesigner.talebMoveIconOnClick()\" onmousedown=\"tableDesigner.talebMoveIconOnMouseDown()\" style=\"background-image: url(../tfp/src/components/table/images/move.png);background-position:4px 4px;background-repeat: no-repeat;\">\n        </div>\n        <div class=\"cell-setting-split\" style=\"display: none;width:0; height: 16px; border-left: 1px solid #dddddd; margin-left: 3px; padding: 0; margin-right: 3px; border-radius: 0;\"></div>\n        <div class=\"cell-merge\" title=\"\u5408\u5E76\u5355\u5143\u683C\" onclick=\"tableDesigner.mergeTableCells()\" style=\"display: none;\">\n          <img src=\"../tfp/src/components/table/images/merge.png\">\n        </div>\n        <div class=\"cell-split\" title=\"\u62C6\u5206\u5355\u5143\u683C\" onclick=\"tableDesigner.splitTableCells()\" style=\"display: none;\">\n          <img src=\"../tfp/src/components/table/images/split.png\">\n        </div>\n        <div class=\"cell-setting\" title=\"\u5355\u5143\u683C\u8BBE\u7F6E\" style=\"display: none;\" onclick=\"tableDesigner.setCellSetting()\">\n          <img src=\"../tfp/src/components/table/images/cell-setting.png\">\n        </div>\n        <div class=\"row-setting-split\" style=\"display: none;width:0; height: 16px; border-left: 1px solid #dddddd; margin-left: 3px; padding: 0; margin-right: 3px; border-radius: 0;\"></div>\n        <div class=\"row-setting\" title=\"\u884C\u8BBE\u7F6E\" style=\"margin-left: 0; width: 32px;display: none;\" onclick=\"tableDesigner.showTableRowSetting()\">\n          <img src=\"../tfp/src/components/table/images/row-setting.png\">\n          <img src=\"../tfp/src/components/table/images/arrow-down.png\" style=\"width: 6px; height: 6px; margin-left: 2px; margin-right: 2px;\">\n        </div>\n        <div class=\"col-setting-split\" style=\"display: none;width:0; height: 16px; border-left: 1px solid #dddddd; margin-left: 3px; padding: 0; margin-right: 3px; border-radius: 0;\"></div>    \n        <div class=\"col-setting\" title=\"\u5217\u8BBE\u7F6E\" style=\"margin-left: 0; width: 32px;display: none;\" onclick=\"tableDesigner.showTableColSetting()\">\n          <img src=\"../tfp/src/components/table/images/col-setting.png\">\n          <img src=\"../tfp/src/components/table/images/arrow-down.png\" style=\"width: 6px; height: 6px; margin-left: 2px; margin-right: 2px;\">\n        </div>\n      </div>\n    \n      <div id=\"divTableRowSetting\" style=\"display: none;\">\n        <div title=\"\u8BBE\u7F6E\u884C\u9AD8\" style=\"margin-left: 0;\" onclick=\"tableDesigner.setTableRowHeight()\">\n          <img src=\"../tfp/src/components/table/images/set-width.png\">\n          <label>\u8BBE\u7F6E\u884C\u9AD8</label>\n        </div>\n        <div title=\"\u5728\u4E0A\u9762\u63D2\u5165\u884C\" onclick=\"tableDesigner.insertRow('before')\">\n          <img src=\"../tfp/src/components/table/images/insert-row-before.png\">\n          <label>\u5728\u4E0A\u9762\u63D2\u5165\u884C</label>\n        </div>\n        <div title=\"\u5728\u4E0B\u9762\u63D2\u5165\u884C\" onclick=\"tableDesigner.insertRow('after')\">\n          <img src=\"../tfp/src/components/table/images/insert-row-after.png\">\n          <label>\u5728\u4E0B\u9762\u63D2\u5165\u884C</label>\n        </div>\n        <div title=\"\u5220\u9664\u884C\" onclick=\"tableDesigner.delRow()\">\n          <img src=\"../tfp/src/components/table/images/del-row.png\">\n          <label>\u5220\u9664\u884C</label>\n        </div>\n      </div>\n    \n      <div id=\"divTableColSetting\" style=\"display: none;\">\n        <div title=\"\u8BBE\u7F6E\u5217\u5BBD\" onclick=\"tableDesigner.setTableColWidth()\">\n          <img src=\"../tfp/src/components/table/images/set-height.png\">\n          <label>\u8BBE\u7F6E\u5217\u5BBD</label>\n        </div>\n        <div title=\"\u5728\u5DE6\u8FB9\u63D2\u5165\u5217\" onclick=\"tableDesigner.insertCol('left')\">\n          <img src=\"../tfp/src/components/table/images/insert-col-before.png\">\n          <label>\u5728\u5DE6\u8FB9\u63D2\u5165\u5217</label>\n        </div>\n        <div title=\"\u5728\u53F3\u8FB9\u63D2\u5165\u5217\" onclick=\"tableDesigner.insertCol('right')\">\n          <img src=\"../tfp/src/components/table/images/insert-col-after.png\">\n          <label>\u5728\u53F3\u8FB9\u63D2\u5165\u5217</label>\n        </div>\n        <div title=\"\u5220\u9664\u5217\" onclick=\"tableDesigner.delCol()\">\n          <img src=\"../tfp/src/components/table/images/del-col.png\">\n          <label>\u5220\u9664\u5217</label>\n        </div>\n      </div>");
  };
}

window.tableDesigner = new TableDesigner();