"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Tabbar",
  "comment": "底部导航",
  "attrs": [{
    "name": "tabbarInfo",
    "comment": "底部导航信息",
    "type": "group",
    "items": [{
      "name": "options",
      "comment": "导航选项",
      "type": "Iconlist",
      "iswhich": '3'
    }, {
      "name": "selectednow",
      "comment": "当前选中",
      "type": "Int",
      "default": 0
    }, {
      "name": "tabcolor",
      "comment": "文字默认颜色",
      "type": "string",
      "default": "#888888"
    }, {
      "name": "selectedColor",
      "comment": "文字选中颜色",
      "type": "string",
      "default": "#2AA144"
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "50px",
    "position": "fixed",
    "z-index": "99",
    "left": "0",
    "bottom": "0",
    "right": "0",
    "display": "flex",
    "flex-direction": "row",
    "flex-wrap": "nowrap",
    "justify-content": "space-evenly",
    "align-items": "center",
    "background-color": "#ffffff"
  },
  "events": [{
    "name": "bindtap",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "点击时"
  }],
  "methods": [{
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }, {
    "name": "addOption",
    "comment": "添加选项",
    "args": [{
      "name": "option",
      "comment": "选项",
      "type": "Object"
    }]
  }]
};
exports["default"] = _default;