"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
var Tabbar = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Tabbar, _FormInput);

  var _super = _createSuper(Tabbar);

  function Tabbar(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Tabbar);
    return _super.call(this, __tfp, "Tabbar", dataModel, parent);
  } // 字体默认颜色


  (0, _createClass2["default"])(Tabbar, [{
    key: "tabcolor",
    get: function get() {
      return this.dataModel.tabcolor;
    },
    set: function set(value) {
      this.dataModel.tabcolor = value;

      if (this._jqObj) {
        this._jqObj.empty();

        for (var i = 0; i < this.dataModel.options.length; i++) {
          this.addOption(this.dataModel.options[i], true, i, this.dataModel.selectednow);
        }
      }
    } // 字体选中颜色

  }, {
    key: "selectedColor",
    get: function get() {
      return this.dataModel.selectedColor;
    },
    set: function set(value) {
      this.dataModel.selectedColor = value;

      if (this._jqObj) {
        this._jqObj.empty();

        for (var i = 0; i < this.dataModel.options.length; i++) {
          this.addOption(this.dataModel.options[i], true, i);
        }
      }
    } // 当前选中

  }, {
    key: "selectednow",
    get: function get() {
      return this.dataModel.selectednow;
    },
    set: function set(value) {
      this.dataModel.selectednow = value;

      if (this._jqObj) {
        this._jqObj.empty();

        for (var i = 0; i < this.dataModel.options.length; i++) {
          this.addOption(this.dataModel.options[i], true, i);
        }
      }
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      this.dataModel.options = value;
      this.setOptions(value);

      if (this._jqObj) {
        this._jqObj.empty();

        var selectednow = 0;

        if (this.dataModel.selectednow) {
          selectednow = this.dataModel.selectednow;
        }

        for (var i = 0; i < value.length; i++) {
          this.addOption(value[i], true, i);
        }
      }
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option, index) {
      var optionHtml = "";
      optionHtml += indent;

      if (index == this.dataModel.selectednow) {
        optionHtml += "<div class=\"tabbar_item\" style=\"width: 50%;display: flex;flex-direction: column;align-items: center;\">";

        if (option.srcJson2.type == 'iconfont') {
          optionHtml += "<div class=\"wxfpicon " + option.tabbarsrc2 + "\" style=\"font-size: 25px;";

          if (option.srcJson2.color) {
            optionHtml += "color:" + option.srcJson2.color + ';';
          }

          if (option.srcJson2.bgColor) {
            optionHtml += "background-color:" + option.srcJson2.bgColor + ';';
          }

          optionHtml += "\";></div>";
        } else if (option.srcJson2.type == 'httpurl') {
          optionHtml += "<div class=\"wxfpicon " + option.tabbarsrc2 + "\"></div>";
          optionHtml += "<img class=\"wx-image\" src=\"" + option.srcJson2.url + "\"\n        style=\"height: 25px;\"/>";
        } else if (option.srcJson2.type == 'url') {
          optionHtml += "<img class=\"wx-image\" src=\"" + this._tfp.getUrlRealPath(option.srcJson2.url) + "\"\n        style=\"height: 25px;\"/>";
        }

        optionHtml += "<div class=\"tabbar_name\" style=\"color:" + this.dataModel.selectedColor + ";\">" + option.tabbarname + "</div>\n";
      } else {
        optionHtml += "<div class=\"tabbar_item\" style=\"width: 50%;display: flex;flex-direction: column;align-items: center;\">";

        if (option.srcJson.type == 'iconfont') {
          optionHtml += "<div class=\"wxfpicon " + option.tabbarsrc1 + "\" style=\"font-size: 25px;";

          if (option.srcJson.color) {
            optionHtml += "color:" + option.srcJson.color + ';';
          }

          if (option.srcJson.bgColor) {
            optionHtml += "background-color:" + option.srcJson.bgColor + ';';
          }

          optionHtml += "\";></div>";
        } else if (option.srcJson.type == 'httpurl') {
          optionHtml += "<div class=\"wxfpicon " + option.tabbarsrc1 + "\"></div>";
          optionHtml += "<img class=\"wx-image\" src=\"" + option.srcJson.url + "\"\n        style=\"height: 25px;\"/>";
        } else if (option.srcJson.type == 'url') {
          optionHtml += "<img class=\"wx-image\" src=\"" + this._tfp.getUrlRealPath(option.srcJson.url) + "\"\n        style=\"height: 25px;\"/>";
        }

        optionHtml += "<div class=\"tabbar_name\" style=\"color:" + this.dataModel.tabcolor + ";\">" + option.tabbarname + "</div>\n";
      }

      optionHtml += "</div>\r\n";
      return optionHtml;
    }
  }, {
    key: "getOptionWx",
    value: function getOptionWx(indent, option, index) {
      var optionHtml = "";
      optionHtml += indent;

      if (index == this.dataModel.selectednow) {
        optionHtml += "\t<view class=\"tabbar_item\" style=\"width: 50%;display: flex;flex-direction: column;align-items: center;\" bindtap=\"bindclick_toNewPage\" data-url=\"" + option.tabjumpUrl + "\" data-type=\"redirectTo\">\n";

        if (option.srcJson2.type == 'iconfont') {
          optionHtml += "\t\t\t<view class=\"wxfpicon " + option.tabbarsrc2 + "\" style=\"font-size: 25px;";

          if (option.srcJson2.color) {
            optionHtml += "color:" + option.srcJson2.color + ';';
          }

          if (option.srcJson2.bgColor) {
            optionHtml += "background-color:" + option.srcJson2.bgColor + ';';
          }

          optionHtml += "\"></view>";
        } else if (option.srcJson2.type == 'httpurl') {
          optionHtml += "\t\t\t<image class=\"wx-image\" src=\"" + option.srcJson2.url + "\"\n        style=\"height:25px;width: 25px;\"/>";
        } else if (option.srcJson2.type == 'url') {
          optionHtml += "\t\t\t<image class=\"wx-image\" wx-if=\"{{apiUrl}}\" src=\"{{apiUrl}}" + this._tfp.getUrlRealPath(option.srcJson2.url) + "\"\n        style=\"height:25px;width: 25px;\"/>";
        }

        optionHtml += "<view class=\"tabbar_name\" style=\"color:" + this.dataModel.selectedColor + ";\">" + option.tabbarname + "</view>\n";
      } else {
        optionHtml += "\t<view class=\"tabbar_item\" style=\"width: 50%;display: flex;flex-direction: column;align-items: center;\" bindtap=\"bindclick_toNewPage\" data-url=\"" + option.tabjumpUrl + "\" data-type=\"redirectTo\">\n";

        if (option.srcJson.type == 'iconfont') {
          optionHtml += "<view class=\"wxfpicon " + option.tabbarsrc1 + "\" style=\"font-size: 25px;";

          if (option.srcJson.color) {
            optionHtml += "color:" + option.srcJson.color + ';';
          }

          if (option.srcJson.bgColor) {
            optionHtml += "background-color:" + option.srcJson.bgColor + ';';
          }

          optionHtml += "\"></view>";
        } else if (option.srcJson.type == 'httpurl') {
          optionHtml += "\t\t\t<image class=\"wx-image\" src=\"" + option.srcJson.url + "\"\n        style=\"height:25px;width: 25px;\"/>";
        } else if (option.srcJson.type == 'url') {
          optionHtml += "\t\t\t<image class=\"wx-image\" wx-if=\"{{apiUrl}}\" src=\"{{apiUrl}}" + this._tfp.getUrlRealPath(option.srcJson.url) + "\"\n        style=\"height:25px;width: 25px;\"/>";
        }

        optionHtml += "<view class=\"tabbar_name\" style=\"color:" + this.dataModel.tabcolor + ";\">" + option.tabbarname + "</view>\n";
      }

      optionHtml += "\t\t</view>\r\n";
      return optionHtml;
    }
  }, {
    key: "addOption",
    value: function addOption(option, isInit, index) {
      var indent = this.getHtmlIndent();
      var str = "";
      str += this.getOptionHtml(indent, option, index);

      if (str != "") {
        this._jqObj.append(str);

        if (!isInit) this.dataModel.options.push(option);
      }
    }
  }]);
  return Tabbar;
}(_controller.FormInput);

exports["default"] = Tabbar;