"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var TabRender = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(TabRender, _TFPComponentRender);

  var _super = _createSuper(TabRender);

  function TabRender(__tfp, _dataModel, _level) {
    var _this;

    (0, _classCallCheck2["default"])(this, TabRender);
    _this = _super.call(this, __tfp, _dataModel, _level);
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "getBodyHtml", function (getComponentsHtml) {
      var bodyHtml = "\r\n";
      var indent = this.getHtmlIndent();
      var title_selected = " tfp-tab-title-selected";
      if (this.dataModel.position == "bottom") title_selected = " tfp-tab-title-selected-bottom";
      if (this.dataModel.position == "left") title_selected = " tfp-tab-title-selected-right";
      if (this.dataModel.position == "right") title_selected = " tfp-tab-title-selected-left";
      var top = parseInt(this.dataModel.titleHeight) + 1;
      var left = parseInt(this.dataModel.titleWidth) + 1;
      if (this.dataModel.hideTabHeader) top = 0;
      var headBorderColor = "#ccc";
      if (this._tfp.curPage.bgColorMode == "dark") headBorderColor = "#666";
      var headStyle = " style=\"flex-direction:row;width:100%;height: " + top + "px;bottom:auto;top:0px;border-bottom:1px solid " + headBorderColor + ";border-right:none;border-left:none;\"";
      var titleStyle = "style=\"flex-basis: " + this.dataModel.titleWidth + "px;height:" + this.dataModel.titleHeight + "px;display: flex;justify-content: center;align-items: center;padding:0;\"";
      var pagesStyle = "style=\"top:" + top + "px;right:0px;bottom:0px;left:0px;\"";

      if (this.dataModel.position == "bottom") {
        headStyle = " style=\"flex-direction:row;width:100%;height: " + top + "px;bottom:0px;top:auto;border-top:1px solid " + headBorderColor + ";border-bottom:none;border-right:none;border-left:none;\"";
        titleStyle = "style=\"flex-basis: " + this.dataModel.titleWidth + "px;height:" + this.dataModel.titleHeight + "px;display: flex;justify-content: center;align-items: center;padding:0;\"";
        pagesStyle = "style=\"top:0px;right:0px;bottom:" + top + "px;left:0px;\"";
      } else if (this.dataModel.position == "left") {
        headStyle = " style=\"flex-direction:column;width:" + left + "px;height:100%;right:auto;left:0px;border-bottom:none;border-left:none;border-right:1px solid " + headBorderColor + ";\"";
        titleStyle = "style=\"flex-basis: " + this.dataModel.titleHeight + "px;width: " + this.dataModel.titleWidth + "px;height: " + this.dataModel.titleHeight + "px;display: flex;justify-content: flex-end;align-items: center;padding-right:10px;\"";
        pagesStyle = "style=\"top:0px;right:0px;bottom:0px;left:" + left + "px;\"";
      } else if (this.dataModel.position == "right") {
        headStyle = " style=\"flex-direction:column;width:" + left + "px;height:100%;left:auto;right:0px;border-bottom:none;border-left:none;border-left:1px solid " + headBorderColor + ";\"";
        titleStyle = "style=\"flex-basis: " + this.dataModel.titleHeight + "px;width: " + this.dataModel.titleWidth + "px;height: " + this.dataModel.titleHeight + "px;display: flex;justify-content: flex-start;align-items: center;padding-left:10px;\"";
        pagesStyle = "style=\"top:0px;right:" + left + "px;;bottom:0px;left:0px;\"";
      }

      bodyHtml += indent + "\t<div class=\"tfp-tab-head\" " + headStyle + ">\r\n";

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          var tabPageDM = this.dataModel.components[i];
          bodyHtml += indent + "\t\t<div class=\"tfp-tab-title";

          if (i == this.dataModel.pageIndex) {
            bodyHtml += title_selected;
          } else {
            if (!tabPageDM.styles) tabPageDM.styles = {};
            tabPageDM.styles["display"] = "none";
          }

          var dot = '';

          if (tabPageDM.icon) {
            var iconSize = 20;
            if (tabPageDM.iconSize) iconSize = tabPageDM.iconSize;
            iconSize = this._tfp.getPx(iconSize);
            var iconRadius = 4;
            if (tabPageDM.iconRadius || tabPageDM.iconRadius + "" == "0") iconRadius = tabPageDM.iconRadius;
            iconRadius = this._tfp.getPx(iconRadius);

            if (tabPageDM.icon.type == "url") {
              dot = "<img src=\"" + tabPageDM.icon.url + "\" style=\"width:" + iconSize + "px; height:" + iconSize + "px; margin-right:5px;border-radius: " + iconRadius + "px;\">";
            } else {
              dot = "<span class=\"" + tabPageDM.icon["class"] + "\" style=\" margin-right:5px;border-radius: " + iconRadius + "px; " + "font-size:" + iconSize + "px;height:" + iconSize + "px;line-height:" + iconSize + "px;" + "background-color:" + tabPageDM.icon.bgColor + ";color:" + tabPageDM.icon.color + ";\"></span>";
            }
          }

          bodyHtml += "\" " + titleStyle + ">" + dot + "" + tabPageDM.title + "</div>\r\n";
        }
      }

      bodyHtml += indent + "\t</div>\r\n";
      bodyHtml += indent + "\t<div class=\"tfp-tab-pages\" " + pagesStyle + ">\r\n";

      if (this.dataModel.components && getComponentsHtml) {
        bodyHtml += this.getComponentsHtml(getComponentsHtml, indent);
      }

      bodyHtml += indent + "\t</div>\r\n";
      return bodyHtml + indent;
    });
    return _this;
  }

  (0, _createClass2["default"])(TabRender, [{
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(TabRender.prototype), "getHtml", this).call(this, "div", getComponentsHtml, parentIndent, retainStyleAttr);
    }
  }]);
  return TabRender;
}(_render["default"]);

exports["default"] = TabRender;