"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 选项卡组件
 * @param {[type]} dataModel [description]
 */
var Tab = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(Tab, _ContainerComponent);

  var _super = _createSuper(Tab);

  function Tab(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Tab);
    _this = _super.call(this, __tfp, "Tab", dataModel, parent);

    if (!_this.dataModel.components || _this.dataModel.components.length == 0) {
      _this.dataModel.components = [{
        id: _this.id + "_page1",
        type: "TabPage",
        isAttached: true,
        title: "page1",
        iconSize: 20,
        iconRadius: 4
      }, {
        id: _this.id + "_page2",
        type: "TabPage",
        title: "page2",
        iconSize: 20,
        iconRadius: 4,
        isAttached: true,
        styles: {
          display: "none"
        }
      }];
    }

    return _this;
  }

  (0, _createClass2["default"])(Tab, [{
    key: "pages",
    get: function get() {
      var pages = [];

      for (var i = 0; i < this.dataModel.components.length; i++) {
        var tabPageDM = this.dataModel.components[i];
        pages.push({
          id: tabPageDM.id,
          type: "TabPage",
          title: tabPageDM.title,
          icon: tabPageDM.icon,
          iconSize: tabPageDM.iconSize,
          iconRadius: tabPageDM.iconRadius
        });
      }

      return pages;
    },
    set: function set(value) {
      var pages = [];
      if (value) pages = value;
      var tabPages = [];
      if (this.dataModel.pageIndex >= pages.length) this.dataModel.pageIndex = pages.length - 1;
      if (this.dataModel.pageIndex < 0) this.dataModel.pageIndex = 0;

      for (var i = 0; i < pages.length; i++) {
        var page = pages[i];
        var cdm = null;

        if (page.id) {
          var tabPage = this._tfp.components[page.id];
          cdm = tabPage.dataModel;
          cdm.title = page.title;
          cdm.icon = page.icon;
          cdm.iconSize = page.iconSize;
          cdm.iconRadius = page.iconRadius;
          if (cdm.styles && cdm.styles.display) delete cdm.styles["display"];
          delete this._tfp.components[tabPage.id];
        } else {
          cdm = {
            type: "TabPage",
            isAttached: true,
            title: page.title,
            icon: page.icon,
            iconSize: page.iconSize,
            iconRadius: page.iconRadius
          };
        }

        if (i != this.dataModel.pageIndex) {
          if (cdm.styles) {
            cdm.styles.display = "none";
          } else {
            cdm.styles = {
              display: "none"
            };
          }
        }

        tabPages.push(cdm);
      }

      this.dataModel.components = tabPages;

      this._jqObj.remove();

      this.render();
      if (this.dataModel.components.length > 0) this.showTabPage(0);
    }
  }, {
    key: "pageIndex",
    get: function get() {
      return this.dataModel.pageIndex;
    },
    set: function set(value) {
      this.dataModel.pageIndex = value;
      if (this._jqObj) this.showTabPage(value);
    }
  }, {
    key: "titleWidth",
    get: function get() {
      return this.dataModel.titleWidth;
    },
    set: function set(value) {
      this.dataModel.titleWidth = this._tfp.getPx(value);

      if (this._jqObj) {
        // this.setTabStyle();
        this._jqObj.remove();

        this.render();
        if (this.dataModel.components.length > 0) this.showTabPage(0);
      }
    }
  }, {
    key: "titleHeight",
    get: function get() {
      return this.dataModel.titleHeight;
    },
    set: function set(value) {
      this.dataModel.titleHeight = this._tfp.getPx(value);

      if (this._jqObj) {
        // this.setTabStyle();
        this._jqObj.remove();

        this.render();
        if (this.dataModel.components.length > 0) this.showTabPage(0);
      }
    }
  }, {
    key: "hideTabHeader",
    get: function get() {
      return this.dataModel.hideTabHeader ? true : false;
    },
    set: function set(value) {
      this.dataModel.hideTabHeader = value ? true : false;

      if (this.dataModel.hideTabHeader) {
        this._jqObj.children(".tfp-tab-head").hide();

        this._jqObj.children(".tfp-tab-pages").css({
          "top": "0",
          "right": "0",
          "bottom": "0",
          "left": "0"
        });
      } else {
        this._jqObj.children(".tfp-tab-head").show(); // this.setTabStyle();


        this._jqObj.remove();

        this.render();
        if (this.dataModel.components.length > 0) this.showTabPage(0);
      }
    }
  }, {
    key: "position",
    get: function get() {
      return this.dataModel.position;
    },
    set: function set(value) {
      this.dataModel.position = value; // this.setTabStyle();

      this._jqObj.remove();

      this.render();
      if (this.dataModel.components.length > 0) this.showTabPage(0);
    }
  }, {
    key: "containerEl",
    get: function get() {
      return this._jqObj.children(".tfp-tab-pages").get(0);
    }
  }, {
    key: "hasAttachedChilds",
    get: function get() {
      return true;
    } // setTabStyle() {
    //   let top = parseInt(this.dataModel.titleHeight) + 1;
    //   let left = parseInt(this.dataModel.titleWidth) + 1;
    //   if (this.dataModel.position == "bottom") {
    //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "row", "width": "100%", "height": top + "px", "top": "auto", "bottom": "0px", "border-top": "1px solid #ccc", "border-bottom": "none", "border-right": "none", "border-left": "none" });
    //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "center", "padding": "0" });
    //     this._jqObj.children(".tfp-tab-pages").css({ "top": "0px", "right": "0px", "bottom": top + "px", "left": "0px" });
    //   } else if (this.dataModel.position == "left") {
    //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "column", "width": left + "px", "height": "100%", "right": "auto", "left": "0px", "border-bottom": "none", "border-left": "none", "border-right": "1px solid #ccc" });
    //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleHeight, "width": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "right", "padding-right": "10px" });
    //     this._jqObj.children(".tfp-tab-pages").css({ "top": "0px", "right": "0px", "bottom": "0px", "left": left + "px" });
    //   } else if (this.dataModel.position == "right") {
    //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "column", "width": left + "px", "height": "100%", "left": "auto", "right": "0px", "border-bottom": "none", "border-right": "none", "border-left": "1px solid #ccc" });
    //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleHeight, "width": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "left", "padding-left": "10px" });
    //     this._jqObj.children(".tfp-tab-pages").css({ "top": "0px", "right": left + "px", "bottom": "0px", "left": "0px" });
    //   } else {
    //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "row", "width": "100%", "height": top + "px", "bottom": "auto", "top": "0px", "border-bottom": "1px solid #ccc", "border-right": "none", "border-left": "none" });
    //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "center", "padding": "0" });
    //     this._jqObj.children(".tfp-tab-pages").css({ "top": top + "px", "right": "0px", "bottom": "0px", "left": "0px" });
    //   }
    //   if (this._jqObj) this.showTabPage(this.dataModel.pageIndex);
    // }

  }, {
    key: "showTabPage",
    value: function showTabPage(index) {
      var title_selected = "tfp-tab-title-selected";
      if (this.dataModel.position == "bottom") title_selected = "tfp-tab-title-selected-bottom";
      if (this.dataModel.position == "left") title_selected = "tfp-tab-title-selected-right";
      if (this.dataModel.position == "right") title_selected = "tfp-tab-title-selected-left";

      var _titleHeight = this._tfp.getPx(this.dataModel.titleHeight);

      this._jqObj.children(".tfp-tab-pages").children(".tfp-tabpage").hide();

      this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").removeClass("tfp-tab-title-selected tfp-tab-title-selected-bottom tfp-tab-title-selected-right tfp-tab-title-selected-left");

      this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").css("height", _titleHeight + "px");

      this._jqObj.children(".tfp-tab-pages").children(".tfp-tabpage").eq(index).show();

      this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").eq(index).addClass(title_selected); //this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").eq(index).css("height", (_titleHeight-1)+"px");


      if (!this._tfp.isDesigning) {
        this.dataModel.pageIndex = index;

        for (var i = 0; i < this.dataModel.components.length; i++) {
          var tabPageDM = this.dataModel.components[i];

          if (i == index) {
            if (tabPageDM.styles) delete tabPageDM.styles["display"];
          } else {
            if (!tabPageDM.styles) tabPageDM.styles = {};
            tabPageDM.styles["display"] = "none";
          }
        }
      }

      if (this.dataModel.onTabIndexChange && !this._tfp.isDesigning) eval(this.dataModel.onTabIndexChange);
    }
  }, {
    key: "setBadgeNumber",
    value: function setBadgeNumber(index, number) {
      var num = number;
      if (number > 99) num = '99+';
      var rightStyle = 'right: 1.25rem;transform: translate(100%);';
      if (this.dataModel.position == 'right') rightStyle = 'right: 0rem;';
      if (this.dataModel.position == 'left') rightStyle = 'left: 0rem;';
      var badgeHtml = "<sup style=\"position: absolute;top: 0;" + rightStyle + "background: red;display: inline-flex;align-items: center;justify-content: center;line-height: 18px;border-radius: 10px;height: 18px;padding: 0 6px;color: white;font-size: 12px;\">" + num + "</sup>";

      this._jqObj.find(".tfp-tab-title").eq(index).css("position", "relative");

      this._jqObj.find(".tfp-tab-title").eq(index).append(badgeHtml);
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").each(function (index) {
        $(this).click(function () {
          that.showTabPage(index);
        });
      });

      if (this.pageIndex != 0) {
        this.showTabPage(this.pageIndex);
      } else {
        var _titleHeight = this._tfp.getPx(this.dataModel.titleHeight); //this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").eq(0).css("height", (_titleHeight-1)+"px");

      }
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this._tfp.isDesigning) this.initRuntime();
    }
  }]);
  return Tab;
}(_controller.ContainerComponent);

exports["default"] = Tab;