"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Switch",
  "comment": "开关",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "组件值",
      "type": "String"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "options",
      "comment": "选项",
      "type": "Dataset",
      "count": 2,
      "columns": [{
        "id": "value",
        "name": "可选值",
        "type": "String",
        "required": true
      }],
      "default": [false, true]
    }, {
      "name": "controlColor",
      "comment": "组件颜色",
      "type": "text",
      "default": "#04BE02"
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "formula",
      "comment": "自动计算表达式",
      "type": "Formula"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }]
  }],
  "styles": ["position", "margin", "other"],
  "events": [{
    "name": "bindchange",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "值发生变化时"
  }]
};
exports["default"] = _default;