"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Switch",
  "comment": "开关",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "组件值",
      "type": "String"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "options",
      "comment": "选项",
      "type": "Dataset",
      "count": 2,
      "columns": [{
        "id": "value",
        "name": "可选值",
        "type": "String",
        "required": true
      }],
      "default": [false, true]
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch",
      "isHtmlAttr": true
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }],
  "styles": ["position", "margin", "other"],
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;