"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Swiper",
  "comment": "轮播图",
  "attrs": [{
    "name": "swiperInfo",
    "comment": "轮播图信息",
    "type": "group",
    "items": [{
      "name": "interval",
      "comment": "自动播放间隔时长(ms)",
      "type": "numenumber",
      "default": "3000"
    }, {
      "name": "duration",
      "comment": "幻灯片切换时长(ms)",
      "type": "numenumber",
      "default": "1000"
    }, {
      "name": "previousMargin",
      "comment": "前边距(px)",
      "type": "numenumber",
      "default": "0"
    }, {
      "name": "nextMargin",
      "comment": "后边距(px)",
      "type": "numenumber",
      "default": "0"
    }, {
      "name": "aspectRatio",
      "comment": "宽高比(4:3)",
      "type": "String",
      "default": "4:3"
    }, {
      "name": "autoplay",
      "comment": "是否自动播放",
      "type": "Switch",
      "isHtmlAttr": false,
      "default": false
    }, {
      "name": "vertical",
      "comment": "是否竖向展示",
      "type": "Switch",
      "isHtmlAttr": false,
      "default": false
    }, {
      "name": "indicatorDots",
      "comment": "是否展示指示点",
      "type": "Switch",
      "isHtmlAttr": false,
      "default": false
    }, {
      "name": "circular",
      "comment": "是否衔接滑动",
      "type": "Switch",
      "isHtmlAttr": false,
      "default": false
    }, {
      "name": "options",
      "comment": "选项",
      "type": "Iconlist",
      "iswhich": '1'
    }]
  }, {
    "name": "dataSourceSetting",
    "comment": "数据源设置",
    "type": "group",
    "items": [{
      "name": "loadDataService",
      "comment": "数据加载服务",
      "type": "Service"
    }, {
      "name": "dataBindingMember",
      "comment": "数据绑定成员",
      "type": "String"
    }, {
      "name": "srcField",
      "comment": "图片绑定字段",
      "type": "String"
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "min-height": "150px"
  },
  "events": [{
    "name": "bindtap",
    "args": [{
      'name': 'e'
    }],
    "eventArgs": "",
    "comment": "点击时"
  }]
};
exports["default"] = _default;